<style type="text/css">
	.pop-main{
		width: 100%;
		height: 100%;
		overflow-y: auto;
		font-family: sans-serif;
		line-height: 1.5;
	}
	h3{
		font-size: 20px;
		margin: 0;
		padding: 10px 0;
	}
	p{
		margin: 0 0 10px 0;
	}
</style>
<div class="pop-main">
<h3>Accessibility Statement</h3>

<p><strong>Compliance status</strong></br> We firmly believe that the internet should be available and accessible to anyone and are committed to providing a website that is accessible to the broadest possible audience, regardless of ability.</p>
<p>To fulfill this, we aim to adhere as strictly as possible to the World Wide Web Consortium’s (W3C) Web Content Accessibility Guidelines 2.1 (WCAG 2.1) at the AA level. These guidelines explain how to make web content accessible to people with a wide array of disabilities. Complying with those guidelines helps us ensure that the website is accessible to blind people, people with motor impairments, visual impairment, cognitive disabilities, and more.</br></p>
<p>This website utilizes various technologies that are meant to make it as accessible as possible at all times. We utilize an accessibility interface that allows persons with specific disabilities to adjust the website’s UI (user interface) and design it to their personal needs.</br></p>
<p>Additionally, the website utilizes an AI-based application that runs in the background and optimizes its accessibility level constantly. This application remediates the website’s HTML, adapts its functionality and behavior for screen-readers used by blind users, and for keyboard functions used by individuals with motor impairments.</br></p>
<p>If you wish to contact the website’s owner please use the following email <strong>support@goldenafter50.com</strong></br></p>
<p><strong>Screen-reader and keyboard navigation</strong></br> </p>
<p>Our website implements the ARIA attributes (Accessible Rich Internet Applications) technique, alongside various behavioral changes, to ensure blind users visiting with screen-readers can read, comprehend, and enjoy the website’s functions. As soon as a user with a screen-reader enters your site, they immediately receive a prompt to enter the Screen-Reader Profile so they can browse and operate your site effectively. Here’s how our website covers some of the most important screen-reader requirements:</br></p>
<p>Screen-reader optimization: we run a process that learns the website’s components from top to bottom, to ensure ongoing compliance even when updating the website. In this process, we provide screen-readers with meaningful data using the ARIA set of attributes. For example, we provide accurate form labels; descriptions for actionable icons (social media icons, search icons, cart icons, etc.); validation guidance for form inputs; element roles such as buttons, menus, modal dialogues (popups), and others.</br></p>
<p>Additionally, the background process scans all of the website’s images. It provides an accurate and meaningful image-object-recognition-based description as an ALT (alternate text) tag for images that are not described. It will also extract texts embedded within the image using an OCR (optical character recognition) technology. To turn on screen-reader adjustments at any time, users need only to press the Alt+1 keyboard combination. Screen-reader users also get automatic announcements to turn the Screen-reader mode on as soon as they enter the website.</br></p>
<p>These adjustments are compatible with popular screen readers such as JAWS, NVDA, VoiceOver, and TalkBack.</br></p>
<p>Keyboard navigation optimization: The background process also adjusts the website’s HTML and adds various behaviors using JavaScript code to make the website operable by the keyboard. This includes the ability to navigate the website using the Tab and Shift+Tab keys, operate dropdowns with the arrow keys, close them with Esc, trigger buttons and links using the Enter key, navigate between radio and checkbox elements using the arrow keys, and fill them in with the Spacebar or Enter key.</br></p>
<p>Additionally, keyboard users will find content-skip menus available at any time by clicking Alt+2, or as the first element of the site while navigating with the keyboard. The background process also handles triggered popups by moving the keyboard focus towards them as soon as they appear, not allowing the focus to drift outside.</br></p>
<p>Users can also use shortcuts such as “M” (menus), “H” (headings), “F” (forms), “B” (buttons), and “G” (graphics) to jump to specific elements.</br></p>
<p><strong>Disability profiles supported on our website</strong></br></p>
<p>Epilepsy Safe Profile: this profile enables people with epilepsy to safely use the website by eliminating the risk of seizures resulting from flashing or blinking animations and risky color combinations. Vision Impaired Profile: this profile adjusts the website so that it is accessible to the majority of visual impairments such as Degrading Eyesight, Tunnel Vision, Cataract, Glaucoma, and others. Cognitive Disability Profile: this profile provides various assistive features to help users with cognitive disabilities such as Autism, Dyslexia, CVA, and others, to focus on the essential elements more easily. ADHD Friendly Profile: this profile significantly reduces distractions and noise to help people with ADHD, and Neurodevelopmental disorders browse, read, and focus on the essential elements more easily. Blind Users Profile (Screen-readers): this profile adjusts the website to be compatible with screen-readers such as JAWS, NVDA, VoiceOver, and TalkBack. A screen-reader is installed on the blind user’s computer, and this site is compatible with it. Keyboard Navigation Profile (Motor-Impaired): this profile enables motor-impaired persons to operate the website using the keyboard Tab, Shift+Tab, and the Enter keys. Users can also use shortcuts such as “M” (menus), “H” (headings), “F” (forms), “B” (buttons), and “G” (graphics) to jump to specific elements.</br></p>
<p><strong>Additional UI, design, and readability adjustments</strong></br></p>
<p>Font adjustments – users can increase and decrease its size, change its family (type), adjust the spacing, alignment, line height, and more.</br></p>
<p>Color adjustments – users can select various color contrast profiles such as light, dark, inverted, and monochrome.</br></p>
<p>Additionally, users can swap color schemes of titles, texts, and backgrounds with over seven different coloring options.</br></p>
<p>Animations – epileptic users can stop all running animations with the click of a button. Animations controlled by the interface include videos, GIFs, and CSS flashing transitions.</br></p>
<p>Content highlighting – users can choose to emphasize essential elements such as links and titles. They can also choose to highlight focused or hovered elements only.</br></p>
<p>Audio muting – users with hearing devices may experience headaches or other issues due to automatic audio playing. This option lets users mute the entire website instantly.</br></p>
<p>Cognitive disorders – we utilize a search engine linked to Wikipedia and Wiktionary, allowing people with cognitive disorders to decipher meanings of phrases, initials, slang, and others.</br></p>
<p>Additional functions – we allow users to change cursor color and size, use a printing mode, enable a virtual keyboard, and many other functions.</br></p>
<p><strong>Assistive technology and browser compatibility</strong></br></p>
<p>We aim to support as many browsers and assistive technologies as possible, so our users can choose the best fitting tools for them, with as few limitations as possible. Therefore, we have worked very hard to be able to support all major systems that comprise over 95% of the user market share, including Google Chrome, Mozilla Firefox, Apple Safari, Opera and Microsoft Edge, JAWS, and NVDA (screen readers), both for Windows and MAC users.</br></p>
<p><strong>Notes, comments, and feedback</strong></br></p>
<p>Despite our very best efforts to allow anybody to adjust the website to their needs, there may still be pages or sections that are not fully accessible, are in the process of becoming accessible, or are lacking an adequate technological solution to make them accessible. Still, we are continually improving our accessibility, adding, updating, improving its options and features, and developing and adopting new technologies. All this is meant to reach the optimal level of accessibility following technological advancements. If you wish to contact the website’s owner, please use the following email <strong>support@goldenafter50.com</strong></br></p>
</div>