
let cellFormat = [];
setShoppingCartSpinner();
var isVisited = true;
var isVisitedOnScroll = true;
var isVisitedOnLoad = true;
var isStickyBar = true;
var isVisitedStickyOnLoad = true;
let products = [];
let orderId;
let result = true;
let surveySectionCount = 1;
let progressBar = [];
let decrementSectionCount = 0;
let parentSection = "";
const percentage = "%";
const zeroPercentage = "0%";
let cartProduct = [];
let appliedCouponCode = "";
let address1FieldAutComplete;
let shipAddress1FieldAutComplete;
const memberFields = ["emailAddress", "phoneNumber", "address1", "address2", "city", "state", "country", "postalCode"];
fetchPageData();
let fkCart = sessionStorage.getItem("fkCart") !== null ? JSON.parse(sessionStorage.getItem("fkCart")) : {};
//get parameters from the URL query string
const urlParams = new URLSearchParams(getCurrentWindowLocation().search);
//Confirm PayPal
if (urlParams.has("paypalAccept") && urlParams.get("paypalAccept") === "1" && urlParams.has("token") && urlParams.has("PayerID")) {
    const token = urlParams.get("token");
    const payerID = urlParams.get("PayerID");
    const funnelData = sessionStorage.getItem("funnelData");
    if (funnelData)
        confirmPaypal(token, payerID);
    else {
        $.ajax({
            url: 'funnel.json?' + Date.now(),
            method: 'get',
            success: function (results) {
                sessionStorage.setItem("funnelData", JSON.stringify(results.funnelData));
                confirmPaypal(token, payerID);
            }
        });
    }
}
//support for products and variants from Shopify
//https://yourcheckoutpage.com/?products=productId:qty;productId:qty;...
//example:  https://yourcheckoutpage.com/?products=32.47:1;159:2;6:1
else if (urlParams.has("products")) {
    fkCart = {};
    const urlProducts = urlParams.get("products").split(";");
    for (const product of urlProducts) {
        const productData = product.split(":");
        fkCart[productData[0]] = productData[1];
    }
    sessionStorage.setItem("fkCart", JSON.stringify(fkCart));
}
//support for products from WooCommerce
else if (urlParams.has("productId")) {
    fkCart = {};
    const urlProduct = urlParams.get("productId");
    const urlProductQty = urlParams.has("qty") ? urlParams.get("qty") : 1;
    fkCart[urlProduct] = urlProductQty;
    sessionStorage.setItem("fkCart", JSON.stringify(fkCart));
}

if (urlParams.has("cartId")) {
    sessionStorage.setItem("cartId",urlParams.get("cartId"));
}

if (urlParams.has("errorMsg")) {
    alert("Error Processing Payment: " + urlParams.get("errorMsg"));
}

//Check if the session already available
if (!sessionStorage.length) {
    localStorage.setItem("getSessionStorageapp.funnelkonnekt.com", Date.now());
}

window.addEventListener("storage", function (event) {
    if (event.key === "getSessionStorageapp.funnelkonnekt.com") {
        localStorage.setItem("sessionStorageapp.funnelkonnekt.com", JSON.stringify(sessionStorage));
        localStorage.removeItem("sessionStorageapp.funnelkonnekt.com");
    } else if (event.key === "sessionStorageapp.funnelkonnekt.com" && !sessionStorage.length) {
        const eventData = JSON.parse(event.newValue);
        for (const key in eventData) {
            sessionStorage.setItem(key, eventData[key]);
        }
    } else if (event.key === "logOutapp.funnelkonnekt.com" && sessionStorage.length) {
        clubLogout();
    }
});
window.addEventListener("load", function () {
    const slideAttributes = document.querySelectorAll("button, a, input[type='checkbox'], input[type='radio']");
    slideAttributes.forEach((element) => {
        if (element.attributes.openid) {
			const hideLinkID = "#" + element.attributes.openid.value;
            $(hideLinkID).hide();
        }
        if (element.attributes.opensurveysection) {
			const nonSurveySectionID = "#" + element.attributes.opensurveysection.value;
            if ($(nonSurveySectionID) && !$(nonSurveySectionID).is(":hidden")) {
                $(nonSurveySectionID).hide();
                if ($(nonSurveySectionID)[0] && $(nonSurveySectionID)[0].className === "fk-section") {
                    if (parentSection === "" || parentSection !== element.parentElement.id) {
                        surveySectionCount++;
                    }
                    parentSection = element.parentElement.id;
                }
            }
        }
        if (element.attributes.openCheckBoxSection && element.attributes.openCheckBoxSection.value != "") {
            if (element.attributes[0].nodeValue == "radio") {
                const openCheckBoxSectionValue = element.attributes.openCheckBoxSection.value;
                if (openCheckBoxSectionValue) {
                    const checkedValue = element.checked;
                    if (checkedValue) {
                        $("#" + openCheckBoxSectionValue).slideDown();
                    } else {
                        $("#" + openCheckBoxSectionValue).hide();
                    }
                }
            } else {
                const shippingSectionID = "#" + element.attributes.openCheckBoxSection.value;
                if ($(shippingSectionID) && !$(shippingSectionID).is(":hidden")) {
                    $(shippingSectionID).hide();
                }
            }
        }
    });
    let surveyOptions = null;
    if (document.forms["survey-form-radio"]) {
        surveyOptions = document.forms["survey-form-radio"].getElementsByTagName("input");
    }
    if (surveyOptions && surveyOptions.length > 0) {
        for (const element of surveyOptions) {
            if (element.attributes.opensurveysection) {
                const nonSurveySectionID = "#" + element.attributes.opensurveysection.value;
                if ($(nonSurveySectionID) && !$(nonSurveySectionID).is(":hidden")) {
                    $(nonSurveySectionID).hide();
                    if ($(nonSurveySectionID)[0] && $(nonSurveySectionID)[0].className === "fk-section") {
                        if (parentSection === "" || parentSection !== element.parentElement.parentElement.id) {
                            surveySectionCount++;
                        }
                        parentSection = element.parentElement.parentElement.id;
                    }
                }
            }
        }
    }
    decrementSectionCount = surveySectionCount;
    progressBar = document.getElementById("progressbar");
    if (progressBar) {
        progressBar.style.width = zeroPercentage;
        progressBar.innerHTML = zeroPercentage;
    }
    const dynamicCartRow = document.querySelector("tr[id='fk-dynamic-cart-row']");
    if (dynamicCartRow) {
        displayPrices();
    }
    const productInputs = document.getElementsByName("product");
    if (productInputs) {
        for (const input of productInputs) {
            if (input.type === "checkbox" || input.type === "radio")
                input.addEventListener("click", function () { displayPrices(); });
        }
    }
    const paypalButtons = document.querySelectorAll(".btnPayPal, .btnPayPal2");
    for (let paypalButton of paypalButtons) {
        paypalButton.onclick = function (event) {
            sessionStorage.setItem("paySource", "PAYPAL");
            callMethod(event);
        };
    }
    autoLoadInputs();
    replaceTokens();
});
var price = 0;

function changeFaviconLink(url) {
    if (url && url.length > 0) {
        const link = $('head link[rel="shortcut icon"]') || $('head link[rel="icon"]');
        if (link && link.length > 0) {
            $(link).attr("href", url);
        } else {
            const newLink = $("<link>");
            newLink.attr("href", url)
            newLink.attr("rel", "shortcut icon");
            $("head").append(newLink);
        }
    }
}

function fetchPageData() {
    $.ajax({
        url: 'funnel.json?' + Date.now(),
        method: 'get',
        success: function (results) {
            var funnelData = results && !results.isFunnel ? results.funnelTemplateData : results.funnelData;
            const faviconUrl = results && results.faviconUrl;
            changeFaviconLink(faviconUrl);
            pageData.funnelData = funnelData;
            sessionStorage.setItem("funnelData", JSON.stringify(funnelData));
            pageData.funnelData.isVisualizer = funnelData && funnelData.isVisualizer || false;
            pageData.currentPage = getCurrentPage(funnelData);
            const funnelTitle = funnelData.title;
            funnelTitle ? $("title").text(funnelTitle) : $("title").text("Funnel Konnekt");
            pageData.pageTypeId = pageData.currentPage && pageData.currentPage.pageView[0].pageType;
            pageData.salt = funnelData.salt;
            sessionStorage.setItem("fk_salt", pageData.salt);
            pageData.navigationItems = results.elements.filter((element) => {
                return element.pageViewReferenceId === pageData.currentPage.pageView[0].referenceId;
            });
            $.ajax({
                url: 'campaign.json?' + Date.now(),
                success: function (campaignResults) {
                    pageData.selectedCampaign = campaignResults.selectedCampaign;
                    if (!document.URL.includes("funnels-build"))
                        getHeadCode();
                    initializePage();
                    const captureLeadArray = [2,4,15];
                    if(captureLeadArray.includes(pageData.pageTypeId))
                        window.setInterval(function(){captureLead()},10000);
                }
            });
        }
    });
}
function addBottomLogo() {
    $("body").append("<a style='position: fixed; left: 35px; bottom: -6px;' href='https://funnelkonnekt.com'><img style='width: 135px; height: 44px;' src='config.funnelkonnekt.com/assets/brandLogo.svg'></a>");
}
function getCurrentPage(funnelData) {
    var funnelPages = funnelData.pages;
    if (funnelPages && funnelPages.length) {
        const matchedPage = $.grep(funnelPages, function (page) {
            const currentPageView = page && page.pageView && page.pageView[0];
            if (currentPageView) {
                return currentPageView.referenceId === pageData.pageViewReferenceId;
            }
        });
        return matchedPage && matchedPage[0];

    }
    return null;
}
function addPhoneNumberSanitizer() {
    const phoneNumber = document.getElementsByName("phoneNumber")[0];
    if (phoneNumber) {
        phoneNumber.addEventListener("blur", () => {
            phoneNumber.value = phoneNumber.value.replace(/[^0-9+-]/g, "").replace(/[+]{1,}/g,"+").replace(/[-]{1,}/g,"-");
        });
    }
}
function initializePage() {
    if (pageData) {
        //import click need to be called on the load of every page, so I added this function to the template
        var pageType = pageData.pageTypeId;
        switch (pageType) {
            // Lead page
            case 2:
            case "Lead":
            case 15:
            case "Opt-in":
                pageType = "leadPage"
                initAddressFields();
                break;
            // Checkout Page
            case 4:
            case "Checkout":
                pageType = "checkoutPage"
                initSocialProof();
                initAddressFields();
                assignProdQtyEventListeners();
                removeNavigationOffersFromCart();
                sessionStorage.removeItem("upsalefkCart");
                break;
            // Upsell Page
            case 3:
            case "Upsell":
                pageType = "upsellPage";
                assignProdQtyEventListeners();
                break;
            // Thank You Page
            case 5:
            case "Thank You":
                pageType = "thankyouPage"
                updateMap();
                break;
            case 8:
            case "Profile":
                initAddressFields();
                break;
            case 1:
                // Clear shopping cart while loading Presell Page
                sessionStorage.removeItem("fkCart");
                break;
            case 31:
                document.getElementsByName("custom_restartDate")[0] && affixImports("js","https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js");
                break;
            default:
                pageType = "presellPage";
        }
        var session = sessionStorage.getItem("sessionId");
        if (session) {
            session = JSON.parse(session);
            useSession(session.message.sessionId, pageType).then(function (data) {
                if (data.result === "ERROR") {
                    $("body").append(useSession.message);
                }
                if (data.message && data.message.pixel) {
                    firePixel(data.message.pixel);
                }
            });
        } else {
            importClick(pageType).then(function (data) {
                if (data.result === "SUCCESS") {
                    var jsonStr = JSON.stringify(data);
                    sessionStorage.setItem("sessionId", jsonStr);
                    if (data.message && data.message.pixel) {
                        firePixel(data.message.pixel);
                    }
                } else {
                    $("body").append(data.message);
                }
                response = data;
            });
        }

    }
    const actualPageType = (pageData.funnelData && pageData.funnelData.isVisualizer) ? pageData.pageTypeId : (pageData.currentPage && pageData.currentPage.pageView[0].pageType);
    const isMemberPageType = isMembershipPage(actualPageType);
    if (isMemberPageType) {
        validateSession();
    }
    const queryString = getCurrentWindowLocation().search;
    const urlParams = new URLSearchParams(queryString);
    if (urlParams.has("alertMessage")) {
        const message = urlParams.get("alertMessage");
        const decodedMessage = decodeURI(message);
        $("body").append("<div class='alert alert-danger alert-dismissible fade show' role='alert' ><strong>" + decodedMessage + " </strong><button type='button' class='close' data-dismiss='alert' aria-label='Close'> <span aria-hidden='true'>&times;</span></button></div>");
    }
    if ((window && window.performance && window.performance.navigation) && ((window.performance.navigation.type === 0) || (navigator.userAgent.indexOf("Firefox") !== -1) && window.performance.navigation.type === 255)) {
        registerClick(0);
    }
    initializeCountryStates((pageData.pageTypeId === 8 || pageData.pageTypeId === "Profile") ? loadProfilePage : undefined );
    loadMonth();
    loadYear();
    loadShipProfiles();
    if (pageType === "checkoutPage") {
        displayPrices();
    }
    if (pageData.funnelData && pageData.funnelData.addOns && (pageData.pageTypeId === 4 || pageData.pageTypeId === 3)) {
        const paayKey = pageData.funnelData.addOns.filter((addOns) => addOns.keyName === "PAAY_API_key");
        if (paayKey.length !== 0 && paayKey[0].keyValue) {
            sessionStorage.setItem("paayEnabled", true);
            sessionStorage.removeItem("paayCompleted");
            sessionStorage.removeItem("paayInitialAsRebill");
            const paayPageOption = pageData.funnelData.addOns.filter((addOns) => addOns.keyName === "PAAY_page_option");
            sessionStorage.setItem("paay_page_option", paayPageOption[0].keyValue);
            if (paayPageOption.length === 0 || paayPageOption[0].keyValue === "2" || (pageData.pageTypeId === 4 && paayPageOption[0].keyValue === "0") || (pageData.pageTypeId === 3 && paayPageOption[0].keyValue === "1"))
                initializePAAY(paayKey[0].keyValue);
        }
    }
    if (window.location === window.parent.location) {
        affixImports("css", "../ui/1.12.0-rc.2/themes/smoothness/jquery-ui.css");
        affixImports("js","https://code.jquery.com/ui/1.12.0-rc.2/jquery-ui.min.js", configurePopup);
    }
    loadVariants();
    if (!pageData.funnelData.disableBadge && window.location === window.parent.location) {
        addBottomLogo();
    }
}

function removeNavigationOffersFromCart () {
    let fkCart = sessionStorage.getItem("fkCart") !== null ? JSON.parse(sessionStorage.getItem("fkCart")) : null;
    let offerItems = [];
    if (fkCart && Object.keys(fkCart).length > 0) {
        for (const offer in fkCart) {
            offerItems.push(String(offer));
        }
    }
    const buttonAndLinkItems = $("button, a");
    $(buttonAndLinkItems).each(function() {
        const offer = $(this).attr("offer");
        if (offerItems.includes(offer)) {
            delete fkCart[offer];
        }
    })
    sessionStorage.setItem("fkCart", JSON.stringify(fkCart));
}

function updateMap() {
    const orderData = JSON.parse(sessionStorage.getItem("orderData"));
    const requiredFields = ["shipAddress1", "shipAddress2", "shipCity", "shipState", "shipCountry"];
    let addressDetails = "";
    if (orderData) {
        requiredFields.forEach((field, index) => {
            if (orderData[field]) {
                addressDetails += (index === requiredFields.length -1) ? orderData[field] : orderData[field] + ", ";
            }
        });
        const mapElement = document.getElementsByName("map");
        if (mapElement && mapElement.length > 0) {
            mapElement.forEach((elem) => {
                const src = $(elem).attr("src") !== "" ? $(elem).attr("src") : $(elem).attr("data-src");
                const parseSrc = src.replace(/&q=.*?&/g, "&q=" + addressDetails + "&");
                $(elem).attr('src', parseSrc);
                $(elem).attr('data-src', parseSrc);
            })
        }
    }
}

function getHeadCode() {
    var funnelData = pageData.funnelData;
    if (funnelData.providers && funnelData.providers.length > 0) {
        pageData.funnelData.GA_MEASUREMENT_ID = funnelData.providers.filter((provider) => provider.id === 1).length !== 0 ? funnelData.providers.filter((provider) => provider.id === 1)[0].keyValue : null;
        pageData.funnelData.facebookPixelID = funnelData.providers.filter((provider) => provider.id === 2).length !== 0 ? funnelData.providers.filter((provider) => provider.id === 2)[0].keyValue : null;
        if (pageData.funnelData.GA_MEASUREMENT_ID !== null)
            getGoogleAnalyticsCode();
        if (pageData.funnelData.facebookPixelID !== null)
            getFacebookPixelCode();
    }
    if (funnelData.headTrackingCode) {
        if (funnelData.headTrackingCode.includes('<script')) {
            $('head').append(funnelData.headTrackingCode);
        } else {
            const headTrackingScript = document.createElement("script");
            headTrackingScript.innerHTML = funnelData.headTrackingCode;
            document.head.append(headTrackingScript);
        }
    }
    if (funnelData.bodyTrackingCode) {
        if (funnelData.bodyTrackingCode.includes('<script')) {
            $('body').append(funnelData.bodyTrackingCode);
        } else {
            const bodyTrackingScript = document.createElement("script");
            bodyTrackingScript.innerHTML = funnelData.bodyTrackingCode;
            document.body.append(bodyTrackingScript);
        }
    }
}
function getGoogleAnalyticsCode() {
    if(pageData.funnelData.GA_MEASUREMENT_ID.substring(0,3) === "GTM"){
        (function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
        new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
        j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
        'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
        })(window,document,'script','dataLayer',pageData.funnelData.GA_MEASUREMENT_ID);
        const noscript = document.createElement("noscript");
        const iframe = document.createElement("iframe");
        iframe.src = "https://www.googletagmanager.com/ns.html?id="+pageData.funnelData.GA_MEASUREMENT_ID;
        iframe.height = "0";
        iframe.width = "0";
        iframe.style.display = "none";
        iframe.style.visibility = "hidden";
        noscript.append(iframe);
        document.body.prepend(noscript);
    }
    else{
        $.getScript("https://www.googletagmanager.com/gtag/js?id=GA_MEASUREMENT_ID" + pageData.funnelData.GA_MEASUREMENT_ID, function () {
            window.dataLayer = window.dataLayer || [];
            function gtag() { dataLayer.push(arguments); }
            gtag('js', new Date());
            gtag('config', pageData.funnelData.GA_MEASUREMENT_ID);
        });
    }
}
function callPurchaseEvent(fbq, checkFlag) {
    const orderData = JSON.parse(sessionStorage.getItem("orderData"));
    const fbqCall = () => fbq('track', 'Purchase', {
        value: orderData.totalAmount,
        currency: pageData.selectedCampaign.currency
    });
    if (checkFlag) {
        sessionStorage.getItem("importOrderSuccess") === "true" && fbqCall();
        sessionStorage.removeItem("importOrderSuccess");
    } else {
        fbqCall();
    }
}
function getFacebookPixelCode() {
    !function (f, b, e, v, n, t, s) {
        if (f.fbq) return; n = f.fbq = function () {
            n.callMethod ?
                n.callMethod.apply(n, arguments) : n.queue.push(arguments)
        };
        if (!f._fbq) f._fbq = n; n.push = n; n.loaded = !0; n.version = '2.0';
        n.queue = []; t = b.createElement(e); t.async = !0;
        t.src = v; s = b.getElementsByTagName(e)[0];
        s.parentNode.insertBefore(t, s)
    }(window, document, 'script',
        'https://connect.facebook.net/en_US/fbevents.js');
    fbq('init', pageData.funnelData.facebookPixelID);
    const facebookPixel = document.createElement('img');
    facebookPixel.height = "1";
    facebookPixel.width = "1";
    facebookPixel.style.display = "none";
    facebookPixel.src = "https://www.facebook.com/tr?id=" + pageData.funnelData.facebookPixelID + "&ev=PageView&noscript=1";
    document.head.append(facebookPixel);
    const purchaseEventType = pageData.funnelData.addOns.find(({ keyName }) => keyName === "Purchase_Event_FB").keyValue;
    switch (pageData.pageTypeId) {
        // Presell page
        case 1:
            fbq('track', 'ViewContent');
            break;
        // Checkout Page
        case 4:
            fbq('track', 'AddToCart');
            break;
        // Upsell Page
        case 3:
            purchaseEventType == 2 && callPurchaseEvent(fbq , true);
            break;
        // Thank You Page
        case 5:
            purchaseEventType == 2 ? callPurchaseEvent(fbq , true) : callPurchaseEvent(fbq , false);
            break;
        default:
            break;
    }
}

function httpMethod(url, data, headerParams) {
    var loading = document.getElementById("loading");
    loading ? loading.style.display = "block !important" : null;
    return fetch(url, {
        method: "POST",
        mode: "cors",
        headers: headerParams ? headerParams : {
            "Content-Type": "application/json; charset=utf-8",
            "Cache-Control": "no-cache",
            "Access-Control-Allow-Origin": "*",
            companyToken: sessionStorage.getItem("fk_salt") !== null ? sessionStorage.getItem("fk_salt") : pageData.salt
        },
        body: data
    }).then(function (response) {
        return response.json();
    });
}

//TODO write test data function
function getIpAddress() {
    let response;
    $.ajax({
        async: false,
        type: "GET",
        // cors: true,
        // headers: {
        //     "Cache-Control": "no-cache",
        //     "Access-Control-Allow-Origin": "*"
        // },
        url: "https://api.ipify.org",
        success: function (result) {
            response = result;
        },
        error: function (xhr) {
            return xhr.status;
        }
    });
    return response;

}

function getPageType(pageTypeId) {
    let pageType = "";
    switch (pageTypeId) {
        // Lead page
        case 2:
        case 15:
            pageType = "leadPage";
            break;
        // Checkout Page
        case 4:
            pageType = "checkoutPage";
            break;
        // Upsell Page
        case 3:
            pageType = "upsellPage1";
            break;
        // Thank You Page
        case 5:
            pageType = "thankyouPage";
            break;
        default:
            pageType = "presellPage";
    }
    return pageType;
}
function addFunnelPageRefId(obj) {
    const isBuildOrTemplate = checkBuildOrTemplate();
    if(!isBuildOrTemplate){
        obj.funnelReferenceId = pageData.funnelReferenceId;
        obj.pageReferenceId = pageData.currentPage.referenceId;
    }
}
function importClick(pageType) {
    let obj = {};
    obj.pageType = typeof pageType !== "string" ? getPageType(pageType) : pageType;
    if (obj.pageType === "upsellPage")
        obj.pageType = "upsellPage1";
    obj.ipAddress = getIpAddress();
    obj.userAgent = navigator.userAgent;
    obj.campaignId = parseInt(pageData.funnelData.campaign);
    obj.requestUri = getCurrentWindowLocation().href;
    if (obj.pageType === "checkoutPage")
        obj.fraudPixel = 1;
    addFunnelPageRefId(obj);
    let data = JSON.stringify(obj);

    let response = httpMethod("https://api.funnelkonnekt.com/providersApi/V1/ImportClick/CreateSession", data);
    if (obj.pageType === 5 || obj.pageType === "thankyouPage") {
        confirmation();
    }
    return response;
}

function useSession(session, pageType) {
    let obj = {};

    obj.pageType = typeof pageType !== "string" ? getPageType(pageType) : pageType;
    if (obj.pageType === "upsellPage")
        obj.pageType = "upsellPage1";
    obj.sessionId = session;
    obj.userAgent = navigator.userAgent;
    if (obj.pageType === "checkoutPage")
        obj.fraudPixel = 1;
    addFunnelPageRefId(obj);
    let data = JSON.stringify(obj);

    let response = httpMethod("https://api.funnelkonnekt.com/providersApi/V1/ImportClick/UseSession", data);
    if (obj.pageType === 5 || obj.pageType === "thankyouPage") {
        confirmation();
    }

    return response;
}

function memberProductRoute(clubMembershipProducts, buttonProductData) {
    //Check the Arrow/Link with product
    const arrowWithMappedProducts = buttonProductData.linkDetails.filter((linkDetail) => clubMembershipProducts.some(productId => linkDetail.products.includes(productId)));

    if (arrowWithMappedProducts.length === 0) {
        //Get the Arrow with no product and redirect to that page
        const arrowWithNoProducts = buttonProductData.linkDetails.filter((linkDetail) => linkDetail.products.length === 0);
        const pageMappedWithArrow = pageData.funnelData.pages.filter((page) => arrowWithNoProducts.some(linkProduct => linkProduct.targetPageReferenceId === page.referenceId));
        const pageMappedWithClubProducts = pageMappedWithArrow.find(page => page.pageProducts.some(pageProductId => clubMembershipProducts.includes(pageProductId)));
        const pageWithNoProducts = pageMappedWithArrow.find(page => page.pageProducts.length === 0);
        if (pageMappedWithClubProducts) {
            setCurrentWindowLocation(redirectPath(pageMappedWithClubProducts, true));
        } else if (pageWithNoProducts) {
            setCurrentWindowLocation(redirectPath(pageWithNoProducts, true));
        } else {
            enableInteractions();
            alert("There are no products listed on the Page. Please contact customer service.");
        }
    } else {
        //Check arrow product and page product
        const selectedArrowPages = pageData.funnelData.pages.filter(page => {
            return arrowWithMappedProducts.some(linkProduct => linkProduct.targetPageReferenceId === page.referenceId);
        });

        const mappedPageProduct = selectedArrowPages.find(page => {
            return (page.pageProducts.some(productId => arrowWithMappedProducts.some(linkProduct => linkProduct.products.includes(productId))));
        });

        if (mappedPageProduct) {
            setCurrentWindowLocation(redirectPath(mappedPageProduct, true));
        } else if (selectedArrowPages.some(page => page.pageProducts.length === 0)) {
            const pageWithoutProduct = selectedArrowPages.find(page => page.pageProducts.length === 0);
            setCurrentWindowLocation(redirectPath(pageWithoutProduct, true));
        } else {
            enableInteractions();
            alert("There are no products listed on the Page. Please contact customer service.");
        }
    }
}

function isMembershipPage(pageType) {
    const membershipPageTypes = [7, 8, 9, 10, 11, 12, 13];
    return membershipPageTypes.includes(pageType);
}

function memberRoute(buttonProductData) {
    const membership = JSON.parse(sessionStorage.getItem("membership"));
    const clubMembershipProducts = membership.message.data.map(product => product.productId);
    memberProductRoute(clubMembershipProducts, buttonProductData);
}

//memberships
function clubQuery(clubId, memberId, productData, route) {
    let obj = {};
    // obj.clubId = clubId
    obj.memberId = memberId;
    const data = JSON.stringify(obj);
    const loginUrl = getCurrentWindowLocation().protocol + "//" + getCurrentWindowLocation().host + getCurrentWindowLocation().pathname;
    sessionStorage.setItem("loginUrl", loginUrl);
    const accessToken = localStorage.getItem("access_token");
    const tokenType = localStorage.getItem("token_type");
    const headers = {
        "Content-Type": "application/json; charset=utf-8",
        "Cache-Control": "no-cache",
        "Access-Control-Allow-Origin": "*",
        "CompanyToken": pageData.salt,
        "Authorization": tokenType + " " + accessToken
    };

    httpMethod("https://api.funnelkonnekt.com/providersApi/V1/ClubMembership/Query", data, headers).then(function (data) {
        if (data.result === "SUCCESS") {
            const jsonStr = JSON.stringify(data);
            sessionStorage.setItem("membership", jsonStr);
            const result = data.message;
            if (result && result.data[0].status === "ACTIVE") {
                const clubMembershipProducts = result.data.map(product => product.productId);
                memberProductRoute(clubMembershipProducts, productData);
            } else {
                setCurrentWindowLocation(route);
            }
        } else {
            setCurrentWindowLocation(route);
        }
    });
}

function redirectPath(navigationItem, shouldAppendDate = false) {
    const appendHtml = (shouldAppendDate) ? ".html?" + Date.now() : ".html";
    const targetPageUrlSlug = navigationItem.urlSlug;
    const targetPageViewReferenceId = (navigationItem.targetPageViewReferenceId) ? navigationItem.targetPageViewReferenceId : navigationItem.pageView[0].referenceId;
    return (targetPageUrlSlug) ? targetPageUrlSlug : targetPageViewReferenceId + appendHtml;
}

function checkBuildOrTemplate() {
    const buildOrTemplateUrls = ["funnels-build", "funneltemplates"];
    return buildOrTemplateUrls.some(url => getCurrentWindowLocation().href.includes(url));
}

function validateSession() {
    const expireIn = localStorage.getItem("expireIn");
    const access_token = localStorage.getItem("access_token");
    const currentUrl = getCurrentWindowLocation().href;
    let clubId = sessionStorage.getItem("clubId");
    clubId = parseInt(clubId);

    //7 = Membership Login Page
    const isLoginpage = pageData.currentPage.pageView[0].pageType === 7;
    const isBuildOrTemplate = checkBuildOrTemplate();

    //Check the Current Page has access to the procduct
    const clubMembershipProducts = getClubMembershipProducts();
    const isCurrentPageProductMatched = clubMembershipProducts.some(productId => pageData.currentPage.pageProducts.includes(productId) || pageData.currentPage.pageProducts.length === 0);

    if ((!isBuildOrTemplate && !isLoginpage && !isCurrentPageProductMatched && !access_token && !expireIn) || (!isBuildOrTemplate && !isLoginpage && !isCurrentPageProductMatched && access_token && expireIn)) {
        const loginPageDetail = pageData.funnelData.pages.find(page => page.pageView[0].pageType === 7);
        const redirectUrl = redirectPath(loginPageDetail) + "?alertMessage=Access Denied";
        const encodedUrl = encodeURI(redirectUrl);
        setCurrentWindowLocation(encodedUrl);
    }
}

function clubLogout() {
    const loginUrl = sessionStorage.getItem("loginUrl");
    setCurrentWindowLocation(loginUrl);
    sessionStorage.clear();
    localStorage.setItem("logOutapp.funnelkonnekt.com", Date.now());
    localStorage.clear();
}

function clubLogin(buttonId, clubId, productData) {
    let obj = {};
    obj.clubUsername = document.getElementsByName("userName")[0] ? document.getElementsByName("userName")[0].value : null;
    obj.clubPassword = document.getElementsByName("password")[0] ? document.getElementsByName("password")[0].value : null;
    obj.clubId = clubId;

    const data = JSON.stringify(obj);

    httpMethod("https://api.funnelkonnekt.com/providersApi/V1/ClubMembership/Login/", data).then(function (data) {
        let count = sessionStorage.getItem("count");

        if (count === null || count === undefined) {

            count = 0;
            sessionStorage.setItem("count", count);
        } else if (performance.navigation.type == 1) {
            count = sessionStorage.getItem("count");
        }
        if (data.result === "SUCCESS") {
            let route = null;
            count = 0;

            sessionStorage.setItem("count", count);

            const results = data.message;
            sessionStorage.setItem("count", count);
            sessionStorage.setItem("username", obj.clubUsername);
            sessionStorage.setItem("clubId", clubId);
            sessionStorage.setItem("memberId", results.memberId);

            localStorage.setItem("expireIn", results.expires_in);
            localStorage.setItem("token_type", "MembershipBearer");
            localStorage.setItem("access_token", results.access_token);

            if (data.message.status === "ACTIVE") {
                clubQuery(obj.clubId, results.memberId, productData);
            } else {
                const inActiveNavItem = pageData.navigationItems.find(element => element.status.toUpperCase() === "INACTIVE");
                const linkWithNoProduct = inActiveNavItem.linkDetails.find(linkDetail => linkDetail.products.length === 0);
                if (linkWithNoProduct) {
                    route = redirectPath(linkWithNoProduct, true);
                }
                clubQuery(obj.clubId, results.memberId, productData, route);
            }
        } else {
            /* Enabling the button again as we have disabled it onclick of the button (as part of restricting the double/triple click of the btton)
                * so that the user can try re-submitting
                */
            document.getElementsByTagName("button")[0].disabled = false;
            turnOffSpinner();
            alert("Username or Password is invalid");
            count++;
            sessionStorage.setItem("count", count);

            if (count >= 3) {
                document.getElementsByName("userName")[0].disabled = true;
                document.getElementsByName("password")[0].disabled = true;
                document.getElementsByTagName("button")[0].disabled = true;
                alert("Too many failed attempts, Account will be disabled for 3 minutes");
                setTimeout(function () {
                    document.getElementsByName("userName")[0].disabled = false;
                    document.getElementsByName("password")[0].disabled = false;
                    document.getElementsByTagName("button")[0].disabled = false;
                    count = 0;

                    sessionStorage.setItem("count", count);

                }, 180000);
            }
        }
    });
}
function restartMembership(route, clubId) {
    let membership = JSON.parse(sessionStorage.getItem("membership"));
    let obj = {};
    obj.purchaseId = membership.message.data[0].purchaseId;
    obj.reactivate = true;

    let data = JSON.stringify(obj);

    let accessToken = localStorage.getItem("access_token");
    let tokenType = localStorage.getItem("token_type");
    let headers = {
        "Content-Type": "application/json; charset=utf-8",
        "Cache-Control": "no-cache",
        "Access-Control-Allow-Origin": "*",
        "CompanyToken": pageData.salt,
        "Authorization": tokenType + " " + accessToken
    };

    let response = httpMethod("https://api.funnelkonnekt.com/providersApi/V1/Purchases/Update", data, headers).then(function (data) {
        if (data.result === "SUCCESS") {
            registerClick(1, function (regClickData) {
                membership.message.data[0].status = "ACTIVE";
                sessionStorage.setItem("membership", JSON.stringify(membership));
                alert("Membership has been restarted");
                setCurrentWindowLocation(route);
            });
        }
        else {
            enableInteractions();
            alert("There was an error restarting your membership, please contact customer service.");
        }
    })
}
function getClubId() {
    let clubId = "";
    let BreakException = {};
    try {
        pageData.selectedCampaign && pageData.selectedCampaign.products && pageData.selectedCampaign.products.forEach(function (product) {
            if (product.clubPluginId) {
                clubId = product.clubPluginId;
                throw BreakException;
            }
        });
    } catch (e) {
        if (e !== BreakException) throw e;
    }
    return clubId;
}
function resetMemberPassword() {
    let obj = {};
    obj.clubId = getClubId();
    obj.clubUsername = document.getElementsByName("userName")[0] ? document.getElementsByName("userName")[0].value : null;
    if (!obj.clubUsername) {
        alert("Please enter Username");
    }

    let data = JSON.stringify(obj)
    let response = httpMethod("https://api.funnelkonnekt.com/providersApi/V1/ClubMembership/Reset", data).then(function (data) {
        if (data.result === "SUCCESS") {
            alert(data.message);
        } else {
            alert(data.result);
        }
    })
}
function resetPW(route, clubId, memberId) {
    let obj = {};
    obj.clubId = clubId;
    obj.clubUsername = document.getElementsByName("userName")[0] ? document.getElementsByName("userName")[0].value : null;
    obj.clubPassword = document.getElementsByName("password")[0] ? document.getElementsByName("password")[0].value : null;
    if (obj.clubPassword !== document.getElementsByName("confirmPassword")[0]) {
        alert("Passwords do not match");
    }

    let data = JSON.stringify(obj)
    let response = httpMethod("https://api.funnelkonnekt.com/providersApi/V1/ClubMembership/Reset", data).then(function (data) {
        if (data.result === "SUCCESS") {
            alert("Password has been updated");
        }
    })
}
function cancelMembership(route, clubId, memberId) {

    let obj = {};

    let membership = JSON.parse(sessionStorage.getItem("membership"));

    obj.purchaseId = membership.message.data[0].purchaseId;

    let data = JSON.stringify(obj)

    let accessToken = localStorage.getItem("access_token");
    let tokenType = localStorage.getItem("token_type");
    let headers = {
        "Content-Type": "application/json; charset=utf-8",
        "Cache-Control": "no-cache",
        "Access-Control-Allow-Origin": "*",
        "CompanyToken": pageData.salt,
        "Authorization": tokenType + " " + accessToken
    };

    let response = httpMethod("https://api.funnelkonnekt.com/providersApi/V1/Purchases/Cancel", data, headers).then(function (data) {
        if (data.result === "SUCCESS") {
            registerClick(1, function (regClickData) {
                membership.message.data[0].status = 'CANCELLED';
                sessionStorage.setItem("membership", JSON.stringify(membership));
                alert("Membership has been cancelled");
                setCurrentWindowLocation(route);
            });
        } else {
            enableInteractions();
            alert("There was an error cancelling your membership, please contact customer service.");
        }
    })
}
function changeProduct(route, clubId, memberId) {
    let product_value;
    let newProduct = document.getElementsByName("product");
    newProduct.forEach(function (product) {
        if (product.checked) {
            product_value = product.value;
        }
    })
    let memberData = JSON.parse(sessionStorage.getItem("membership"));
    let purchaseId = memberData.message.data[0].purchaseId;
    memberData.message.data[0].productId = product_value;

    let obj = {};
    obj.productId = product_value;
    obj.purchaseId = purchaseId;

    let data = JSON.stringify(obj);

    let accessToken = localStorage.getItem("access_token");
    let tokenType = localStorage.getItem("token_type");
    let headers = {
        "Content-Type": "application/json; charset=utf-8",
        "Cache-Control": "no-cache",
        "Access-Control-Allow-Origin": "*",
        "CompanyToken": pageData.salt,
        "Authorization": tokenType + " " + accessToken
    };

    let response = httpMethod("https://api.funnelkonnekt.com/providersApi/V1/Purchases/Update", data, headers).then(function (data) {
        if (data.response === "SUCCESS") {
            registerClick(1, function (regClickData) {
                sessionStorage.setItem("membership", memberData);
                alert("Your product has been updated");
                setCurrentWindowLocation(route);
            });
        } else {
            enableInteractions();
            alert("There was an error processing your request, if problems persist please contact customer service");
        }
    })

}

function pauseMembership(route) {

    let obj = {};
    let customrestartDate = document.getElementsByName("custom_restartDate")[0];
    let date = customrestartDate ? customrestartDate.value : null;
    let membership = JSON.parse(sessionStorage.getItem("membership"));
    obj.purchaseId = membership.message.data[0].purchaseId;
    obj.priorToNextBill = 1;
    const momentDate = moment(date, "MM/DD/YYYY");
    if (date == null || !momentDate.isValid()) {
        enableInteractions();
        alert("Please enter a valid Restart Date");
        return;
    }
    obj.restartDate = moment(date, "MM/DD/YYYY").format("YYYY-MM-DD");
    let data = JSON.stringify(obj);

    let accessToken = localStorage.getItem("access_token");
    let tokenType = localStorage.getItem("token_type");
    let headers = {
        "Content-Type": "application/json; charset=utf-8",
        "Cache-Control": "no-cache",
        "Access-Control-Allow-Origin": "*",
        "CompanyToken": pageData.salt,
        "Authorization": tokenType + " " + accessToken
    };

    let response = httpMethod("https://api.funnelkonnekt.com/providersApi/V1/Purchases/Pause", data, headers).then(function (data) {
        if (data.result === "SUCCESS") {
            registerClick(1, function (regClickData) {
                membership.message.data[0].status = "PAUSED";
                sessionStorage.setItem("membership", JSON.stringify(membership));
                alert(data.message);
                setCurrentWindowLocation(route);
            });
        } else {
            enableInteractions();
            alert(data.message);
        }
    });
}

function updateCard(productData) {
	const membership = getMembershipDetails();
    const cardNumber = $('input[name="cardNumber"]').val();
    const cardMonth = $('select[name="cardMonth"]').val();
    const cardYear = $('select[name="cardYear"]').val();
    const cardSecurityCode = $('input[name="cardSecurityCode"]').val();
	const paySourceId = membership.message.data[0].paySourceId;
    if (/\d{12,16}/.test(cardNumber) && cardMonth && cardYear) {
        const obj = {
            cardNumber: cardNumber,
            cardMonth: cardMonth,
            cardYear: cardYear,
            cardSecurityCode: cardSecurityCode,
            paySourceId: paySourceId
        };
        const data = JSON.stringify(obj);
        const accessToken = localStorage.getItem("access_token");
        const tokenType = localStorage.getItem("token_type");
        const headers = {
            "Content-Type": "application/json; charset=utf-8",
            "Cache-Control": "no-cache",
            "Access-Control-Allow-Origin": "*",
            "CompanyToken": pageData.salt,
            "Authorization": tokenType + " " + accessToken
        };
        httpMethod("https://api.funnelkonnekt.com/providersApi/V1/ClubMembership/UpdateCard", data, headers).then(data => {
            if (data.result === "SUCCESS") {
                alert("Card Details have been updated successfully");
                memberRoute(productData);
            } else {
                enableInteractions();
                alert("error " + data.message);
            }
        });
    } else {
        enableInteractions();
        alert("Please provide valid card number, month, and year");
    }
}

function updateMember(route, clubId, callback) {
    let obj = {};
    obj.clubId = clubId;
    obj.memberId = sessionStorage.getItem("memberId");

    if (document.getElementsByName("newPassword")[0].value !== document.getElementsByName("confirmPassword")[0].value) {
        enableInteractions();
        $("#validationMessage").length ? $("#validationMessage").show() : alert("Passwords do not match");
    } else {
        $("#validationMessage").hide();
        obj.clubPassword = document.getElementsByName("newPassword")[0] ? document.getElementsByName("newPassword")[0].value : null;
        memberFields.forEach(field => {
            obj[field] = document.getElementsByName(field)[0] ? document.getElementsByName(field)[0].value : null;
        });

        const data = JSON.stringify(obj);

        const accessToken = localStorage.getItem("access_token");
        const tokenType = localStorage.getItem("token_type");
        const headers = {
            "Content-Type": "application/json; charset=utf-8",
            "Cache-Control": "no-cache",
            "Access-Control-Allow-Origin": "*",
            "CompanyToken": pageData.salt,
            "Authorization": tokenType + " " + accessToken
        };
        httpMethod("https://api.funnelkonnekt.com/providersApi/V1/ClubMembership/Update", data, headers).then(function (data) {
            if (data.result === "SUCCESS") {
                registerClick(1, function (regClickData) {
                    alert("Your profile has been updated");
                    if (route !== null)
                        setCurrentWindowLocation(route);

                    if (typeof callback === "function")
                        callback();
                });
            } else {
                enableInteractions();
                alert("error " + data.message);
            }
        });
    }
}

function captureLead() {
    const params = {};
    const inputs = $("input, select");
    for (const input of inputs) {
        if (input.name === "fullName") {
            let fullName = input.value.trim();
            let pos = fullName.indexOf(" ");
            params.firstName = (pos > -1) ? fullName.substring(0, pos) : fullName;
            params.lastName = (pos > -1) ? fullName.substring(pos + 1) : null;
        }
        else if (input.name === "shipFullName") {
            let fullName = input.value.trim();
            let pos = fullName.indexOf(" ");
            params.shipFirstName = (pos > -1) ? fullName.substring(0, pos) : fullName;
            params.shipLastName = (pos > -1) ? fullName.substring(pos + 1) : null;
        }
        else if (input.type === "checkbox" || input.type === "radio") {
            if (input.checked) {
                if (input.name !== "product")
                    params[input.name] = 1;
            }
        }
        else {
            params[input.name] = input.value;
        }
    }

    if (params.emailAddress) {
        const emailRegex = /^[a-z0-9._%+-]+@[a-z0-9.-]+.[a-z]{2,4}$/i;
        if(!emailRegex.test(params.emailAddress))
            params.emailAddress = null;
    }

    if(!params.emailAddress) {
        if((!params.firstName || !params.lastName) && (!params.shipFirstName || !params.shipLastName))
            return;

        if(!params.phoneNumber)
            return;
    }

    const orderData = JSON.parse(sessionStorage.getItem("orderData"));
    if(orderData && orderData.orderId)
        params.orderId = orderData.orderId;

    params.campaignId = parseInt(pageData.funnelData.campaign);

    if(!params.custom1)
        params.custom1 = pageData.funnelData.name;

    const orderItems = getOrderItems();
    let index = 0;
    for (const sessionItemCpId in orderItems) {
        index++;
        if (sessionItemCpId.indexOf(".") > 0) {
            const productData = sessionItemCpId.split(".");
            params['product' + index + '_id'] = productData[0];
            params['variant' + index + '_id'] = productData[1];
        } else {
            params['product' + index + '_id'] = sessionItemCpId;
        }
        params['product' + index + '_qty'] = orderItems[sessionItemCpId];
    }

    let session = sessionStorage.getItem("sessionId");
    session = JSON.parse(session);
    if (session)
        params.sessionId = session.message.sessionId;

    const leadParams = JSON.stringify(params);
    const existingParams = sessionStorage.getItem("leadParams");
    if(leadParams !== existingParams){
        sessionStorage.setItem("leadParams",leadParams);
        let response = httpMethod("https://api.funnelkonnekt.com/providersApi/V1/Import/Lead", leadParams).then(function (data) {
            if (data.result === "SUCCESS") {
                sessionStorage.setItem("orderData", JSON.stringify(data.message));
                const orderId = data.message.orderId;
                sessionStorage.setItem("orderId", JSON.stringify(orderId));
            }
    });
    }
}

function importLead(buttonId, route) {
    let obj = {};
    if (document.getElementsByName("fullName")[0]) {
        let fullName = document.getElementsByName("fullName")[0].value.trim();
        let pos = fullName.indexOf(" ");
        obj.firstName = (pos > -1) ? fullName.substring(0, pos) : fullName;
        obj.lastName = (pos > -1) ? fullName.substring(pos + 1) : null;
    } else {
        obj.firstName = document.getElementsByName("firstName")[0] ? document.getElementsByName("firstName")[0].value : null;
        obj.lastName = document.getElementsByName("lastName")[0] ? document.getElementsByName("lastName")[0].value : null;
    }
    obj.companyName = document.getElementsByName("companyName")[0] ? document.getElementsByName("companyName")[0].value : null;
    obj.address1 = document.getElementsByName("address1")[0] ? document.getElementsByName("address1")[0].value : null;
    obj.address2 = document.getElementsByName("address2")[0] ? document.getElementsByName("address2")[0].value : null;
    obj.postalCode = document.getElementsByName("postalCode")[0] ? document.getElementsByName("postalCode")[0].value : null;
    obj.city = document.getElementsByName("city")[0] ? document.getElementsByName("city")[0].value : null;
    obj.state = document.getElementsByName("state")[0] ? document.getElementsByName("state")[0].value : null;
    obj.country = document.getElementsByName("country")[0] ? document.getElementsByName("country")[0].value : "US";
    obj.emailAddress = document.getElementsByName("emailAddress")[0] ? document.getElementsByName("emailAddress")[0].value : null;
    obj.phoneNumber = document.getElementsByName("phoneNumber")[0] ? document.getElementsByName("phoneNumber")[0].value : null;
    obj.gender = document.getElementsByName("gender")[0] ? document.getElementsByName("gender")[0].value : null;
    obj.dob = document.getElementsByName("dob")[0] ? document.getElementsByName("dob")[0].value : null;
    obj.custom1 = document.getElementsByName("custom1")[0] ? document.getElementsByName("custom1")[0].value : null;
    obj.custom2 = document.getElementsByName("custom2")[0] ? document.getElementsByName("custom2")[0].value : null;
    obj.custom3 = document.getElementsByName("custom3")[0] ? document.getElementsByName("custom3")[0].value : null;
    obj.custom4 = document.getElementsByName("custom4")[0] ? document.getElementsByName("custom4")[0].value : null;
    obj.custom5 = document.getElementsByName("custom5")[0] ? document.getElementsByName("custom5")[0].value : null;

    if(!obj.custom1)
        obj.custom1 = pageData.funnelData.name;

    var inputs = $("input, select");

    inputs.each(function (index, input) {
        if (input.name.indexOf("custom_") >= 0) {
            obj[input.name] = input.value
        }
    })

    var sessionKeys = Object.keys(sessionStorage);
    sessionKeys.forEach(function (key) {
        if (key.indexOf("custom_") === 0)
            obj[key] = sessionStorage.getItem(key);
    })

    obj.billShipSame = document.getElementsByName("billShipSame")[0] && document.getElementsByName("billShipSame")[0].checked ? 1 : 0;
    obj.campaignId = parseInt(pageData.funnelData.campaign);
    fetchLeadDetails(obj);
    const orderItems = getOrderItems();
    const offer = getOfferFromNavigationItem(buttonId);
    if (offer) {
        orderItems[offer] = getQuantity();
        sessionStorage.setItem("fkCart", JSON.stringify(orderItems));
    }
    let index = 0;
    for (const sessionItemCpId in orderItems) {
        index++;
        if (sessionItemCpId.indexOf(".") > 0) {
            const productData = sessionItemCpId.split(".");
            obj['product' + index + '_id'] = productData[0];
            obj['variant' + index + '_id'] = productData[1];
        } else {
            obj['product' + index + '_id'] = sessionItemCpId;
        }
        obj['product' + index + '_qty'] = orderItems[sessionItemCpId];
    }

    let session = sessionStorage.getItem("sessionId");
    session = JSON.parse(session);
    if (session)
        obj.sessionId = session.message.sessionId;

    let data = JSON.stringify(obj);
    sessionStorage.setItem("userDetails", data);
    let response = httpMethod("https://api.funnelkonnekt.com/providersApi/V1/Import/Lead", data).then(function (data) {
        if (data.result === "SUCCESS") {
            registerClick(1, function (regClickData) {
                sessionStorage.setItem("orderData", JSON.stringify(data.message));
                //setting orderId to be used globally
                orderId = data.message.orderId;
                sessionStorage.setItem("orderId", JSON.stringify(orderId));
                sessionKeys.forEach(function (key) {
                    if (key.indexOf("custom_") === 0)
                        sessionStorage.removeItem(key);
                })
                setCurrentWindowLocation(route);
            });
        } else {
            let tag = document.getElementById("error-" + buttonId);

            if (tag === null) {
                tag = document.createElement("p");
                tag.setAttribute("id", "error-" + buttonId);
            } else {
                tag.innerHTML = '';
            }
            tag.innerHTML = data.message;

            const color = tag.style.color = "red";
            const form = $("button[data-id='" + buttonId + "']").length ? $("button[data-id='" + buttonId + "']") : $("a[data-id='" + buttonId + "']");

            $(tag).insertAfter(form);

            enableInteractions();
            return result = false;
        }
    });
}

var ProductType = {
    "offer": 0,
    "upsell": 1,
};

function getNavigationItemFromPageData(buttonId) {
    // {
    //     "elementId": "fkt-button-d312fcad-5eae-45f6-9e8d-4db6cd414ce0",
    //     "href": "",
    //     "status": null,
    //     "pageViewReferenceId": "e4c34dc7-be70-4be4-8db7-6588ce552ec6",
    //     "linkDetails": [],
    //     "products": []
    // },
    //Use pageData from session if pageData hasn't loaded from ajax before 2 click Paypal upsale processing
    if(!pageData.navigationItems && sessionStorage.getItem("paypalUpsalePageData"))
        pageData = JSON.parse(sessionStorage.getItem("paypalUpsalePageData"));
    return pageData.navigationItems.find((navItem) => navItem.elementId === buttonId);
}

function getProductInfoFromNavigationItem(type, buttonId) {
    const item = getNavigationItemFromPageData(buttonId);
    if (item && item.products && item.products.length) {
        return item.products[0];
    }
    return null;
}

function getOfferFromNavigationItem(buttonId) {
    return getProductInfoFromNavigationItem("offer", buttonId);
}

function getUpsellFromNavigationItem(buttonId) {
    return getProductInfoFromNavigationItem("upsell", buttonId);
}

function importOrder(buttonId, route) {
    let orderId = sessionStorage.getItem("orderId");
    orderId = JSON.parse(orderId);
    let obj = {};

    if (document.getElementsByName("fullName")[0]) {
        let fullName = document.getElementsByName("fullName")[0].value.trim();
        let pos = fullName.indexOf(" ");
        obj.firstName = (pos > -1) ? fullName.substring(0, pos) : fullName;
        obj.lastName = (pos > -1) ? fullName.substring(pos + 1) : null;
    } else {
        obj.firstName = document.getElementsByName("firstName")[0] ? document.getElementsByName("firstName")[0].value : null;
        obj.lastName = document.getElementsByName("lastName")[0] ? document.getElementsByName("lastName")[0].value : null;
    }
    obj.companyName = document.getElementsByName("companyName")[0] ? document.getElementsByName("companyName")[0].value : null;
    obj.address1 = document.getElementsByName("address1")[0] ? document.getElementsByName("address1")[0].value : null;
    obj.address2 = document.getElementsByName("address2")[0] ? document.getElementsByName("address2")[0].value : null;
    obj.postalCode = document.getElementsByName("postalCode")[0] ? document.getElementsByName("postalCode")[0].value : null;
    obj.city = document.getElementsByName("city")[0] ? document.getElementsByName("city")[0].value : null;
    obj.state = document.getElementsByName("state")[0] ? document.getElementsByName("state")[0].value : null;
    obj.country = document.getElementsByName("country")[0] ? document.getElementsByName("country")[0].value : "US";
    obj.emailAddress = document.getElementsByName("emailAddress")[0] ? document.getElementsByName("emailAddress")[0].value : null;
    obj.phoneNumber = document.getElementsByName("phoneNumber")[0] ? document.getElementsByName("phoneNumber")[0].value : null;
    obj.gender = document.getElementsByName("gender")[0] ? document.getElementsByName("gender")[0].value : null;
    obj.dob = document.getElementsByName("dob")[0] ? document.getElementsByName("dob")[0].value : null;
    obj.couponCode = document.getElementsByName("couponCode")[0] ? document.getElementsByName("couponCode")[0].value : null;
    obj.shipProfileId = document.getElementsByName("shipProfileId")[0] ? document.getElementsByName("shipProfileId")[0].value : null;
    obj.custom1 = document.getElementsByName("custom1")[0] ? document.getElementsByName("custom1")[0].value : null;
    obj.custom2 = document.getElementsByName("custom2")[0] ? document.getElementsByName("custom2")[0].value : null;
    obj.custom3 = document.getElementsByName("custom3")[0] ? document.getElementsByName("custom3")[0].value : null;
    obj.custom4 = document.getElementsByName("custom4")[0] ? document.getElementsByName("custom4")[0].value : null;
    obj.custom5 = document.getElementsByName("custom5")[0] ? document.getElementsByName("custom5")[0].value : null;

    if(!obj.custom1)
        obj.custom1 = pageData.funnelData.name;

    //Parameters that might be needed for native 3DS
    obj.redirectsTo = "https://"+getCurrentWindowLocation().hostname+"/"+pageData.funnelData.referenceId+"/"+route;
    obj.errorRedirectsTo = getCurrentWindowLocation().toString();

    var inputs = $("input, select");

    inputs.each(function (index, input) {
        if (input.name.indexOf("custom_") >= 0) {
            obj[input.name] = input.value
        }
    })
    var sessionKeys = Object.keys(sessionStorage);
    sessionKeys.forEach(function (key) {
        if (key.indexOf("custom_") === 0)
            obj[key] = sessionStorage.getItem(key);
    })

    if (document.getElementsByName("billShipSame")[0]) {
        obj.billShipSame = document.getElementsByName("billShipSame")[0].checked ? 1 : 0;
    } else if (document.getElementsByName("address1")[0] && !document.getElementsByName("shipAddress1")[0]) {
        obj.billShipSame = 1;
    }

    obj.cartId = sessionStorage.getItem("cartId");
    obj.campaignId = parseInt(pageData.funnelData.campaign);
	var offer = getOfferFromNavigationItem(buttonId);
	const buttonElement = document.querySelector("[data-id=" + buttonId + "]");
	const buttonVariantValue = buttonElement.getAttribute("variantvalue");
	//getting variant products
	getVariants();
	let orderItems = getOrderItems();
	if (offer) {
		if (Object.keys(orderItems).length === 0 && document.getElementsByName("price")[0] && !buttonVariantValue) {
			obj.product1_id = offer;
			obj.product1_qty = getQuantity();
			obj.product1_price = document.getElementsByName("price")[0].value;
		}
		else if (buttonVariantValue) {
			const itemOfferKey = offer + "." + buttonVariantValue;
			orderItems[itemOfferKey] = getQuantity();
			sessionStorage.setItem("fkCart", JSON.stringify(orderItems));
		}
		else {
			orderItems[offer] = getQuantity();
			sessionStorage.setItem("fkCart", JSON.stringify(orderItems));
		}
	}

    let index = 0;
    for (const sessionItemCpId in orderItems) {
        index++;
        if (sessionItemCpId.indexOf(".") > 0) {
            const productData = sessionItemCpId.split(".");
            obj['product' + index + '_id'] = productData[0];
            obj['variant' + index + '_id'] = productData[1];
        } else {
            obj['product' + index + '_id'] = sessionItemCpId;
        }
        obj['product' + index + '_qty'] = orderItems[sessionItemCpId];
    }
    calculateTotals();

    if (orderId) {
        obj.orderId = orderId;
    }
	fetchLeadDetails(obj);

	const cardDateVal = document.getElementsByName("cardDate")[0] ? (document.getElementsByName("cardDate")[0].value) : "";
	var cardDateValueParsed = cardDateVal.replace('/', '');
	if (cardDateValueParsed) {
		var month = cardDateValueParsed.substring(0, 2);
		var year = cardDateValueParsed.substr(cardDateValueParsed.length -2);
		obj.cardMonth = parseInt(month) || null;
		obj.cardYear = parseInt(year) || null;
	} else {
		obj.cardMonth = document.getElementsByName("cardMonth")[0] ? parseInt(document.getElementsByName("cardMonth")[0].value) : null;
		obj.cardYear = document.getElementsByName("cardYear")[0] ? parseInt(document.getElementsByName("cardYear")[0].value) : null;
	}
    obj.paySource = sessionStorage.getItem("paySource") !== null ? sessionStorage.getItem("paySource") : "CREDITCARD";
    obj.cardNumber = document.getElementsByName("cardNumber")[0] ? document.getElementsByName("cardNumber")[0].value : null;

    obj.cardSecurityCode = document.getElementsByName("cardSecurityCode")[0] ? document.getElementsByName("cardSecurityCode")[0].value : null;

    if(sessionStorage.getItem("paayEnabled") !== null && sessionStorage.getItem("paayCompleted") === null && obj.paySource === "CREDITCARD" && sessionStorage.getItem("paay_page_option") !== "1" && obj.cardNumber !== null && orderItems.length > 0){
        const firstCCDigit = obj.cardNumber.charAt(0);
        if (firstCCDigit !== "3" && firstCCDigit !== "6") {
            sessionStorage.setItem("paay_buttonId", buttonId);
            sessionStorage.setItem("paay_route", route);
            const paayItem = offer ? offer : Object.keys(orderItems)[0];
            sessionStorage.setItem("paay_item", paayItem);
            triggerPAAY();
            return;
        }
        else {
            sessionStorage.removeItem("paayEnabled");
        }
    }

    if (sessionStorage.getItem("paayInitialAsRebill") === "1") {
        obj.rebill_eci = document.getElementsByName("eci")[0] ? document.getElementsByName("eci")[0].value : null;
        obj.rebill_cavv = document.getElementsByName("cavv")[0] ? document.getElementsByName("cavv")[0].value : null;
        obj.rebill_xid = document.getElementsByName("xid")[0] ? document.getElementsByName("xid")[0].value : null;
    }
    else {
        obj.eci = document.getElementsByName("eci")[0] ? document.getElementsByName("eci")[0].value : null;
        obj.cavv = document.getElementsByName("cavv")[0] ? document.getElementsByName("cavv")[0].value : null;
        obj.xid = document.getElementsByName("xid")[0] ? document.getElementsByName("xid")[0].value : null;
        obj.rebill_eci = document.getElementsByName("rebill_eci")[0] ? document.getElementsByName("rebill_eci")[0].value : null;
        obj.rebill_cavv = document.getElementsByName("rebill_cavv")[0] ? document.getElementsByName("rebill_cavv")[0].value : null;
        obj.rebill_xid = document.getElementsByName("rebill_xid")[0] ? document.getElementsByName("rebill_xid")[0].value : null;
    }

    if (obj.paySource === "CREDITCARD" && sessionStorage.getItem("paayEnabled") !== null && (obj.eci !== null || sessionStorage.getItem("paay_page_option") === "1")) {
        sessionStorage.setItem("paay_pan", obj.cardNumber);
        sessionStorage.setItem("paay_month", obj.cardMonth);
        sessionStorage.setItem("paay_year", obj.cardYear);
    }

    let session = sessionStorage.getItem("sessionId");
    session = JSON.parse(session);
    if (session) {
        obj.sessionId = session.message.sessionId;
    }
    if (obj.paySource === "PAYPAL") {
        obj.paypalBillerId = parseInt(pageData.funnelData.addOns.find(({ keyName }) => keyName === "Paypal_billerId").keyValue);
        obj.salesUrl = getCurrentWindowLocation().href;
        sessionStorage.setItem("paypalSuccessRoute", route);
    }

    let data = JSON.stringify(obj);
    sessionStorage.setItem("userDetails", data);
    let response = httpMethod("https://api.funnelkonnekt.com/providersApi/V1/Import/Order", data).then(function (data) {
        if (data.result === "SUCCESS") {
            registerClick(1, function (regClickData) {
                //if paySource === "PAYPAL" -> redirect to paypalURL
                if (data.message.paypalUrl) {
                    setCurrentWindowLocation(data.message.paypalUrl);
                    return;
                }
                const salesProduct = [];
                sessionStorage.setItem("orderData", JSON.stringify(data.message));
                orderId = data.message.orderId;
                salesProduct.push(data.message.items);
                sessionStorage.setItem("orderId", JSON.stringify(orderId));
                sessionStorage.setItem("products", JSON.stringify(salesProduct[0]));
                sessionStorage.setItem("importOrderSuccess", true);
                sessionKeys.forEach(function (key) {
                    if (key.indexOf("custom_") === 0)
                        sessionStorage.removeItem(key);
                })
                sessionStorage.removeItem("cartId");
                setCurrentWindowLocation(route);
            });
        } else {
            sessionStorage.removeItem("paay_pan", obj.cardNumber);
            sessionStorage.removeItem("paay_month", obj.cardMonth);
            sessionStorage.removeItem("paay_year", obj.cardYear);

            //handle merchant redirect for native 3DS
            if(data.result === "MERC_REDIRECT"){
                if (data.message && data.message.url) {
                    setCurrentWindowLocation(data.message.url);
                } else if (data.message && data.message.script) {
                    eval(data.message.script);
                    return false;
                }
            }

            if (offer) {
                const orderItems = getOrderItems();
                delete orderItems[offer]
                sessionStorage.setItem("fkCart", JSON.stringify(orderItems));
            }

            let tag = document.getElementById("error-" + buttonId);

            if (tag === null) {
                tag = document.createElement("p");
                tag.setAttribute("id", "error-" + buttonId);
            } else {
                tag.innerHTML = '';
            }

            tag.innerHTML = data.message;
            const color = tag.style.color = "red";
            const form = $("button[data-id='" + buttonId + "']").length ? $("button[data-id='" + buttonId + "']") : $("a[data-id='" + buttonId + "']");

            $(tag).insertAfter(form);

            enableInteractions();
            return result = false;
        }
    });
}

function confirmPaypal(token, payerID) {
    if (token === null || payerID === null)
        return;

    //2 click Paypal upsells
    const upsaleRoute = sessionStorage.getItem("paypalUpsaleSuccessRoute");
    const upsaleButtonId = sessionStorage.getItem("paypalUpsaleButtonId");
    if(upsaleRoute && upsaleButtonId){
        sessionStorage.setItem("upsalePaypalToken",token);
        sessionStorage.setItem("upsalePaypalPayerId",payerID);
        importUpsale(upsaleButtonId,upsaleRoute);
        return;
    }

    const funnelData = JSON.parse(sessionStorage.getItem("funnelData"));
    data = {};
    data.token = token;
    data.payerId = payerID;
    data.orderId = JSON.parse(sessionStorage.getItem("orderId"));
    let session = sessionStorage.getItem("sessionId");
    session = JSON.parse(session);
    if (session) {
        data.sessionId = session.message.sessionId;
    }

    const fkCart = JSON.parse(sessionStorage.getItem("fkCart"));
    let index = 0;
    for (const sessionItemCpId in fkCart) {
        index++;
        if (sessionItemCpId.indexOf(".") > 0) {
            const productData = sessionItemCpId.split(".");
            data['product' + index + '_id'] = productData[0];
            data['variant' + index + '_id'] = productData[1];
        } else {
            data['product' + index + '_id'] = sessionItemCpId;
        }
        data['product' + index + '_qty'] = fkCart[sessionItemCpId];
    }

    data.cartId = sessionStorage.getItem("cartId");
    data.campaignId = parseInt(funnelData.campaign);
    data.paypalBillerId = parseInt(funnelData.addOns.find(({ keyName }) => keyName === "Paypal_billerId").keyValue);
    data.couponCode = null;
    data.shipProfileId = null;
    data = JSON.stringify(data);
    const response = httpMethod("https://api.funnelkonnekt.com/providersApi/V1/Import/Paypal", data).then(function (data) {
        if (data.result === "SUCCESS") {
            sessionStorage.setItem("orderData", JSON.stringify(data.message));
            sessionStorage.setItem("orderId", JSON.stringify(data.message.orderId));
            setCurrentWindowLocation(sessionStorage.getItem("paypalSuccessRoute"));
        }
        else {
            let tag = document.getElementById("error-paypal");
            if (tag === null) {
                tag = document.createElement("p");
                tag.setAttribute("id", "error-paypal");
            } else {
                tag.innerHTML = '';
            }
            tag.innerHTML = "Error Processing PayPal Payment: " + data.message;
            const color = tag.style.color = "red";
            const form = document.getElementsByTagName("form")[0];
            $(tag).insertBefore(form);
        }
    });
}


function importUpsale(buttonId, route) {

    let orderId = sessionStorage.getItem("orderId");
    orderId = JSON.parse(orderId);
    let obj = {};
    obj.orderId = orderId;
    // let upsell = pageData[buttonId].UPSELL;

    // getting product from button
    var upsell = getUpsellFromNavigationItem(buttonId);
	const upsellButtonElement = document.querySelector("[data-id=" + buttonId + "]");
	const upsellButtonVariantValue = upsellButtonElement.getAttribute("variantvalue");
    // getting variant products
    getVariants();

    // getting products from radio button or check box
    let orderItems = getUpsaleItems();

	// use button product or cart products
	if (upsell) {
		if (upsellButtonVariantValue) {
			const itemOfferKey = upsell + "." + upsellButtonVariantValue;
			orderItems[itemOfferKey] = getQuantity();
		} else {
			orderItems[upsell] = getQuantity();
		}
		sessionStorage.setItem("upsalefkCart", JSON.stringify(orderItems));
	}

    if(Object.keys(orderItems).length) {
        let index = 0;
        for (const upsaleItemCpId in orderItems) {
            index++;
            if (upsaleItemCpId.indexOf(".") > 0) {
                const productData = upsaleItemCpId.split(".");
                obj['product' + index + '_id'] = productData[0];
                obj['variant' + index + '_id'] = productData[1];
            } else {
                obj['product' + index + '_id'] = upsaleItemCpId;
            }
            obj['product' + index + '_qty'] = orderItems[upsaleItemCpId];
        }
    }

    //Parameters that might be needed for native 3DS
    obj.redirectsTo = "https://"+getCurrentWindowLocation().hostname+"/"+pageData.funnelData.referenceId+"/"+route;
    obj.errorRedirectsTo = getCurrentWindowLocation().toString();

    const orderData = JSON.parse(sessionStorage.getItem("orderData"));
    if (sessionStorage.getItem("paayEnabled") !== null && sessionStorage.getItem("paayCompleted") === null && orderData !== null && orderData.paySource === "CREDITCARD" && sessionStorage.getItem("paay_page_option") !== "0" && sessionStorage.getItem("paay_pan") !== null) {
        sessionStorage.setItem("paay_buttonId", buttonId);
        sessionStorage.setItem("paay_route", route);
        sessionStorage.setItem("paay_item", obj.product1_id);
        triggerPAAY();
        return;
    }

    if (sessionStorage.getItem("paayInitialAsRebill") === "1") {
        obj.rebill_eci = document.getElementsByName("eci")[0] ? document.getElementsByName("eci")[0].value : null;
        obj.rebill_cavv = document.getElementsByName("cavv")[0] ? document.getElementsByName("cavv")[0].value : null;
        obj.rebill_xid = document.getElementsByName("xid")[0] ? document.getElementsByName("xid")[0].value : null;
    }
    else {
        obj.eci = document.getElementsByName("eci")[0] ? document.getElementsByName("eci")[0].value : null;
        obj.cavv = document.getElementsByName("cavv")[0] ? document.getElementsByName("cavv")[0].value : null;
        obj.xid = document.getElementsByName("xid")[0] ? document.getElementsByName("xid")[0].value : null;
        obj.rebill_eci = document.getElementsByName("rebill_eci")[0] ? document.getElementsByName("rebill_eci")[0].value : null;
        obj.rebill_cavv = document.getElementsByName("rebill_cavv")[0] ? document.getElementsByName("rebill_cavv")[0].value : null;
        obj.rebill_xid = document.getElementsByName("rebill_xid")[0] ? document.getElementsByName("rebill_xid")[0].value : null;
    }

    if (orderData.paySource === "PAYPAL") {
        obj.paypalBillerId = parseInt(pageData.funnelData.addOns.find(({ keyName }) => keyName === "Paypal_billerId").keyValue);
        obj.salesUrl = getCurrentWindowLocation().href;

        //2 click Paypal upsells
        const token = sessionStorage.getItem("upsalePaypalToken");
        const payerId = sessionStorage.getItem("upsalePaypalPayerId");
        if(token && payerId){
            obj.token = token;
            obj.payerId = payerId;
        }
        else{
            sessionStorage.setItem("paypalUpsaleSuccessRoute", route);
            sessionStorage.setItem("paypalUpsaleButtonId",buttonId);
            sessionStorage.setItem("paypalUpsalePageData",JSON.stringify(pageData));
        }
    }

    let data = JSON.stringify(obj);
    if (orderId) {
        obj.orderId = orderId;
    }
    if (obj.product1_id) {
        let response = httpMethod("https://api.funnelkonnekt.com/providersApi/V1/Import/Upsale", data).then(function (data) {
            if (data.result === "SUCCESS") {
                registerClick(1, function (regClickData) {
                    //if paySource === "PAYPAL" and reference transactions not enabled -> redirect to paypalURL
                    if (data.message.paypalUrl) {
                        setCurrentWindowLocation(data.message.paypalUrl);
                        return;
                    }

                    sessionStorage.setItem("orderData", JSON.stringify(data.message));
                    sessionStorage.removeItem("products");
                    sessionStorage.setItem("products", JSON.stringify(data.message.items));

                    //clear out 2-click PayPal upsale session storage items
                    sessionStorage.removeItem("paypalUpsaleSuccessRoute");
                    sessionStorage.removeItem("paypalUpsaleButtonId");
                    sessionStorage.removeItem("upsalePaypalToken");
                    sessionStorage.removeItem("upsalePaypalPayerId");
                    sessionStorage.removeItem("paypalUpsalePageData");

                    // showing list of product in thanks page - merge on successful upsell
                    mergeOfferUpsale(orderItems);
                    setCurrentWindowLocation(route);
                });
            } else {
                //handle merchant redirect for native 3DS
                if(data.result === "MERC_REDIRECT"){
                    if (data.message && data.message.url) {
                        setCurrentWindowLocation(data.message.url);
                    } else if (data.message && data.message.script) {
                        eval(data.message.script);
                        return false;
                    }
                }
                let tag = document.getElementById("error-" + buttonId);

                if (tag === null) {
                    tag = document.createElement("p");
                    tag.setAttribute("id", "error-" + buttonId);
                } else {
                    tag.innerHTML = '';
                }
                tag.innerHTML = data.message;

                const color = tag.style.color = "red";
                const form = $("button[data-id='" + buttonId + "']").length ? $("button[data-id='" + buttonId + "']") : $("a[data-id='" + buttonId + "']");

                $(tag).insertAfter(form);

                enableInteractions();

                return result = false;
            }
        });
    } else {
        setCurrentWindowLocation(route);
    }
}

function confirmation(buttonId, route) {
    registerClick(1, function (regClickData) {
        const symbol = pageData.selectedCampaign.currencySymbol ? pageData.selectedCampaign.currencySymbol : '$';
        const userDetails = JSON.parse(sessionStorage.getItem("userDetails"));
        let listOfItem = '';
        let subTotal = 0.00;
        let totalShipping = 0.00;
        let totalDiscount = 0;
        let salesTax = 0;
        for (const key in userDetails) {
            if (key === 'state' || key === 'shipState' || key === 'country' || key === 'shipCountry') {
                const element = document.getElementById(key + '-field');
                element ? element.innerHTML = userDetails[key] : '';
            } else {
                const element = document.getElementById(key);
                element ? element.innerHTML = userDetails[key] : '';
            }
        }
        const orderData = JSON.parse(sessionStorage.getItem("orderData"));
        if (orderData) {
            const orderDataItems = orderData.items;
            const basePrice = parseFloat(orderData.subTotal);
            totalDiscount = orderData.totalDiscount ? parseFloat(orderData.totalDiscount) : 0;
            subTotal = parseFloat(basePrice + totalDiscount);
            totalShipping = parseFloat(orderData.shipTotal);
            salesTax = parseFloat(orderData.taxTotal);
            orderDataItems.length > 0 && orderDataItems.forEach(order => {
                const itemPrice = order.isPreauthVoid == "1" ? "0.00" : order.price;
                listOfItem += '<tr><td>' + order.name + '</td><td>' + order.qty + '</td><td style="text-align:right;"> ' + symbol + itemPrice + '</td></tr>';
            })
        } else {
            const products = JSON.parse(sessionStorage.getItem("products"));
            products && products.length > 0 && products.forEach(product => {
                const itemPrice = product.isPreauthVoid == "1" ? "0.00" : product.price;
                subTotal += parseFloat(itemPrice);
                totalShipping += parseFloat(product.shipping);
                listOfItem += '<tr><td>' + product.name + '</td><td>' + product.qty + '</td><td style="text-align:right;"> ' + symbol + itemPrice + '</td></tr>';
            });
        }
        $('#items-list').append(listOfItem);
        const paid = parseFloat(subTotal);
        const isDiscountInactive = '<tr><td colspan="3"><div class="total-prices"><div class="each-price"><label>Sub Total :</label> <span id="subTotal">' + symbol + paid.toFixed(2) + '</span></div><div class="each-price"><label>Shipping :</label> <span id="sAndHFee"> ' + symbol + totalShipping.toFixed(2) + '</span></div>[tax]<div class="each-price"><label>Grand Total: </label><span id="grandTotal"> ' + symbol + parseFloat(paid + salesTax + totalShipping).toFixed(2) + '</span></div></div></td></tr><style>.total-prices .each-price label { margin: 0;font-weight: 700;font-size: 18px;}.total-prices{margin-top:15px;padding-top:15px;text-align: right;border-top: 1px solid #277098;}</style>';
        const isDiscountActive = '<tr><td colspan="4"><div class="total-prices"><div class="each-price"><label>Sub Total :</label> <span id="subTotal">' + symbol + paid.toFixed(2) + '</span></div><div class="each-price"><label>Shipping :</label> <span id="sAndHFee"> ' + symbol + totalShipping.toFixed(2) + '</span></div>[tax]<div class="each-price"><label>Discount :</label> <span id="discount"> ' + '-' + symbol + totalDiscount.toFixed(2) + '</span></div><div class="each-price"><label>Grand Total: </label><span id="grandTotal"> ' + symbol + parseFloat(paid + salesTax + totalShipping - totalDiscount).toFixed(2) + '</span></div></div></td></tr><style>.total-prices .each-price label { margin: 0;font-weight: 700;font-size: 18px;}.total-prices{margin-top:15px;padding-top:15px;text-align: right;border-top: 1px solid #277098;}</style>';
        let invoiceFinal = totalDiscount === 0 ? isDiscountInactive :  isDiscountActive;
        const taxDiv = salesTax > 0 ? '<div class="each-price"><label>Sales Tax :</label> <span id="tax"> ' + symbol + salesTax.toFixed(2) + '</span></div>' : '';
        invoiceFinal = invoiceFinal.replace('[tax]',taxDiv);
        $('#items-list').append(invoiceFinal);
        const productsContainer = document.getElementById("productsContainer");

        const elem = document.getElementById("products");
        elem && elem.remove();

        const productsEL = document.createElement("tbody");
        productsEL.setAttribute("id", "products");

        productsContainer && productsContainer.appendChild(productsEL);


        let total = 0;

        products && products.length > 0 && products.map(function (product, i) {
            const tr = document.createElement("tr");
            const th = document.createElement("th");
            const td = document.createElement("td");
            const td1 = document.createElement("td");
            const productPrice = product.isPreauthVoid == "1" ? "0.00" : product.price;
            th.innerHTML = i + 1;
            td.innerHTML = product.name;
            td1.innerHTML = productPrice;
            total = total + parseInt(productPrice);
            tr.appendChild(th);
            tr.appendChild(td);
            tr.appendChild(td1);
            productsEL.appendChild(tr);
        });


        const tr = document.createElement("tr");
        const th = document.createElement("th");
        const td = document.createElement("td");
        const td1 = document.createElement("td");
        td.innerHTML = "Total";
        td1.innerHTML = total.toFixed(2);
        tr.appendChild(th);
        tr.appendChild(td);
        tr.appendChild(td1);
        productsEL.appendChild(tr);
        enableInteractions();
    });
}

function UpdateProduct(id) {
    productId = id;
}

function closePopup(elem, type) {
    if (type === 'id') {
        document.getElementById(elem).setAttribute("style", "display:none;");
        if (!isVisitedOnScroll || !isVisited || !isVisitedOnLoad) {
            document.getElementsByTagName("html")[0].style.removeProperty('overflow-y');
        }
    }
    else if (type === 'tag') {
        document.getElementsByTagName(elem)[0].setAttribute("style", "display:none;");
    }

}

function membershipRouteForPreview(route) {
    setCurrentWindowLocation(route);
}

function getClubMembershipProducts() {
    const membershipInfo = getMembershipDetails();
    return membershipInfo ? membershipInfo.message.data.map(product => product.productId) : [];
}

function getMembershipDetails() {
    return JSON.parse(sessionStorage.getItem("membership"))
}

function getButtonOrLinkData(buttonOrLink, pageType) {
    try {
        let buttonOrLinkData, fkCart;
        if (pageType) {
            getVariants();
            fkCart = sessionStorage.getItem("fkCart") !== null ? JSON.parse(sessionStorage.getItem("fkCart")) : {};
        }
        if (getMembershipDetails()) {
            const clubMembershipProducts = getClubMembershipProducts();
            const linkWithProducts = buttonOrLink && buttonOrLink.linkDetails.find(linkDetail => clubMembershipProducts.some(productId => linkDetail.products.includes(productId)));
            const linkWithOutProducts = buttonOrLink && buttonOrLink.linkDetails.find(linkDetail => !linkDetail.products.length);
            buttonOrLinkData = linkWithProducts ? linkWithProducts : linkWithOutProducts;
            if (!buttonOrLinkData) {
                throw "There are no products listed on the Page. Please contact customer service.";
            }
        } else if (pageType === 4 && buttonOrLink && buttonOrLink.linkDetails.find((link) => link.products && link.products.length > 0)) {
            const linkWithNoProducts = buttonOrLink.linkDetails.find((link) => !link.products || !link.products.length) || {}
            if (fkCart && Object.keys(fkCart).length) {
                const productKeys = Object.keys(fkCart).map(fkCartKey => fkCartKey.split(".")[0]);
                buttonOrLinkData = buttonOrLink.linkDetails.find((link) => link.products.find((product) => productKeys.includes(product.toString()))) || linkWithNoProducts;
            } else if (Object.keys(linkWithNoProducts).length) {
                buttonOrLinkData = linkWithNoProducts;
            } else {
                buttonOrLinkData = buttonOrLink.linkDetails[0];
            }
        } else {
            buttonOrLinkData = (buttonOrLink && buttonOrLink.linkDetails[0]) || {};
        }
        return buttonOrLinkData;
    } catch (e) {
        throw e;
    }
}

function checkRequiredInputs() {
    const cardFields = ["cardNumber", "cardSecurityCode", "cardMonth", "cardYear"];
    /*
    * TBD: "cardMonth", "cardYear" are of type 'select-one' -> Unselected value can include "select", "choose", "pick".  Need to find the proper filter/filter list and do validation.
    */
	let required = $("input, select").filter(function(index) {
        return $(this).is(":visible") && ($(this).attr("required") || $(this).attr("requiredtype"));
      });
	const cardNumberDetails = $('input[name="cardNumber"]');
	const cardSecurityCodeDetails = $('input[name="cardSecurityCode"]');
	let cardNumberValue = "";
	let cvvFlag = false;
    if (sessionStorage.getItem("paySource") === "PAYPAL") {
        required = required.filter((index, field) => !cardFields.includes(field.name));
	}
	cardNumberDetails.each(function (index) {
		if (this.name == "cardNumber") {
			cardNumberValue = $(this).val();
		}
	});
    const inputValue = new Array();
    const inputWithNoVal = new Array();
    const checkboxValue = new Array();
    required.each(function (index) {
        let requiredElement = false;
        const recurring = "recurring";
        const recurringUpperCase = "RECURRING";
        const trial = "trial";
        if (this.type == "checkbox" || this.type == "radio") {
            if (this.checked == false) {
                if (this.type === "checkbox") {
                    const requiredType = this.getAttribute("requiredtype");
                    if (requiredType && (requiredType === recurring || requiredType === trial)) {
                        const fkCart = sessionStorage.getItem("fkCart") !== null ? JSON.parse(sessionStorage.getItem("fkCart")) : null;
                        const products = pageData.selectedCampaign && pageData.selectedCampaign.products && pageData.selectedCampaign.products;
                        if (fkCart && Object.keys(fkCart).length > 0) {
                            for (const sessionItemCpId in fkCart) {
                                products.forEach((product) => {
                                    if (product.campaignProductId == sessionItemCpId.split(".")[0]) {
                                        if ((requiredType === recurring && product.billingCycleType === recurringUpperCase) || (requiredType === trial && product.trialEnabled)) {
                                            requiredElement = true;
                                        }
                                    }
                                });
                            }
                        }
                    } else {
                        requiredElement = true;
                    }
                } else {
                    requiredElement = true;
                }
                if (requiredElement) {
                    $(this).css("outline", "1px solid red");
                    inputWithNoVal.push(this);
                    checkboxValue.push(this.checked);
                }
            } else {
                $(this).css("outline", "1px solid green");
            }
        }
        else {
            inputValue.push($(this).val());
            if ($(this).val() == "") {
                $(this).css("outline", "1px solid red");
                inputWithNoVal.push(this);
            } else {
                $(this).css("outline", "1px solid green");
            }
		}
	});
	cardSecurityCodeDetails.each(function (index) {
		if (cardNumberValue !== "" && this.name == "cardSecurityCode" && $(this).val() != "" && $(this).val().length < 3) {
			alert("Card Security Code must be at least 3 characters");
			cvvFlag = true;
			setTimeout(() => {
				$(this).focus();
				$(this).css("outline", "1px solid red");
			}, 0);
		}
	});
    if ($(inputWithNoVal[0]).val() == "") {
        $(inputWithNoVal[0]).focus();
	}
    if (!inputValue.includes("") && !checkboxValue.includes(false) && cvvFlag === false) {
        return true;
    } else {
        return false;
	}
}

function getLoginPageButtonData(funnelData, pageType, buttonItem) {
    if (funnelData && funnelData.isVisualizer && pageType === 7)
        return buttonItem && buttonItem.status === "Active" && getButtonOrLinkData(buttonItem);
}

function callMethod(e) {
    e.preventDefault();
    if (e.detail !== 1) {
        return;
    }
    e.target.disabled = true;
    let clubId = "";
    let BreakException = {};
    try {
        pageData.selectedCampaign && pageData.selectedCampaign.products && pageData.selectedCampaign.products.forEach(function (product) {
            if (product.clubPluginId) {
                clubId = product.clubPluginId;
                throw BreakException;
            }
        });
    } catch (e) {
        enableInteractions();
        if (e !== BreakException) throw e;
    }
    let route = null;
    const pageType = pageData.funnelData.isVisualizer ? pageData.pageTypeId : (pageData.currentPage && pageData.currentPage.pageView[0].pageType);
    const buttonId = e.target.dataset.id;
    // if (pageData.funnelData && pageData.funnelData.isFunnelTemplate) {
    //     buttonData = pageData.funnelData.isVisualizer ? (pageType === 7) ? pageData[buttonId].Active.NEXT_PAGE  : pageData[buttonId].NEXT_PAGE : JSON.parse(pageData[buttonId].NEXT_PAGE);
    // } else {
    //     const buttonItem = getNavigationItemFromPageData(buttonId);
    //     buttonData = pageData.funnelData.isVisualizer ? buttonItem.NEXT_PAGE : JSON.parse(pageData[buttonId].NEXT_PAGE);
    // }
    const buttonItem = getNavigationItemFromPageData(buttonId);
    let buttonData;
    try {
        buttonData = getButtonOrLinkData(buttonItem, pageType);
    } catch (e) {
        if (pageType === 8 && buttonData === undefined) {
            updateMember(route = null, clubId, () => {
                alert(e);
            });
        } else {
            alert(e);
        }
        enableInteractions();
        return;
    }

    const isBuildOrTemplate = checkBuildOrTemplate();
    if (isBuildOrTemplate) {
        const loginButtonData = getLoginPageButtonData(pageData.funnelData, pageType, buttonItem);
        if (loginButtonData)
            buttonData = loginButtonData;
    }
    if (checkRequiredInputs()) {
        disableInteractions(buttonId, true, false);
        if (isBuildOrTemplate) {
            route = redirectPath(buttonData, true);
            switch (pageType) {
                // Lead page
                case 2:
                case "leadPage":
                case 15:
                    importLead(buttonId, route);
                    break;
                // Checkout Page
                case 4:
                case "checkoutPage":
                    importOrder(buttonId, route);
                    break;
                // Upsell Page
                case 3:
                case "upsellPage":
                    importUpsale(buttonId, route);
                    break;
                // Thank You Page
                case 5:
                case "thankYouPage":
                    confirmation(buttonId, route);
                    break;
                //MemberShip Pages
                case 7:
                case "login":
                case 8:
                case "Profile":
                case 9:
                case "memberAreaPage":
                case 10:
                case "cancelMembership":
                case 11:
                case "restartMembership":
                case 12:
                case "updateCard":
                case 13:
                case "changeProduct":
                    membershipRouteForPreview(route);
                    break;
                default:
                    setCurrentWindowLocation(route);
            }
        } else {
            let currentUrl = getCurrentWindowLocation().href;
            let envUrl = currentUrl.substr(0, currentUrl.lastIndexOf("/")) + "/funnelJson.json";
            fetch(envUrl).then(res => res.json()).then(funnelJsonRes => {
                let pageReferenceId = pageData.funnelData.isVisualizer ? pageData.currentPage.referenceId : buttonData.targetPageReferenceId; //element.targetPageReferenceId or referenceId
                let targetData = pageData.funnelData.pages.find(item => item.pageView[0].referenceId === buttonData.targetPageViewReferenceId); //element.targetPageViewReferenceId or targetPage
                let targetUrl;
                const isMemberPageType = isMembershipPage(pageType);
                if (isMemberPageType) {
                    productData = buttonItem;
                    targetUrl = redirectPath(buttonData, true);
                } else {
                    let splitReferenceId = (targetData && targetData.splitReferenceId) || "";
                    let funnelReferenceId = pageData.funnelData ? pageData.funnelData.referenceId : null;
                    if (!pageData.funnelData.isVisualizer) {
                        targetUrl = "https://api.funnelkonnekt.com/splitViewApi/V1/SplitView/funnel/" + funnelReferenceId + "/page/" + pageReferenceId + "/redirect/true";
                    } else if (targetData && targetData.splitEnabled) {
                        targetUrl = "https://api.funnelkonnekt.com/api/V1/SplitTest/funnel/" + funnelReferenceId + "/split/" + splitReferenceId + "/redirect/true/funnelEnvironment/" + funnelJsonRes.FunnelEnvironment;
                    } else {
                        targetUrl = redirectPath(buttonData);
                    }
                }
                // let route = pageData[buttonId].NEXT_PAGE.value.pageView[0].url;
                route = targetUrl;
                const targetPageType = targetData.pageView[0].pageType;
                if(targetPageType === 23) {
                    openPopupIFrame(route);
                    enableInteractions();
                } else {
                    switch (pageType) {
                        // Presell page
                        case 1:
                            navigationFromPresell(targetPageType, route);
                            break;
                        // Lead page
                        case 2:
                        case "leadPage":
                        case 15:
                            importLead(buttonId, route);
                            break;
                        // Checkout Page
                        case 4:
                        case "checkoutPage":
                            importOrder(buttonId, route);
                            break;
                        // Upsell Page
                        case 3:
                        case "upsellPage":
                            importUpsale(buttonId, route);
                            break;
                        // Thank You Page
                        case 5:
                        case "thankYouPage":
                            confirmation(buttonId, route);
                            break;
                        case 7:
                        case "login":
                            clubLogin(buttonId, clubId, productData);
                            break;
                        case 8:
                        case "Profile":
                            updateMember(route, clubId);
                            break;
                        case 9:
                        case "memberAreaPage":
                            memberRoute(productData);
                            break;
                        case 10:
                        case "cancelMembership":
                            cancelMembership(route, clubId, productData);
                            break;
                        case 11:
                        case "restartMembership":
                            restartMembership(route, clubId, productData);
                            break;
                        case 12:
                        case "updateCard":
                            updateCard(productData);
                            break;
                        case 13:
                        case "changeProduct":
                            changeProduct(buttonId, route, clubId);
                            break;
                        case 31:
                        case "pauseMembership":
                            pauseMembership(route);
                            break;
                        default:
                            setCurrentWindowLocation(route);
                    }
                }
            });
        }
    } else {
        enableInteractions();
    }
}
function openPopupIFrame(route) {
    // Open target as Popup
    $("#dialogIframeDiv").html("<iframe class='dialogPopupIframe' src=" + route + "></iframe>");
    $("#dialogIframeDiv").dialog && $("#dialogIframeDiv").dialog("open");
    $(".dialogPopupIframe").css({"height": "100%", "width": "100%", "max-height": "90%", "border-width": "0" });
}
function navigationFromPresell(targetPageType, route) {
    // If Navigating to Lead page or Checkout page
    if (targetPageType === 2 || targetPageType === 4 || targetPageType === 15) {
        registerClick(1, function (regClickData) {
            setCurrentWindowLocation(route);
        });
    } else {
        setCurrentWindowLocation(route);
    }
}

function route(e) {
    e.preventDefault();
    if (e.detail !== 1) {
        return;
    }
    const pageType = pageData.funnelData.isVisualizer ? pageData.pageTypeId : (pageData.currentPage && pageData.currentPage.pageView[0].pageType);
    const buttonDataID = e.currentTarget.dataset.id;
    if (buttonDataID && buttonDataID !== "") {
        const button = $("button[data-id='" + buttonDataID + "']")[0];
        if (button.parentNode.nodeName === "SECTION") {
            let customName = button.parentNode.attributes.customName ? button.parentNode.attributes.customName.value : "";
            if (customName !== "") {
                customName = customName.replace(" ", "_");
                const custom = "custom_" + customName;
                sessionStorage.setItem(custom, button.innerHTML);
            }
        }
    }
    const buttonId = e.target.dataset.id;
    const buttonItem = getNavigationItemFromPageData(buttonId);
    let buttonData;
    try {
        buttonData = getButtonOrLinkData(buttonItem, pageType);
    } catch (e) {
        alert(e);
        return;
    }

    const targetData = pageData.funnelData.pages.find(item => item.pageView[0].referenceId === buttonData.targetPageViewReferenceId);
    const targetPageType = targetData.pageView[0].pageType;
    const isBuildOrTemplate = checkBuildOrTemplate();
    if (isBuildOrTemplate) {
        const loginButtonData = getLoginPageButtonData(pageData.funnelData, pageType, buttonItem);
        if (loginButtonData) {
            buttonData = loginButtonData;
        }
        if (checkRequiredInputs()) {
            if ((pageType === 3 && targetPageType === 3) || targetPageType === 4) {
                getVariants();
            }
            const route = redirectPath(buttonData, true);
            setCurrentWindowLocation(route);
        }
    } else {
        const funnelReferenceId = pageData.funnelData ? pageData.funnelData.referenceId : null;
        const pageReferenceId = pageData.funnelData.isVisualizer ? pageData.currentPage.referenceId : buttonData.targetPageReferenceId;
        const splitReferenceId = (targetData && targetData.splitReferenceId) || "";
        const currentUrl = getCurrentWindowLocation().href;
		const envUrl = currentUrl.substr(0, currentUrl.lastIndexOf("/")) + "/funnelJson.json";
		getVariants();
		if (pageType === 3 && targetPageType === 3) {
			var upsell = getUpsellFromNavigationItem(buttonId);
			const upsellButtonElement = document.querySelector("[data-id=" + buttonId + "]");
			const upsellButtonVariantValue = upsellButtonElement.getAttribute("variantvalue");
			let orderItems = sessionStorage.getItem("upsalefkCart") !== null ? JSON.parse(sessionStorage.getItem("upsalefkCart")) : {};
			if (upsell) {
				if (upsellButtonVariantValue) {
					const itemOfferKey = upsell + "." + upsellButtonVariantValue;
					orderItems[itemOfferKey] = getQuantity();

				} else {
					orderItems[upsell] = getQuantity();
				}
				sessionStorage.setItem("upsalefkCart", JSON.stringify(orderItems));
			}
		}

		if (targetPageType === 4) {
			var offer = getOfferFromNavigationItem(buttonId);
			const offerButtonElement = document.querySelector("[data-id=" + buttonId + "]");
			const offerButtonVariantValue = offerButtonElement.getAttribute("variantvalue");
			let orderItems = getOrderItems();
			if(offer){
				if (offerButtonVariantValue) {
					const itemOfferKey = offer + "." + offerButtonVariantValue;
					orderItems[itemOfferKey] = getQuantity();

				} else {
					orderItems[offer] = getQuantity();
				}
				sessionStorage.setItem("fkCart", JSON.stringify(orderItems));
			}
		}
        fetch(envUrl).then(res => res.json()).then(data => {
            const splitUrl = !pageData.funnelData.isVisualizer ? "https://api.funnelkonnekt.com/splitViewApi/V1/SplitView/funnel/" + funnelReferenceId + "/page/" + pageReferenceId + "/redirect/true" : (targetData.splitEnabled ? "https://api.funnelkonnekt.com/api/V1/SplitTest/funnel/" + funnelReferenceId + "/split/" + splitReferenceId + "/redirect/true/funnelEnvironment/" + data.FunnelEnvironment : redirectPath(buttonData));
            if(targetPageType === 23) {
                openPopupIFrame(splitUrl);
            } else if ((targetPageType !== 3 && targetPageType !== 4 && targetPageType !== 5) || checkRequiredInputs()) {
                const pageReferenceId = pageData.funnelData.isVisualizer ? pageData.currentPage.referenceId : buttonData.targetPageReferenceId;
                const splitReferenceId = targetData.splitReferenceId;
                const funnelReferenceId = pageData.funnelData ? pageData.funnelData.referenceId : null;
                const isMembershipPageType = isMembershipPage(pageType);
                if (isMembershipPageType) {
                    memberRoute(buttonItem);
                } else if (pageType === 1) {
                    navigationFromPresell(targetPageType, splitUrl);
                } else {
                    setCurrentWindowLocation(splitUrl);
                }
            }
        });
    }
}

function linkMethod(e, submit) {
    e.preventDefault();
    if (e.detail !== 1) {
        return;
    }
    if (submit) {
        e.target.style.pointerEvents = "none";
    }
    let pageType = pageData.funnelData.isVisualizer ? pageData.pageTypeId : (pageData.currentPage && pageData.currentPage.pageView[0].pageType);
    const buttonId = e.target.dataset.id;
    // let buttonData = pageData.funnelData.isVisualizer ? pageData[buttonId].NEXT_PAGE : JSON.parse(pageData[buttonId].NEXT_PAGE);
    // const linkId = e.target.dataset.id ? e.target.dataset.id : e.target.parentNode.getAttribute("data-id");
    // let linkData = pageData.funnelData.isVisualizer ? pageData[linkId].NEXT_PAGE : JSON.parse(pageData[linkId].NEXT_PAGE);
    const buttonItem = getNavigationItemFromPageData(buttonId);
    let buttonData, linkId, linkData, linkObj;
    try {
        buttonData = getButtonOrLinkData(buttonItem, pageType);
        linkId = buttonId ? buttonId : e.target.parentNode.getAttribute("data-id");
        linkObj = getNavigationItemFromPageData(linkId);
        linkData = getButtonOrLinkData(linkObj, pageType);
    } catch (e) {
        alert(e);
        return;
    }
    submit && disableInteractions(linkId, false, true);
    if (pageData.funnelData && pageData.funnelData.isFunnelTemplate) {
        if (checkRequiredInputs()) {
            if (submit) {
                switch (pageType) {
                    // Lead page
                    case 2:
                    case "leadPage":
                    case 15:
                        importLead(linkId, route);
                        break;
                    // Checkout Page
                    case 4:
                    case "checkoutPage":
                        importOrder(linkId, route);
                        break;
                    // Upsell Page
                    case 3:
                    case "upsellPage":
                        importUpsale(linkId, route);
                        break;
                    // Thank You Page
                    case 5:
                    case "thankYouPage":
                        confirmation(linkId, route);
                        break;
                    default:
                        setCurrentWindowLocation(route);
                }
            }
            if (linkObj.href) {
                linkObj.target === "_blank" ? window.open(linkObj.href, "") : setCurrentWindowLocation(linkObj.href);
            } else {
                let route = redirectPath(buttonData, true);
                linkObj.target === "_blank" ? window.open(route, "") : setCurrentWindowLocation(route);
            }
        } else {
            enableInteractions();
        }
    } else {
        let currentUrl = getCurrentWindowLocation().href;
        let envUrl = currentUrl.substr(0, currentUrl.lastIndexOf("/")) + "/funnelJson.json";
        fetch(envUrl).then(res => res.json()).then(data => {
            let pageType = pageData.funnelData.isVisualizer ? pageData.pageTypeId : (pageData.currentPage && pageData.currentPage.pageView[0].pageType);
            let pageReferenceId = pageData.funnelData.isVisualizer ? pageData.currentPage.referenceId : linkData.targetPageReferenceId;
            let targetData = pageData.funnelData.pages.find(item => item.pageView[0].referenceId === linkData.targetPageViewReferenceId);
            let splitReferenceId = targetData.splitReferenceId;
            const targetPageType = targetData.pageView[0].pageType;
            let funnelReferenceId = pageData.funnelData ? pageData.funnelData.referenceId : null;
            let route = !pageData.funnelData.isVisualizer ? "https://api.funnelkonnekt.com/splitViewApi/V1/SplitView/funnel/" + funnelReferenceId + "/page/" + pageReferenceId + "/redirect/true" : (targetData.splitEnabled ? "https://api.funnelkonnekt.com/api/V1/SplitTest/funnel/" + funnelReferenceId + "/split/" + splitReferenceId + "/redirect/true/funnelEnvironment/" + data.FunnelEnvironment : redirectPath(linkData));
            if (submit) {
                if (checkRequiredInputs()) {
                    //get the route before submitting
                    if(targetPageType === 23) {
                        openPopupIFrame(route);
                        enableInteractions();
                    } else {
                        switch (pageType) {
                            // Presell page
                            case 1:
                                navigationFromPresell(targetPageType, route);
                                break;
                            // Lead page
                            case 2:
                            case "leadPage":
                            case 15:
                                importLead(linkId, route);
                                break;
                            // Checkout Page
                            case 4:
                            case "checkoutPage":
                                importOrder(linkId, route);
                                break;
                            // Upsell Page
                            case 3:
                            case "upsellPage":
                                importUpsale(linkId, route);
                                break;
                            // Thank You Page
                            case 5:
                            case "thankYouPage":
                                confirmation(linkId, route);
                                break;
                            default:
                                setCurrentWindowLocation(route);
                        }
                    }
                } else {
                    enableInteractions();
                }
            } else {
                if(targetPageType === 23) {
                    openPopupIFrame(route);
                } else if ((targetPageType !== 3 && targetPageType !== 4 && targetPageType !== 5) || checkRequiredInputs()) {
                    if (pageType === 3 && targetPageType === 3) {
						var upsell = getUpsellFromNavigationItem(buttonId);
						const upsellButtonElement = document.querySelector("[data-id=" + buttonId + "]");
			            const upsellButtonVariantValue = upsellButtonElement.getAttribute("variantvalue");

                        getVariants();
						let orderItems = sessionStorage.getItem("upsalefkCart") !== null ? JSON.parse(sessionStorage.getItem("upsalefkCart")) : {};
						if (upsell) {
							if (upsellButtonVariantValue) {
								const itemOfferKey = upsell + "." + upsellButtonVariantValue;
								orderItems[itemOfferKey] = getQuantity();

							} else {
								orderItems[upsell] = getQuantity();
							}
							sessionStorage.setItem("upsalefkCart", JSON.stringify(orderItems));
						}
                    }
                    if (targetPageType === 4) {
                        var offer = getOfferFromNavigationItem(buttonId);
						const offerButtonElement = document.querySelector("[data-id=" + buttonId + "]");
						const offerButtonVariantValue = offerButtonElement.getAttribute("variantvalue");

                        getVariants();
						let orderItems = getOrderItems();
						if(offer){
							if (offerButtonVariantValue) {
								const itemOfferKey = offer + "." + offerButtonVariantValue;
								orderItems[itemOfferKey] = getQuantity();

							} else {
								orderItems[offer] = getQuantity();
							}
							sessionStorage.setItem("fkCart", JSON.stringify(orderItems));
						}
                    }
                    if (linkObj.href) {
                        linkObj.target === "_blank" ? window.open(linkObj.href, "") : setCurrentWindowLocation(linkObj.href);
                    } else {
                        let funnelReferenceId = pageData.funnelData ? pageData.funnelData.referenceId : null;
                        linkObj.target === "_blank" ? window.open(route, "") : setCurrentWindowLocation(route);
                    }
                }
            }
        });
    }

}
function fetchLeadDetails(obj) {
    if (obj.billShipSame === 1) {
        if (document.getElementsByName("fullName")[0]) {
            let fullName = document.getElementsByName("fullName")[0].value.trim();
            let pos = fullName.indexOf(" ");
            obj.shipFirstName = (pos > -1) ? fullName.substring(0, pos) : fullName;
            obj.shipLastName = (pos > -1) ? fullName.substring(pos + 1) : null;
        } else {
            obj.shipFirstName = document.getElementsByName("firstName")[0] ? document.getElementsByName("firstName")[0].value : null;
            obj.shipLastName = document.getElementsByName("lastName")[0] ? document.getElementsByName("lastName")[0].value : null;
        }
        obj.shipAddress1 = document.getElementsByName("address1")[0] ? document.getElementsByName("address1")[0].value : null;
        obj.shipAddress2 = document.getElementsByName("address2")[0] ? document.getElementsByName("address2")[0].value : null;
        obj.shipCity = document.getElementsByName("city")[0] ? document.getElementsByName("city")[0].value : null;
        obj.shipState = document.getElementsByName("state")[0] ? document.getElementsByName("state")[0].value : null;
        obj.shipPostalCode = document.getElementsByName("postalCode")[0] ? document.getElementsByName("postalCode")[0].value : null;
        obj.shipCountry = document.getElementsByName("country")[0] ? document.getElementsByName("country")[0].value : null;
    }
    else {
        if (document.getElementsByName("shipFullName")[0]) {
            let fullName = document.getElementsByName("shipFullName")[0].value.trim();
            let pos = fullName.indexOf(" ");
            obj.shipFirstName = (pos > -1) ? fullName.substring(0, pos) : fullName;
            obj.shipLastName = (pos > -1) ? fullName.substring(pos + 1) : null;
        } else {
            obj.shipFirstName = document.getElementsByName("shipFirstName")[0] ? document.getElementsByName("shipFirstName")[0].value : null;
            obj.shipLastName = document.getElementsByName("shipLastName")[0] ? document.getElementsByName("shipLastName")[0].value : null;
        }
        obj.shipAddress1 = document.getElementsByName("shipAddress1")[0] ? document.getElementsByName("shipAddress1")[0].value : null;
        obj.shipAddress2 = document.getElementsByName("shipAddress2")[0] ? document.getElementsByName("shipAddress2")[0].value : null;
        obj.shipCity = document.getElementsByName("shipCity")[0] ? document.getElementsByName("shipCity")[0].value : null;
        obj.shipState = document.getElementsByName("shipState")[0] ? document.getElementsByName("shipState")[0].value : null;
        obj.shipPostalCode = document.getElementsByName("shipPostalCode")[0] ? document.getElementsByName("shipPostalCode")[0].value : null;
        obj.shipCountry = document.getElementsByName("shipCountry")[0] ? document.getElementsByName("shipCountry")[0].value : "US";
    }
}
window.onscroll = function () {
    var stickyBar = document.getElementById('stickyBarCustom');
    var popupBlock = document.getElementById('customizable_popup');
    var toShowOnScroll = stickyBar && stickyBar.getAttribute('data-showonscroll') === 'yes' ? true : false;

    if (toShowOnScroll) {
        if (window.scrollY > 100) {
            document.getElementById('stickyBarCustom').setAttribute('style', 'display:block');
        }
        else {
            document.getElementById('stickyBarCustom').setAttribute('style', 'display:none');
        }
    }
    if (popupBlock && popupBlock.querySelector('[data-showonscroll]') && (popupBlock && popupBlock.querySelector('[data-showonscroll]').getAttribute('data-showonscroll') === "true")) {
        if (isVisitedOnScroll) {
            isVisitedOnScroll = false;
            var minutesDelay = popupBlock.querySelector('[data-minutesdelay]') ? Number(popupBlock.querySelector('[data-minutesdelay]').getAttribute('data-minutesdelay')) : 0;
            var secondsDelay = popupBlock.querySelector('[data-secondsdelay]') ? popupBlock.querySelector('[data-secondsdelay]').getAttribute('data-secondsdelay') : 0;
            var delay = minutesDelay > 0 ? ((minutesDelay * 60) + secondsDelay) + '000' : secondsDelay + '000';
            document.getElementById('customizable_popup').setAttribute('style', 'display:none');
            document.getElementsByTagName("html")[0].style = "overflow-y: unset";
            setTimeout((delay) => {
                document.getElementById('customizable_popup').setAttribute('style', 'display:block');
                document.getElementsByTagName("html")[0].style = "overflow-y: hidden";
            }, delay);
        }
    }
}
var calcTheProductInvoiceAmount = function (ele, key) {
    $('input[name^="product"]').each(function () {
        if ($(this).is(':checked')) {
            let id = $(this).val();
            var product = pageData.selectedCampaign.products.filter(data => data.campaignProductId == id)
            if (product.length === 1 && product.length > 0) {
                price += product[0][key] != null ? parseFloat(product[0][key]) : 0;
            }
            else {
                $.each(product, function (i, product) {
                    price += product[key] != null ? parseFloat(product[0][key]) : 0;
                });
            }

        }
    });
    ele.innerText = parseFloat(price).toFixed(2);
}
function downloadURL(event, buttonObj) {
    event.preventDefault();
    if (event.detail !== 1) {
        return;
    }
    const URL = $(buttonObj).attr('data-downloadurl');
    if (URL) {
        let linkElement = document.createElement('a');
        linkElement.href = URL;
        linkElement.download = true;
        linkElement.target = "blank";
        document.body.appendChild(linkElement);
        linkElement.click();
        document.body.removeChild(linkElement);
    }
    else {
        alert('No URL found');
    }
}
function registerClick(clickType, callback) {
    const funnelReferenceId = pageData.funnelData ? pageData.funnelData.referenceId : null;
    const pageReferenceId = pageData.funnelData.isVisualizer ? pageData.currentPage.referenceId : buttonData.targetPageReferenceId;
    if (!document.URL.includes("funnels-build")) {
        httpMethod("https://api.funnelkonnekt.com/api/V1/SplitTest/clicks/" + funnelReferenceId + "/" + pageReferenceId + "/" + clickType).then(function (data) {
            callback && typeof callback === "function" && callback(data);
        }).catch(function (err) {
            callback && typeof callback === "function" && callback(err);
        })
    } else {
        callback && typeof callback === "function" && callback();
    }
    return;
}
function previewURL(event) {
    const URL = $(event).attr('data-previewurl');
    window.open(URL, "_blank");
}
function loadProductsToCart(orderItems) {
    // Converting Nodelists to normal arrays to avoid forEach errors in Microsoft Edge - FUN2-1637
    const productInputs = [...document.getElementsByName("product")];
    if (productInputs) {
        productInputs.forEach(function (product) {
            let productValue = product.getAttribute("value");
            let variantValue = product.getAttribute("variantvalue");
            if (productValue && product.tagName.toLowerCase() === "input") {
                if (product.checked) {
                    if (variantValue) {
                        productValue = productValue + "." + variantValue;
                    }
                    if (!orderItems[productValue]) {
                        orderItems[productValue] = 1;
                    }
                } else {
                    if (variantValue) {
                        productValue = productValue + "." + variantValue;
                        delete orderItems[productValue];
                    } else {
                        delete orderItems[productValue];
                    }
                }
            }
        })
    }
    return orderItems;
}
function getOrderItems() {
    let orderItems = {};
    const fkCart = sessionStorage.getItem("fkCart") !== null ? JSON.parse(sessionStorage.getItem("fkCart")) : null;
    if (fkCart && Object.keys(fkCart).length > 0) {
        for (const sessionItemCpId in fkCart) {
            orderItems[sessionItemCpId] = fkCart[sessionItemCpId];
        }
    }
    orderItems = loadProductsToCart(orderItems);
    sessionStorage.setItem("fkCart", JSON.stringify(orderItems));
    return orderItems;
}
function getUpsaleItems() {
    let orderItems = sessionStorage.getItem("upsalefkCart") !== null ? JSON.parse(sessionStorage.getItem("upsalefkCart")) : {};
    orderItems = loadProductsToCart(orderItems);
    sessionStorage.setItem("upsalefkCart", JSON.stringify(orderItems));
    return orderItems;
}
function mergeOfferUpsale(upsaleItems) {
    const orderItems = {};
    const fkCart = sessionStorage.getItem("fkCart") !== null ? JSON.parse(sessionStorage.getItem("fkCart")) : null;
    if (fkCart && Object.keys(fkCart).length) {
        for (const sessionItemCpId in fkCart) {
            orderItems[sessionItemCpId] = fkCart[sessionItemCpId];
        }
    }
    if (upsaleItems && Object.keys(upsaleItems).length) {
        for (const upsaleItem in upsaleItems) {
            orderItems[upsaleItem] = upsaleItems[upsaleItem];
        }
    }
    sessionStorage.setItem("fkCart", JSON.stringify(orderItems));
    sessionStorage.removeItem("upsalefkCart");
}
function getOrderItemDetails() {
    const orderItems = getOrderItems();
    const products = pageData && pageData.selectedCampaign ? pageData.selectedCampaign.products : null;
    const detailedOrderItems = {};
    if (products && Object.keys(orderItems).length > 0) {
        for (const campaignProductId in orderItems) {
            let sessionItemCpId = campaignProductId;
            let sessionItemVarId = 0;
            if (sessionItemCpId.indexOf(".") > 0) {
                const productData = sessionItemCpId.split(".");
                sessionItemCpId = productData[0];
                sessionItemVarId = productData[1];
            }
            const productDetails = products.filter(data => data.campaignProductId === parseInt(sessionItemCpId));
            if (Object.keys(productDetails).length > 0) {
                const obj = Object.assign({}, productDetails[0]);   //clone
                detailedOrderItems[campaignProductId] = obj;
                detailedOrderItems[campaignProductId]["currentOrderQuantity"] = orderItems[campaignProductId];
                if (obj.variants && sessionItemVarId > 0) {
                    const variantDetails = obj.variants.filter(data => data.variantDetailId === parseInt(sessionItemVarId));
                    if (Object.keys(variantDetails).length > 0)
                        detailedOrderItems[campaignProductId]["variant"] = variantDetails[0];
                }
            }
            else {
                console.log("Product with campaign product ID " + sessionItemCpId + " not found in funnel campaign!");
                delete orderItems[campaignProductId];
            }
        }
        sessionStorage.setItem("fkCart", JSON.stringify(orderItems));
    }
    return detailedOrderItems;
}
function getDiscounts(couponCode, items, coupons) {
    var ret = {
        couponCode: [],
        orderDiscounts: { priceFlat: 0, pricePerc: 0, shipFlat: 0, shipPerc: 0 },
        productDiscounts: {},
        coupons: [],
        coupMessage: ''
    };

    var cCodes = couponCode.trim().toUpperCase().split(',');

    var couponCount = 0;
    var obj, flatDiscount, percDiscount;
    for (var i in cCodes) {
        var code = cCodes[i];
        coupon = coupons.find(item => item.couponCode === code);
        if (!coupon)
            continue;

        flatDiscount = coupon.discountPrice === null ? 0 : parseFloat(coupon.discountPrice);
        percDiscount = coupon.discountPerc === null ? 0 : parseFloat(coupon.discountPerc);
        if (coupon.couponMax && couponCount >= coupon.couponMax)
            break;

        if (!coupon.campaignProductId) {
            obj = ret.orderDiscounts;
        }
        else {
            if (!items[coupon.campaignProductId]) {
                continue;
            }
            if (!ret.productDiscounts[coupon.campaignProductId])
                ret.productDiscounts[coupon.campaignProductId] = { priceFlat: 0, pricePerc: 0, shipFlat: 0, shipPerc: 0 };
            obj = ret.productDiscounts[coupon.campaignProductId];
        }

        ret.coupMessage += "<span style='color:green;font-weight:bold;'>" + code + "</span> ";
        isPerc = percDiscount > flatDiscount;

        var discount = flatDiscount + percDiscount;

        if (isPerc)
            discount = (parseFloat(discount) * 100).toString() + '%';
        var products = pageData.selectedCampaign.products;
        if (coupon.campaignProductId)
            var coupProd = pageData.selectedCampaign.products.find(item => item.campaignProductId === coupon.campaignProductId).productName;

        ret.coupMessage += discount + " off " + (coupon.applyTo == 'SHIPPING' ? 'shipping ' : '') + "on " + (coupon.campaignProductId ? coupProd : "Order") + "<br>";

        if (coupon.applyTo == 'BASE_PRICE') {
            obj.priceFlat += flatDiscount;
            obj.pricePerc += percDiscount;
        }
        else {
            obj.shipFlat += flatDiscount;
            obj.shipPerc += percDiscount;
        }

        //ensure percents do not add up more than 100
        if (obj.pricePerc > 100)
            obj.pricePerc = 100;
        if (obj.shipPerc > 100)
            obj.shipPerc = 100;


        ret.coupons.push(coupon);
        ret.couponCode.push(code);
        couponCount++;
    }
    if (couponCount == 0)
        return false;
    ret.couponCode = ret.couponCode.join();
    return ret;
}
function applyCoupon(e) {
    e.preventDefault();
    appliedCouponCode = document.getElementsByName("couponCode")[0] ? document.getElementsByName("couponCode")[0].value : null;
    displayPrices();
}
//returns shipping profile settings and rules based on selected shipProfileId or campaign's default shipping profile
//used in calculateTotals function as part of price display calculations
function getShipProfile() {
    //selectedCampaign shipProfiles property will be empty array when no shipping profiles configured in campaign
    if (pageData.selectedCampaign.shipProfiles.length === 0) return null;
    //use shipProfileId input value if available
    let shipProfileId = document.getElementsByName("shipProfileId")[0] ? document.getElementsByName("shipProfileId")[0].value : null;
    //use campaign's default shipping profile if configured when no shipping profile selected
    if ((shipProfileId === "" || shipProfileId === null) && pageData.selectedCampaign.defaultShipProfileId !== null) {
        shipProfileId = pageData.selectedCampaign.defaultShipProfileId;
    }
    if (shipProfileId) {
        const profile = pageData.selectedCampaign.shipProfiles.find(data => data.shipProfileId === parseInt(shipProfileId));
        return profile ? profile : null;
    } else {
        return null;
    }
}
//returns shipping address object with country, state, and continent properties
//used by applyShipProfileProductRules and getShipProfileOrderPrice functions to determine application of shipping profile regional price rules
function getShipProfileAddress() {
    const shipAddress = {};
    const orderData = JSON.parse(sessionStorage.getItem("orderData"));
    //use shipCountry input if available OR country input if available and billing and shipping addresses are the same OR use value set on previous page OR empty string when no value already set
    if (document.getElementsByName("shipCountry")[0]) {
        shipAddress.country = document.getElementsByName("shipCountry")[0].value;
    } else if (document.getElementsByName("billShipSame")[0] && document.getElementsByName("billShipSame")[0].checked && document.getElementsByName("country")[0]) {
        shipAddress.country = document.getElementsByName("country")[0].value;
    } else {
        shipAddress.country = orderData && orderData.shipCountry ? orderData.shipCountry : "";
    }
    //use shipState input if available OR state input if available and billing and shipping addresses are the same OR use value set on previous page OR empty string when no value already set
    if (document.getElementsByName("shipState")[0]) {
        shipAddress.state = document.getElementsByName("shipState")[0].value;
    } else if (document.getElementsByName("billShipSame")[0] && document.getElementsByName("billShipSame")[0].checked && document.getElementsByName("state")[0]) {
        shipAddress.state = document.getElementsByName("state")[0].value;
    } else {
        shipAddress.state = orderData && orderData.shipState ? orderData.shipState : "";
    }
    //set the continent from selectedCampaign countries based on shipping address country
    shipAddress.continent = shipAddress.country ? pageData.selectedCampaign.countries.find(data => data.countryCode === shipAddress.country).continent : "";
    return shipAddress;
}
//returns orderItems array with updated shipping prices after applying ship profile rules
//used by calculateTotals function when a shipping profile is set and does not apply one shipping price to the entire order
function applyShipProfileProductRules(shipProfile, items) {
    //skip this block when ship profile has no regional or product price rules
    if (shipProfile.rules !== null) {
        //get the shipping address state, country, and continent needed to determine application of regional price rules
        const shipAddress = getShipProfileAddress();
        //loop through the order items and update cycle1_shipPrice based on any applicable price rules
        for (const [campaignProductId, prod] of Object.entries(items)) {
            let appliedRule = null; //the ship profile with the most specific applicable price rule that will be applied to item's shipping price
            let maxPStrength = 0; //used to determine the most specific product price rule - Ex: campaign product specific rule has higher strength (5) than rule that applies to all products (1)
            let maxRStrength = 0; //used to determine the most specific regional rule - Ex: rule that applies only to state of Georgia has higher strength (3) than rule that applies to all of North America (1)
            //loop through shipProfile rules and determine the most specific applicable rule if any
            for (const rule of shipProfile.rules) {
                let pStrength = 0; //rule's product strength
                let rStrength = 0; //rule's region strength
                //if rule matches shipping address continent OR country and/or state, assign that regional strength value
                if (rule.region) {
                    //region value of rules that apply to entire continent all start with "REG_"
                    if (rule.region.substr(0,4) === "REG_") {
                        if (rule.region.substr(4,2) !== shipAddress.continent)
                            continue;
                        rStrength = 1;
                    } else {
                        if (rule.region === shipAddress.country) {
                            rStrength = 2;
                            if (rule.state) {
                                if (rule.state === shipAddress.state) {
                                    rStrength = 3;
                                } else {
                                    continue;
                                }
                            }
                        } else {
                            continue;
                        }
                    }
                }
                if (rStrength >= maxRStrength) {
                    maxRStrength = rStrength;
                } else {
                    continue;
                }
                if(rule.productTypeSelect === "SINGLE" && campaignProductId === rule.campaignProductId) {
                    pStrength = 5;
                } else if (rule.productTypeSelect === "CATEGORY" && prod.productCategoryId === rule.productCategoryId) {
                    pStrength = 4;
                } else if (rule.productTypeSelect === "OFFERS" && prod.productType === "OFFER") {
                    pStrength = 3;
                } else if (rule.productTypeSelect === "UPSELLS" && prod.productType === "UPSALE") {
                    pStrength = 2;
                } else if (rule.productTypeSelect === "PRODUCTS") {
                    pStrength = 1;
                }

                if (pStrength >= maxPStrength) {
                    appliedRule = rule;
                    maxPStrength = pStrength;
                }
            }
            //apply any applicable price rule - if upcharge, rule price is added to current item shipping price - otherwise, rule price overrides current item shipping price
            if (appliedRule && prod.cycle1_isShippable) {
                if (shipProfile.isUpcharge) {
                    prod.cycle1_shipPrice = parseFloat(prod.cycle1_shipPrice) + parseFloat(appliedRule.shipPrice);
                } else {
                    prod.cycle1_shipPrice = parseFloat(appliedRule.shipPrice);
                }
            }
        }
    }

    //shipProfiles that only bill the highest shipping price item
    if (shipProfile.highestShipPriceOnly) {
        let maxShipCampaignProductId = null; //campaign product ID of item with highest shipping price
        let maxShipPrice = 0; //highest item shipping price
        //loop through order items and determine which item has the highest shipping price
        for (const i in items) {
            let prod = items[i];
            let shipPrice = parseFloat(prod.cycle1_shipPrice);
            if (shipPrice > maxShipPrice) {
                maxShipCampaignProductId = i;
                maxShipPrice = shipPrice;
            }
        }
        //set the shipping price of all other items to zero
        for (const i in items) {
            if(i !== maxShipCampaignProductId) {
                items[i].cycle1_shipPrice = 0;
            }
        }
    }

    return items;
}
//returns shipping price for the entire order
//used by calculateTotals function when a shipping profile is set and applies one shipping price to the entire order
function getShipProfileOrderPrice(shipProfile) {
    if (shipProfile.rules === null) return;
    //get the shipping address state, country, and continent needed to determine application of regional price rules
    const shipAddress = getShipProfileAddress();
    let appliedRule = null; //the ship profile with the most specific applicable price rule that will be applied to item's shipping price
    let maxRStrength = 0; //used to determine the most specific regional rule - Ex: rule that applies only to state of Georgia has higher strength (3) than rule that applies to all of North America (1)
    //loop through shipProfile rules and determine the most specific applicable rule if any
    for (const rule of shipProfile.rules) {
        let rStrength = 0; //rule's region strength
        //if rule matches shipping address continent OR country and/or state, assign that regional strength value
        if (rule.region) {
            //region value of rules that apply to entire continent all start with "REG_"
            if (rule.region.substr(0,4) === "REG_") {
                if (rule.region.substr(4,2) !== shipAddress.continent) {
                    continue;
                }
                rStrength = 1;
            } else {
                if (rule.region === shipAddress.country) {
                    rStrength = 2;
                    if (rule.state) {
                        if (rule.state === shipAddress.state) {
                            rStrength = 3;
                        } else {
                            continue;
                        }
                    }
                } else {
                    continue;
                }
            }
        }
        if (rStrength >= maxRStrength) {
            maxRStrength = rStrength;
            appliedRule = rule;
        }
    }
    return appliedRule ? appliedRule.shipPrice : null;
}
function calculateTotals() {
    let subTotal = 0.00;
    let salesTax = 0.00;
    let shipTotal = 0.00;
    let grandTotal = 0.00;
    let discount = 0.00;
    let insurance = 0.00;

    const shipProfile = pageData.selectedCampaign ? getShipProfile() : null;

    let currentOrderItems = getOrderItemDetails();

    if (Object.keys(currentOrderItems).length > 0) {
        //when shipping profile is set and does not apply to entire order, get currentOrderItems with updated shipping prices after applying ship profile rules
        if (shipProfile && !shipProfile.applyEntireOrder)
            currentOrderItems = applyShipProfileProductRules(shipProfile,currentOrderItems);

        //total up subTotal (price) and shipTotal (shipping)
        for (const [campaignProductId, item] of Object.entries(currentOrderItems)) {
            const unitPrice = (item.variant && parseFloat(item.variant.price) > 0) ? item.variant.price : item.cycle1_price;
            subTotal += parseFloat(unitPrice) * item.currentOrderQuantity;
            shipTotal += parseFloat(item.cycle1_shipPrice) * item.currentOrderQuantity;
        }
    }

    if (shipProfile) {
        //when shipping profile applies one shipping price to the entire order
        if (shipProfile.applyEntireOrder) {
            const entireOrderShipPrice = getShipProfileOrderPrice(shipProfile);
            //if upcharge, shipping profile price is added to current order shipping total
            if (shipProfile.isUpcharge) {
                shipTotal += parseFloat(entireOrderShipPrice);
            } else { //otherwise, shipping profile price overrides current order shipping total
                shipTotal = parseFloat(entireOrderShipPrice);
            }
        }
        //when shipping profile freeShipThreshold is set, if order subTotal is greater than or equal to freeShipThreshold, order's shipping is free - Ex: Free shipping for orders $50 and over
        const freeShipThreshold = shipProfile.freeShipThreshold ? parseFloat(shipProfile.freeShipThreshold) : 0;
        if (freeShipThreshold > 0 && subTotal >= freeShipThreshold)
            shipTotal = 0;
    }

    if (appliedCouponCode.trim()) {
        var taxable = subTotal;
        if (appliedCouponCode) {
            var discounts = getDiscounts(appliedCouponCode, currentOrderItems, pageData.selectedCampaign.coupons);
        } else {
            var discounts = false;
        }
        if (discounts) {
            //apply any coupons

            //Now we have the discount values. Time to do the math and apply the discounts
            var orderPriceTotal = subTotal;
            var orderShipTotal = shipTotal;
            var discountPrice = 0;

            //always apply product-level coupons first
            for (var campaignProductId in discounts.productDiscounts) {
                var disc = discounts.productDiscounts[campaignProductId];
                var inCart = currentOrderItems[campaignProductId];
                if (inCart) {
                    const unitPrice = (inCart.variant && parseFloat(inCart.variant.price) > 0) ? inCart.variant.price : inCart.cycle1_price;
                    var basePrice = parseFloat(unitPrice) * inCart.currentOrderQuantity;
                    var baseShipping = parseFloat(inCart.cycle1_shipPrice) * inCart.currentOrderQuantity;

                    //first apply the flat discounts
                    var priceDisc = basePrice <= disc.priceFlat ? basePrice : disc.priceFlat;
                    var shipDisc = baseShipping <= disc.shipFlat ? baseShipping : disc.shipFlat;

                    //now apply the percent discounts
                    priceDisc += disc.pricePerc * (basePrice - priceDisc);
                    shipDisc += disc.shipPerc * (baseShipping - shipDisc);

                    //re-assign the item's discount values
                    discount += shipDisc + priceDisc;

                    //Reduce taxable by price discount
                    taxable -= priceDisc;

                    //add to order totals to use with coupons that apply discounts to the entire order
                    orderPriceTotal -= priceDisc;
                    orderShipTotal -= shipDisc;
                }
            }

            //now calculate the total order discounts
            disc = discounts.orderDiscounts;

            //first apply the flat discounts
            priceDisc = orderPriceTotal <= disc.priceFlat ? 0 : disc.priceFlat;
            shipDisc = orderShipTotal <= disc.shipFlat ? 0 : disc.shipFlat;

            //now apply the percent discounts
            priceDisc += disc.pricePerc * (orderPriceTotal - priceDisc);
            shipDisc += disc.shipPerc * (orderShipTotal - shipDisc);

            discount += priceDisc + shipDisc;

            //Reduce taxable by price discount
            taxable -= priceDisc;
        }
    }

    grandTotal = (subTotal + shipTotal + salesTax + insurance - discount).toFixed(2);
    subTotal = subTotal.toFixed(2);
    salesTax = salesTax.toFixed(2);
    shipTotal = shipTotal.toFixed(2);
    discount = discount.toFixed(2);
    insurance = insurance.toFixed(2);

    const totals = { subTotal: subTotal, salesTax: salesTax, shipTotal: shipTotal, grandTotal: grandTotal, discount: discount, insurance: insurance };
    sessionStorage.setItem("totals", JSON.stringify(totals));
    return totals;
}
function displayPrices() {
    const { subTotal, salesTax, shipTotal, grandTotal, discount, insurance } = calculateTotals();
    const symbol = pageData && pageData.selectedCampaign && pageData.selectedCampaign.currencySymbol ? pageData.selectedCampaign.currencySymbol : "$";
    if (cellFormat.length > 0) {
        cartDisplay();
    }

    const totalAmountElement = document.getElementById("totalAmountIs");
    if (totalAmountElement)
        totalAmountElement.innerHTML = symbol + parseFloat(subTotal).toFixed(2);
    const shippingChargesElement = document.getElementById("shippingCharges");
    if (shippingChargesElement)
        shippingChargesElement.innerHTML = symbol + parseFloat(shipTotal).toFixed(2);
    const priceElementClassMap = [["dynamic-price-total", subTotal], ["dynamic-shipping-total", shipTotal], ["salesTax", salesTax], ["grandTotal", grandTotal], ["discount", discount], ["insurance", insurance]];
    for (const [key, value] of priceElementClassMap) {
        const displayElements = document.getElementsByClassName(key);
        if (displayElements.length > 0) {
            for (const element of displayElements) {
                if (key === "discount" && parseFloat(value) > 0) {
                    element.innerHTML = "-" + symbol + parseFloat(value).toFixed(2);
                } else {
                    element.innerHTML = symbol + parseFloat(value).toFixed(2);
                }
            }
        }
    }
}
function addProduct(event) {
    displayPrices();
}
function addToCart(event) {
    const campaignProductId = event.target.value;
    const orderItems = getOrderItems();
    orderItems[campaignProductId] = 1;
    sessionStorage.setItem("fkCart", JSON.stringify(orderItems));
    displayPrices();
}
function removeFromCart(event) {
    const campaignProductId = event.target.value;
    const orderItems = getOrderItems();
    delete orderItems[campaignProductId];
    sessionStorage.setItem("fkCart", JSON.stringify(orderItems));
    displayPrices();
}
function plusQuantity(campaignProductId) {
    const orderItems = getOrderItems();
    const currentQty = parseInt(orderItems[campaignProductId]);
    if (orderItems[campaignProductId]) {
        if (orderItems[campaignProductId] < 999) {
            orderItems[campaignProductId] = currentQty + 1;
        }
    }
    else
        orderItems[campaignProductId] = 1;
    sessionStorage.setItem("fkCart", JSON.stringify(orderItems));
    displayPrices();
}
function minusQuantity(campaignProductId) {
    const orderItems = getOrderItems();
    if (orderItems[campaignProductId]) {
        const currentQty = parseInt(orderItems[campaignProductId]);
        orderItems[campaignProductId] = currentQty - 1;
        if (orderItems[campaignProductId] < 1)
            delete orderItems[campaignProductId];
    }
    sessionStorage.setItem("fkCart", JSON.stringify(orderItems));
    displayPrices();
}
function cartDisplay() {
    const cartTable = document.getElementById("fk-dynamic-cart-table");
    const dynamicCartBody = document.querySelector("tbody[id='fk-dynamic-cart-body']");
    if (!cartTable)
        return;
    const cartProducts = getOrderItemDetails();
    dynamicCartBody.innerHTML = "";
    if (cartProducts && Object.keys(cartProducts).length > 0) {
        for (const [campaignProductId, product] of Object.entries(cartProducts)) {
            const newDynamicCartRow = document.createElement("TR");
            for (cell of cellFormat) {
                if (cell.title.toLowerCase() === "image") {
                    const newDynamicImage = document.createElement("TD");
                    if (cell.id !== "")
                        newDynamicImage.setAttribute("id", cell.id);
                    newDynamicImage.className = "table-cell";
                    const imageUrl = product.variant && product.variant.imageUrl !== "" ? product.variant.imageUrl : product.imageUrl;
                    if (imageUrl !== "") {
                        //put the image here
                        const productImage = document.createElement("img");
                        productImage.src = imageUrl;
                        if (cell.firstChild !== null && cell.firstChild.tagName === "IMG") {
                            productImage.className = cell.firstChild.className;
                            if (cell.firstChild.id !== "")
                                productImage.setAttribute("id",cell.firstChild.id);
                        }
                        newDynamicImage.appendChild(productImage);
                    }
                    newDynamicCartRow.appendChild(newDynamicImage);
                }
                if (cell.title.toLowerCase() === "item") {
                    const newDynamicItem = document.createElement("TD");
                    if (cell.id !== "")
                        newDynamicItem.setAttribute("id", cell.id);
                    newDynamicItem.className = "table-cell";
                    const title = product.variant ? ' ' + product.variant.title : '';
                    newDynamicItem.textContent = product.productName + title;
                    newDynamicCartRow.appendChild(newDynamicItem);
                }
                if (cell.title.toLowerCase() === "quantity") {
                    const quantityColumnId = "#" + cell.id;
                    const iconList = cell.childNodes;
                    const newDynamicQuantity = document.createElement("TD");
                    if (cell.id !== "")
                        newDynamicQuantity.setAttribute("id", cell.id);
                    newDynamicQuantity.className = "table-cell text-center";
                    const quantitySpan = document.createElement("SPAN");
                    quantitySpan.style.textAlign = "center";
                    quantitySpan.textContent = product.currentOrderQuantity;
                    newDynamicQuantity.appendChild(quantitySpan);
                    if (iconList && iconList.length === 3) {
                        const minusQuantity = document.createElement("I");
                        minusQuantity.className = "fa fa-minus minus-style";
                        if (iconList[0] && iconList[0].id !== "")
                            minusQuantity.setAttribute("id", iconList[0].id);
                        minusQuantity.style.float = "left";
                        minusQuantity.setAttribute('onclick', "minusQuantity(" + campaignProductId + ");");
                        const plusQuantity = document.createElement("I");
                        plusQuantity.className = "fa fa-plus plus-style";
                        if (iconList[2] && iconList[2].id !== "")
                            plusQuantity.setAttribute("id", iconList[2].id);
                        plusQuantity.style.float = "right";
                        plusQuantity.setAttribute('onclick', "plusQuantity(" + campaignProductId + ");");
                        newDynamicQuantity.appendChild(minusQuantity);
                        newDynamicQuantity.appendChild(plusQuantity);

                    }
                    newDynamicCartRow.appendChild(newDynamicQuantity);
                }
                if (cell.title.toLowerCase() === "price") {
                    const newDynamicPrice = document.createElement("TD");
                    if (cell.id !== "")
                        newDynamicPrice.setAttribute("id", cell.id);
                    newDynamicPrice.className = "table-cell";
                    newDynamicPrice.textContent = (product.variant && parseFloat(product.variant.price) > 0) ? product.variant.price : product.cycle1_price;
                    newDynamicCartRow.appendChild(newDynamicPrice);
                }
            }
            dynamicCartBody.appendChild(newDynamicCartRow);
        }
    }
}
function initializeCountryStates(callback) {
    //initialize array of campaign states indexed by countryCode - ex: ["US"] => [{stateCode:"AL",stateName:"Alabama"}]
    pageData.selectedCampaign.states = [];
    //pageData.selectedCampaign.countries = array of campaign country objects - ex: {countryName:"United States", countryCode:"US"}
    //loop through campaign countries array and add empty array at countryCode index
    pageData.selectedCampaign.countries.forEach(function (country) {
        pageData.selectedCampaign.states[country.countryCode] = [];
    });
    //get all possible countries/states data - then loop through and add the campaign country states to the campaignStates array
    //countries array entry looks like this: {countryCode:"US",countryName:"United States",stateCode:"GA",stateName:"Georgia"}
    $.getJSON('konnektfunnels-assets/countries.json', function (data) {
        data.forEach(function (state) {
            if (pageData.selectedCampaign.states[state.countryCode])
                pageData.selectedCampaign.states[state.countryCode].push({ stateCode: state.stateCode, stateName: state.stateName });
        });
        loadCountries("country");
        loadCountries("shipCountry");
        callback && callback();
    });
}
function loadCountries(inputName) {
    const input = document.getElementsByName(inputName)[0];
    if (!input || input.type !== "select-one") return;
    const chooseOptionText = input.options.length > 0 && input.options[0].value === "" ? input.options[0].text : null;
    pageData.selectedCampaign.countries.sort((a, b) => a.countryName.localeCompare(b.countryName));
    input.innerHTML = "";
    let defaultVal = null;
    const orderData = JSON.parse(sessionStorage.getItem("orderData"));
    //Set the default value to the saved session value if it exists
    const sessionVal = orderData && orderData.hasOwnProperty(inputName) && orderData[inputName] !== null ? orderData[inputName] : null;
    if (sessionVal !== null)
        defaultVal = sessionVal;
    for (const country of pageData.selectedCampaign.countries) {
        const option = document.createElement('OPTION');
        option.value = country.countryCode;
        option.innerHTML = country.countryName;
        //Make US the first option if in campaign, then Canada, then list campaign countries alphabetically
        if (country.countryCode === "US" || country.countryCode === "CA")
            input.prepend(option);
        else
            input.add(option);
        if (sessionVal === null) {
            //if Canada is in campaign, set Canada as default value - US will override as default value if US is in campaign
            if (country.countryCode === "CA")
                defaultVal = "CA";
            //if US is in campaign, set US as default value
            if (country.countryCode === "US")
                defaultVal = "US";
        }
    }
    if (chooseOptionText) {
        const chooseOption = document.createElement('OPTION');
        chooseOption.value = "";
        chooseOption.innerHTML = chooseOptionText;
        input.prepend(chooseOption);
        if (defaultVal === null)
            input.value = "";
    }
    else if (defaultVal === null) {
        defaultVal = input.options[0].value;
    }
    if (defaultVal !== null)
        input.value = defaultVal;
    const stateName = inputName === "country" ? "state" : "shipState";
    const stateInput = document.getElementsByName(stateName)[0];
    if (!stateInput || stateInput.type !== "select-one") return;
    input.addEventListener('change', function () { loadStates(stateName, this.value); displayPrices(); });
    if (defaultVal !== null)
        loadStates(stateName, defaultVal);
}
function loadStates(inputName, countryCode) {
    const input = document.getElementsByName(inputName)[0];
    if (!input || input.type !== "select-one") return;
    const chooseOptionText = input.options.length > 0 && input.options[0].value === "" ? input.options[0].text : null;
    input.innerHTML = "";
    const statesArray = pageData.selectedCampaign.states[countryCode];
    if (typeof statesArray === 'undefined' || statesArray.length === 0) return;
    let defaultVal = null;
    const orderData = JSON.parse(sessionStorage.getItem("orderData"));
    //Set the default value to the saved session value if it exists
    if (orderData && orderData.hasOwnProperty(inputName) && orderData[inputName] !== null)
        defaultVal = orderData[inputName];
    for (const state of statesArray) {
        const option = document.createElement('OPTION');
        option.value = state.stateCode;
        option.innerHTML = state.stateName;
        input.add(option);
    }
    if (chooseOptionText) {
        const chooseOption = document.createElement('OPTION');
        chooseOption.value = "";
        chooseOption.innerHTML = chooseOptionText;
        input.prepend(chooseOption);
    }
    if (defaultVal !== null)
        input.value = defaultVal;
    else if (chooseOptionText)
        input.value = "";
    input.addEventListener('change', function () { displayPrices(); });
}
function changeCountry() { return; }
function changeCountry2() { return; }
function loadMonth() {
    const input = document.getElementsByName("cardMonth")[0];
    if (!input || input.type !== "select-one") return;
    if (input.options.length < 12) {
        const chooseOptionText = input.options.length > 0 && input.options[0].text.toLowerCase().indexOf("month") > -1 ? input.options[0].text : null;
        input.innerHTML = "";
        const months = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        for (let i = 0; i < 12; i++) {
            const option = document.createElement('OPTION');
            option.value = (i + 1).toString();
            option.innerHTML = months[i];
            input.add(option);
        }
        if (chooseOptionText) {
            const chooseOption = document.createElement('OPTION');
            chooseOption.value = "";
            chooseOption.innerHTML = chooseOptionText;
            input.prepend(chooseOption);
            input.value = "";
        }
    }
}
function loadYear() {
    const input = document.getElementsByName("cardYear")[0];
    if (!input || input.type !== "select-one") return;
    const chooseOptionText = input.options.length > 0 && input.options[0].text.toLowerCase().indexOf("year") > -1 ? input.options[0].text : null;
    input.innerHTML = "";
    const d = new Date();
    const year = d.getFullYear()
    for (let i = 0; i < 11; i++) {
        const option = document.createElement('OPTION');
        option.value = (year + i).toString();
        option.innerHTML = (year + i).toString();
        input.add(option);
    }
    if (chooseOptionText) {
        const chooseOption = document.createElement('OPTION');
        chooseOption.value = "";
        chooseOption.innerHTML = chooseOptionText;
        input.prepend(chooseOption);
        input.value = "";
    }
}
function loadShipProfiles() {
    const input = document.getElementsByName("shipProfileId")[0];
    if (!input || input.type !== "select-one") return;
    if (pageData.selectedCampaign.shipProfiles.length  === 0) return;
    const chooseOptionText = input.options.length > 0 ? input.options[0].text : null;
    input.innerHTML = "";
    for (const profile of pageData.selectedCampaign.shipProfiles) {
        const option = document.createElement('OPTION');
        option.value = profile.shipProfileId;
        option.innerHTML = profile.profileName;
        input.add(option);
    }
    if (chooseOptionText) {
        const chooseOption = document.createElement('OPTION');
        chooseOption.value = "";
        chooseOption.innerHTML = chooseOptionText;
        input.prepend(chooseOption);
        input.value = "";
    }
    input.addEventListener("change",function(){displayPrices();});
    if (pageData.selectedCampaign.defaultShipProfileId !== null)
        input.value = pageData.selectedCampaign.defaultShipProfileId;
}
function navigate(attributes) {
    const URL = attributes.href.value;
    const target = attributes.target.value;
    if (target !== null && target !== "") {
        window.open(URL, target);
    } else {
        getCurrentWindowLocation().replace(URL);
    }
}

function checkBoxChange(attributes) {
	if (attributes && attributes["name"] && attributes["onclick"]) {
        const name = attributes["name"].value.toLowerCase();
        const checked = attributes["onclick"].ownerElement.checked;
        const bill = ["firstName", "lastName", "address1", "address2", "city", "country", "state", "postalCode", "fullName"];
        const ship = ["shipFirstName", "shipLastName", "shipAddress1", "shipAddress2", "shipCity", "shipCountry", "shipState", "shipPostalCode", "shipFullName"];
		if (name === "billshipsame" && checked) {
            const billLength = bill.length;
            for (let i = 0; i < billLength; i++) {
                const billInput = document.getElementsByName(bill[i])[0];
                const shipInput = document.getElementsByName(ship[i])[0];
                if (billInput && shipInput) {
                    if (billInput.value !== undefined && billInput.value !== '' && billInput.value !== shipInput.value) {
                        shipInput.value = billInput.value;
                        if (ship[i] === 'shipCountry') {
                            loadStates('shipState', shipInput.value);
                            continue;
                        }
                    }
                    if (shipInput.value !== undefined && shipInput.value !== '' && shipInput.value !== billInput.value) {
                        billInput.value = shipInput.value;
                        if (bill[i] === 'country') {
                            loadStates('state', billInput.value);
                            continue;
                        }
                    }
                }
            }
        } else if (name === "billshipsame" && !checked) {
            const parentForm = attributes["name"].ownerElement && attributes["name"].ownerElement.form ? [...attributes["name"].ownerElement.form] : null;
            let billIndex = -1;
            let shipIndex = -1;
            if (parentForm) {
                parentForm.forEach((formElement, index) => {
                    if (formElement.name === "address1") {
                        billIndex = index;
                    }
                    if (formElement.name === "shipAddress1") {
                        shipIndex = index;
                    }
                });
                if (shipIndex == -1 || (billIndex < shipIndex && billIndex > -1)) {
                    clearAddressValues(ship);
                } else {
                    clearAddressValues(bill);
                }
            }
        }
    }
    displayShipSection(attributes);
	displayPrices();
}
// Method created for sliding inputs (JIRA Ticket #FUN2-1745)
function slideForm(attributes, e) {
    e.preventDefault();
    let openID = "";
    let dataType = "";
    if (attributes.openid.value !== "") {
        openID = "#" + attributes.openid.value;
        dataType = attributes.openiddatatype ? attributes.openiddatatype.value : "";
    }
    const buttonHideID = "#" + e.target.id;
    if (openID !== "" && $(openID).is(":hidden")) {
        getCurrentWindowLocation().hash = openID;
        $(openID).slideDown("slow");
        if (dataType !== "form") {
            smoothScrolling(e);
        }
    }
    $(buttonHideID).hide();
}

// Method created for sliding inputs - calling import lead functionality on a sliding input (JIRA Ticket #FUN2-1745)
function slideMethod(attributes, e) {
    e.preventDefault();
    if (e.detail !== 1) {
        return;
    }
    let openID = "";
    let dataType = "";
    if (attributes.openid.value !== "") {
        openID = "#" + attributes.openid.value;
        dataType = attributes.openiddatatype ? attributes.openiddatatype.value : "";
    }
    const buttonId = e.target.dataset.id;
    const buttonHideID = "#" + e.target.id;
    const windowLocation = getCurrentWindowLocation().href;
    const route = windowLocation + openID;
    if (checkRequiredInputs()) {
        disableInteractions(buttonId, true, true);
        importLead(buttonId, route);
        const errorID = "error-" + buttonId;
        setTimeout(function () {
            const tag = document.getElementById(errorID);
            if (windowLocation !== getCurrentWindowLocation().href) {
                if (tag) {
                    tag.setAttribute("id", "");
                    tag.innerHTML = '';
                }
                if (openID !== "" && $(openID).is(":hidden")) {
                    getCurrentWindowLocation().hash = openID;
                    $(openID).slideDown("slow");
                    if (dataType !== "form") {
                        smoothScrolling(e);
                    }
                }
                $(buttonHideID).hide();
            }
            enableInteractions();
        }, 650);
    }
}

function smoothScrolling(e) {
    var target = $(getCurrentWindowLocation().hash);
    target = target.length ? target : $('[name=' + getCurrentWindowLocation().hash.slice(1) + ']');
    if (target.length) {
        e.preventDefault();
        $('html, body').animate({
            scrollTop: target.offset().top
        }, 1000, function () {
            var $target = $(target);
            $target.focus();
            if ($target.is(":focus")) {
                return false;
            } else {
                $target.attr('tabindex', '-1');
                $target.focus();
            };
        });
    }
}
function initializePAAY(paayApiKey) {
    var campaignData = pageData.selectedCampaign;
    if (!campaignData) {
        $.ajax({
            url: 'campaign.json?' + Date.now(),
            method: 'get',
            success: function (results) {
                campaignData = results.selectedCampaign;
            }
        });
    }
    //add PAAY attributes to required page inputs
    const inputArray = { "cardNumber": "pan", "cardMonth": "month", "cardYear": "year" };
    if (pageData.pageTypeId === 4) {
        for (const key in inputArray) {
            const input = document.getElementsByName(key)[0];
            if (input) {
                input.setAttribute("data-threeds", inputArray[key]);
                var parent = input.form;
                if (!parent) {
                    parent = document.createElement("form");
                    document.body.append(parent);
                }
            }
        }
    }
    else {
        var parent = document.forms.length !== 0 ? document.forms[0] : null;
        if (!parent) {
            parent = document.createElement("form");
            document.body.append(parent);
        }
        const inputArray = { "cardNumber": "pan", "cardMonth": "month", "cardYear": "year" };
        for (const hiddenInput in inputArray) {
            const input = document.createElement("input");
            input.type = "hidden";
            input.name = hiddenInput;
            input.value = sessionStorage.getItem("paay_" + inputArray[hiddenInput]);
            input.setAttribute("data-threeds", inputArray[hiddenInput]);
            parent.append(input);
        }
    }

    if (parent && campaignData && campaignData.products) {
        if (!parent.id) { parent.id = 'kform' };
        const paayTransIdInput = document.createElement("input");
        paayTransIdInput.type = "hidden";
        paayTransIdInput.name = "x_transaction_id";
        paayTransIdInput.value = "1234";
        paayTransIdInput.setAttribute("data-threeds", "id");
        parent.append(paayTransIdInput);

        const paayAmountInput = document.createElement("input");
        paayAmountInput.type = "hidden";
        paayAmountInput.name = "paayAmount";
        paayAmountInput.id = "paayAmount";
        paayAmountInput.value = "";
        paayAmountInput.setAttribute("data-threeds", "amount");
        parent.append(paayAmountInput);

        const paayRebill = pageData.funnelData.addOns.filter((addOns) => addOns.keyName === "PAAY_fetch_rebill");
        if (paayRebill.length !== 0 && paayRebill[0].keyValue === "1")
            sessionStorage.setItem("paayRebill", 1);

        $.getScript("threeds.min.latest.js", function () {
            let options = '';
            if (document.URL.includes("funnels-build"))
                options = 'endpoint:"https://sandbox-api.3dsintegrator.com", verbose:true, ';

            options += 'autoSubmit:false';

            if (options)
                options = ",{" + options + "}";

            let innerText = "var tds = new ThreeDS('kform','apikey',null,options);";
            innerText = innerText.replace('kform', parent.id);
            innerText = innerText.replace('apikey', paayApiKey);
            innerText = innerText.replace(',options', options);
            const paayScript = document.createElement("script");
            paayScript.innerHTML = innerText;
            document.body.append(paayScript);

            const paayScript2 = document.createElement("script");
            paayScript2.setAttribute('type', 'application/javascript');
            paayScript2.innerHTML = "var id = document.querySelector('[data-threeds=id]'); var uniqueId = function() { return 'id-' + Math.random().toString(36).substr(2, 16); }; id.value = uniqueId();";
            document.body.append(paayScript2);
        });
    }
}
function triggerPAAY() {
    if (typeof tds === "undefined") return;

    const itemId = sessionStorage.getItem("paay_item");
    let items = null;
    let item = null;
    let initialAmount = null;

    if (pageData.pageTypeId === 4) {
        items = getOrderItemDetails();
        item = items[itemId];
        if (items.length > 1 || item.cycle1_price > 0) {
            const { grandTotal } = JSON.parse(sessionStorage.getItem("totals"));
            initialAmount = grandTotal;
        }
        else if (item.billingCycleType === "ONE_TIME") {
            const buttonId = sessionStorage.getItem("paay_buttonId");
            const route = sessionStorage.getItem("paay_route");
            sessionStorage.removeItem("paayEnabled");
            sessionStorage.removeItem("paay_buttonId");
            sessionStorage.removeItem("paay_route");
            sessionStorage.removeItem("paay_item");
            importOrder(buttonId, route);
            return;
        }
        else {
            initialAmount = (parseFloat(item.cycle2_price) + parseFloat(item.cycle2_shipPrice)).toFixed(2);
            sessionStorage.removeItem("paayRebill");
            if (item.trialAuthType !== "HOLDTRIALCHARGE") {
                sessionStorage.setItem("paayInitialAsRebill", "1");
            }
        }
    }
    else {
        //items = getOrderItemDetails();
        item = pageData.selectedCampaign.products.filter(data => data.campaignProductId === parseInt(itemId))[0];
        if (!item) return;
        if (item.cycle1_price > 0)
            initialAmount = (parseFloat(item.cycle1_price) + parseFloat(item.cycle1_shipPrice)).toFixed(2);
        else if (item.billingCycleType === "ONE_TIME") {
            const buttonId = sessionStorage.getItem("paay_buttonId");
            const route = sessionStorage.getItem("paay_route");
            sessionStorage.removeItem("paayEnabled");
            sessionStorage.removeItem("paay_buttonId");
            sessionStorage.removeItem("paay_route");
            sessionStorage.removeItem("paay_item");
            importUpsale(buttonId, route);
            return;
        }
        else {
            initialAmount = (parseFloat(item.cycle2_price) + parseFloat(item.cycle2_shipPrice)).toFixed(2);
            sessionStorage.removeItem("paayRebill");
            if (item.trialAuthType !== "HOLDTRIALCHARGE") {
                sessionStorage.setItem("paayInitialAsRebill", "1");
            }
        }
    }

    if (sessionStorage.getItem("paayRebill") === "1") {
        if (pageData.pageTypeId === 4) {
            items = getOrderItemDetails();
            item = items[itemId];
        }
        else {
            item = pageData.selectedCampaign.products.filter(data => data.campaignProductId === parseInt(itemId))[0];
        }
        if (item.billingCycleType === "ONE_TIME")
            sessionStorage.setItem("paayRebill", 0);
        else {
            const rebillCycle = item.cycle2_price === null && item.cycle2_shipPrice === null ? 1 : 2;
            const rebillAmount = (parseFloat(item["cycle" + rebillCycle + "_price"]) + parseFloat(item["cycle" + rebillCycle + "_shipPrice"])).toFixed(2);
            tds.options.rebill = rebillAmount;
        }
    }

    const paayCallback = function (data, isRebill) {
        if (data.success === true && sessionStorage.getItem("paayRebill") === "1" && sessionStorage.getItem("paayInitial") === null) {
            sessionStorage.setItem("paayInitial", 1);
            return;
        }
        const buttonId = sessionStorage.getItem("paay_buttonId");
        const route = sessionStorage.getItem("paay_route");
        sessionStorage.setItem("paayCompleted", 1);

        sessionStorage.removeItem("paay_buttonId");
        sessionStorage.removeItem("paay_route");
        sessionStorage.removeItem("paay_item");
        sessionStorage.removeItem("paayInitial");

        if (pageData.pageTypeId === 4)
            importOrder(buttonId, route);
        else
            importUpsale(buttonId, route);
    }

    tds.verify(paayCallback, paayCallback, { amount: initialAmount });
    if (tds.errors.length > 0) {
        const buttonId = sessionStorage.getItem("paay_buttonId");
        let tag = document.getElementById("error-" + buttonId);
        if (tag === null) {
            tag = document.createElement("p");
            tag.setAttribute("id", "error-" + buttonId);
        } else {
            tag.innerHTML = '';
        }
        tag.innerHTML = "ERROR: " + tds.errors[0];
        const color = tag.style.color = "red";
        const form = $("button[data-id='" + buttonId + "']").length ? $("button[data-id='" + buttonId + "']") : $("a[data-id='" + buttonId + "']");
        $(tag).insertAfter(form);

        enableInteractions();
    }
}
function openSurveySection(attributes, e) {
    e.preventDefault();
    let parentID = "";
    let targetSurveyID = "";
    if (e.currentTarget.localName === "button") {
        const buttonDataID = e.currentTarget.dataset.id;
        const button = $("button[data-id='" + buttonDataID + "']")[0];
        if (button.parentNode.nodeName === "SECTION") {
            let customName = button.parentNode.attributes.customName ? button.parentNode.attributes.customName.value : "";
            if (customName !== "") {
                customName = customName.replace(" ", "_");
                const custom = "custom_" + customName;
                sessionStorage.setItem(custom, button.innerHTML);
            }
        }
        parentID = "#" + e.target.parentElement.attributes.id.value;
    } else {
        const radioDataID = e.currentTarget.dataset.id;
        const radioButton = $("input[data-id='" + radioDataID + "']")[0];
        const inputContainer = radioButton.parentNode;
        if (inputContainer.parentNode.nodeName === "SECTION") {
            let customName = inputContainer.parentNode.attributes.customName ? inputContainer.parentNode.attributes.customName.value : "";
            if (customName !== "") {
                customName = customName.replace(" ", "_");
                const custom = "custom_" + customName;
                sessionStorage.setItem(custom, inputContainer.lastElementChild.innerHTML);
            }
        }
        parentID = "#" + e.target.parentElement.parentElement.attributes.id.value;
    }
    decrementSectionCount--;
    targetSurveyID += attributes.opensurveysection ? attributes.opensurveysection.value : "";
    if (targetSurveyID && targetSurveyID !== "#" && $(targetSurveyID).is(":hidden")) {
        $(targetSurveyID).slideDown("fast");
        if (parentID && parentID !== "") {
            $(parentID).hide();
        }
        if (decrementSectionCount === 0) {
            $("#progressbar").hide();
            $("#progressbarcontainer").hide();
        }
    } else if (e.target.attributes.opensurveysection) {
        const targetNonSurveyID = "#" + e.target.attributes.opensurveysection.value;
        $(targetNonSurveyID).slideDown("fast");
        if (parentID && parentID !== "") {
            $(parentID).hide();
        }
        if (decrementSectionCount === 0) {
            $("#progressbar").hide();
            $("#progressbarcontainer").hide();
        }
    }
    // Only takes place if progress bar is present
    if (progressBar) {
        const valueSet = 100 / surveySectionCount;
        const newWidth = parseInt(progressBar.style.width.replace("%", "")) + valueSet;
        progressBar.style.width = newWidth + percentage;
        progressBar.innerHTML = Math.round(newWidth) + percentage;
    }
}

function displayShipSection(attributes) {
	if (attributes.openCheckBoxSection && attributes.openCheckBoxSection.value != "") {
		const shippingSectionID = "#" + attributes.openCheckBoxSection.value;
		const shippingSectionIDElement =  $(shippingSectionID);
		const nestedHTML = shippingSectionIDElement && shippingSectionIDElement[0] && shippingSectionIDElement[0].outerHTML;
		const openCheckBoxElement = $(nestedHTML).find("[opencheckboxsection]");
		$(openCheckBoxElement).each(function() {
			const openCheckBoxName = $(this).attr("name");
			const openCheckBoxNameElement = document.getElementsByName(openCheckBoxName);
			const checked = openCheckBoxNameElement && openCheckBoxNameElement[0] && openCheckBoxNameElement[0].checked;
			const openCheckBoxValue = $(this).attr("opencheckboxsection");
			const elementId = "#" + openCheckBoxValue;
			if (openCheckBoxName == "billShipSame") {
				checked ? $(elementId).hide() : $(elementId).slideDown();
			} else {
				checked ? $(elementId).slideDown() : $(elementId).hide();
			}
		})
		if (attributes && attributes[0].nodeValue == "radio") {
                $("input:radio").each(function() {
                    const openCheckBoxSectionValue = $(this).attr("openCheckBoxSection");
                    if (openCheckBoxSectionValue) {
                        const checkedValue = $(this)[0] && $(this)[0].checked;
                        if (checkedValue) {
                            $("#" + openCheckBoxSectionValue).slideDown();
                        } else {
                            $("#" + openCheckBoxSectionValue).hide();
                        }
                    }
                })
		}
		else {
			$(shippingSectionID).is(":hidden") ? $(shippingSectionID).slideDown() : $(shippingSectionID).slideUp();
		}
	}
}
function disableButtons(disabled) {
    const buttons = document.getElementsByTagName("button");
    if (buttons.length !== 0) {
        for (const buttonEl of buttons)
            buttonEl.disabled = disabled;
    }
}
function disableLinks(pointerEvents) {
    const links = document.getElementsByTagName("a");
    if (links.length !== 0) {
        for (const linkEl of links)
            linkEl.style.pointerEvents = pointerEvents;
    }
}
function turnOnSpinner(buttonOrLinkId) {
    const buttonElement = $("button[data-id='" + buttonOrLinkId + "']").length ? $("button[data-id='" + buttonOrLinkId + "']") : $("a[data-id='" + buttonOrLinkId + "']");
    const spinner = document.getElementById("fk-submit-spinner");
    if (spinner)
        spinner.style.display = "block";
    else {
        $(getSpinnerDiv()).insertAfter(buttonElement);
    }
}
function getSpinnerDiv() {
    const spinnerDiv = document.createElement("div");
    spinnerDiv.id = "fk-submit-spinner";
    spinnerDiv.className = "fa fa-spinner fa-pulse fa-lg m-r-xs";
    spinnerDiv.style.display = "block";
    spinnerDiv.style.textAlign = "center";
    return spinnerDiv;
}
function turnOffSpinner() {
    const fkSpinner = document.getElementById("fk-submit-spinner");
    if (fkSpinner)
        fkSpinner.style.display = "none";
}
function disableInteractions(id, isButton, isLink) {
    isButton && disableButtons(true);
    isLink && disableLinks("none");
    turnOnSpinner(id);
}
function enableInteractions() {
    disableButtons(false);
    disableLinks("auto");
    turnOffSpinner();
}
function moveToNextTab() {
    $("#shipping").hide();
    $("#payment").show();
    $("#quantityTab").addClass("active");
    $("#shippingTab").removeClass("active");
}
function loadPlacesAutocomplete() {
    if (pageData.funnelData && pageData.funnelData.addOns && (pageData.pageTypeId === 2 || pageData.pageTypeId === 4 || pageData.pageTypeId === 8)) {
        const googlePlacesKey = pageData.funnelData.addOns.filter((addOns) => addOns.keyName === "Google_Places");
        if (googlePlacesKey.length !== 0 && googlePlacesKey[0].keyValue) {
            googlePlacesKey && loadScript("https://maps.googleapis.com/maps/api/js?key=" + googlePlacesKey[0].keyValue + "&libraries=places", configureAutocomplete);
        }
    }
}
function initAddressFields() {
    loadPlacesAutocomplete();
    addPhoneNumberSanitizer();
}
function initSocialProof() {
    if (pageData.funnelData && pageData.funnelData.addOns) {
        const socialProofKey = pageData.funnelData.addOns.filter((addOns) => addOns.keyName === "Social_Proof");
        if (socialProofKey.length !== 0 && socialProofKey[0].keyValue) {
            var newScript = document.createElement("script");
            newScript.type = "text/javascript";
            newScript.src = "https://cdn-kk.cappedoutsocial.com/widget/js/popup-" + socialProofKey[0].keyValue + ".js";
            document.body.appendChild(newScript);
        }
    }
}
function assignProdQtyEventListeners() {
    const productSections = document.getElementsByClassName("fk-product-section");
    for (const productSection of productSections) {
        const product = pageData.selectedCampaign && pageData.selectedCampaign.products.filter(data => data.campaignProductId == productSection.getAttribute("value"));
        if(product && product[0] && product[0].maxOrderQty){
            const quantityInput = productSection.querySelectorAll("input[name='quantity']");
            quantityInput && quantityInput[0] && quantityInput[0].addEventListener('change', function(event) {
                quantityProdSectionOnChange(event, product[0].maxOrderQty);
            })
        }
    }
}
function quantityProdSectionOnChange(event, maxOrderQty) {
    if(event.target.value > maxOrderQty) {
        $("#alertTopAutoHideDiv") && $("#alertTopAutoHideDiv").remove();
        $("body").prepend("<div id='alertTopAutoHideDiv' style='position:fixed; top:0; left:0; width:100%; z-index:999;'><div class='alert alert-danger alert-dismissible' role='alert' ><strong> Quantity cannot exceed " + maxOrderQty + " </strong><button type='button' class='close' data-dismiss='alert' aria-label='Close'> <span aria-hidden='true'>&times;</span></button></div></div>");
        event.target.value = maxOrderQty;
        setTimeout(function() {
            $("#alertTopAutoHideDiv").remove();
        }, 4000);
    }
    if(event.target.value <= 0) {
        event.target.value = "";
    }
}
function fillInAddress() {
    // Get the place details from the autocomplete object.
    const address_components = address1FieldAutComplete.getPlace().address_components;
    document.getElementsByName("address1")[0].value = getAddressField("street_number", address_components) + " " + getAddressField("route", address_components);
    document.getElementsByName("city")[0].value = getAddressField("locality", address_components);
    document.getElementsByName("country")[0].value = getAddressField("country", address_components);
    document.getElementsByName("postalCode")[0].value = getAddressField("postal_code", address_components);
    loadStates("state", document.getElementsByName("country")[0].value);
    document.getElementsByName("state")[0].value = getAddressField("administrative_area_level_1", address_components);
}
function fillInShipAddress() {
    // Get the place details from the autocomplete object.
    const address_components = shipAddress1FieldAutComplete.getPlace().address_components;
    document.getElementsByName("shipAddress1")[0].value = getAddressField("street_number", address_components) + " " + getAddressField("route", address_components);
    document.getElementsByName("shipCity")[0].value = getAddressField("locality", address_components);
    document.getElementsByName("shipCountry")[0].value = getAddressField("country", address_components);
    document.getElementsByName("shipPostalCode")[0].value = getAddressField("postal_code", address_components);
    loadStates("shipState", document.getElementsByName("shipCountry")[0].value);
    document.getElementsByName("shipState")[0].value = getAddressField("administrative_area_level_1", address_components);
}
function getAddressField(field, address_components) {
    const fieldObj = address_components.filter(e => e.types.includes(field));
    if (fieldObj.length) {
        if (field === "administrative_area_level_1" || field === "country") {
            return fieldObj[0].short_name;
        }
        else {
            return fieldObj[0].long_name;
        }
    } else {
        return "";
    }
}
function configureAutocomplete() {
    const addressField = document.getElementsByName("address1")[0];
    const campaignCountries = pageData.selectedCampaign.countries.map(e => e.countryCode);
    const options = { types: ['address'] };
    if (campaignCountries.length && campaignCountries.length <= 5) {
        options.componentRestrictions = { country: campaignCountries };
    }
    if (addressField) {
        address1FieldAutComplete = new google.maps.places.Autocomplete(addressField, options);
        address1FieldAutComplete.setFields(['address_component']);
        google.maps.event.addListener(address1FieldAutComplete, 'place_changed', fillInAddress);
    }
    const shipAddressField = document.getElementsByName("shipAddress1")[0];
    if (shipAddressField) {
        shipAddress1FieldAutComplete = new google.maps.places.Autocomplete(shipAddressField, options);
        shipAddress1FieldAutComplete.setFields(['address_component']);
        google.maps.event.addListener(shipAddress1FieldAutComplete, 'place_changed', fillInShipAddress);
    }
    setTimeout(()=>{
        // Resetting the default placeholder set by Google
        if (addressField && addressField.placeholder === "Enter a location") {
            addressField.placeholder = "";
        }
        if (shipAddressField && shipAddressField.placeholder === "Enter a location") {
            shipAddressField.placeholder = "";
        }
    },1000);
}
function getCurrentWindowLocation(){
    if ( window.location !== window.parent.location ) {
        //  Inside IFrame
        return window.parent.location;
    } else {
        return window.location;
    }
}
function setCurrentWindowLocation(route){
    if ( window.location !== window.parent.location ) {
        //  Inside IFrame
        window.parent.location.href = route;
    } else {
        window.location.href = route;
    }
}
function loadProfilePage(){
    const membership = JSON.parse(sessionStorage.getItem("membership")).message.data[0];
    memberFields.forEach(field => {
        document.getElementsByName(field)[0].value = membership[field];
    });
}
function loadScript(url, callback) {
    // Adding the script tag to the head as suggested before
    const head = document.head;
    const script = document.createElement('script');
    script.type = 'text/javascript';
    script.src = url;
    // Then bind the event to the callback function.
    // There are several events for cross browser compatibility.
    script.onreadystatechange = callback;
    script.onload = callback;

    // Fire the loading
    head.appendChild(script);
}
function clearAddressValues(addressOrigin) {
    const addressLength = addressOrigin.length;
    for (let i = 0; i < addressLength; i++) {
        if (document.getElementsByName(addressOrigin[i])[0] && document.getElementsByName(addressOrigin[i])[0].value != '') {
            document.getElementsByName(addressOrigin[i])[0].value = '';
        }
    }
}
function openPopUp() {
    let modal = document.getElementById("customizable_popup");
    if (modal) {
        modal.style.display = "block";
    }
}
function replaceTokens() {
    const headerAndLabelList = ["H1", "H2", "H3", "H4", "H5", "H6", "P", "LABEL", "SPAN"];
    const textBoxesAndLabels = document.querySelectorAll("label, input[type='text'], div, h1, h2, h3, h4, h5, h6, p, span");
    textBoxesAndLabels.forEach((el) => {
        if (el.tagName == "INPUT") {
            assignTokenValues("input", el);
        }
        if (headerAndLabelList.indexOf(el.tagName) > -1) {
            assignTokenValues("label", el);
        }
        if (el.tagName == "DIV") {
            if (el.childNodes[0] && el.childNodes[0].nodeName == "#text") {
                assignTokenValues("label", el);
            }
        }
    });
}

function assignTokenValues(inputType, el) {
    const date = new Date();
    const orderData = JSON.parse(sessionStorage.getItem("orderData"));
    const membershipInfo = getMembershipDetails();
    const membership = membershipInfo ? membershipInfo.message.data[0] : [];
    let formattedValue = "";
    let tokenValue = "";
    let token = "";
    if (inputType == "input") {
        tokenValue = el.value;
    }
    if (inputType == "label") {
        tokenValue = el.innerHTML;
    }
    let remSubstring = tokenValue.match(/{{(.*?)}}/g);
    if (remSubstring && remSubstring.length > 0) {
        for (let i = 0; i < remSubstring.length; i++) {
            let trimmedString = remSubstring[i].trim().replace(/(?:^(?:&nbsp;)+)|(?:(?:&nbsp;)+$)/g, '');
            token = trimmedString;
            trimmedString = trimmedString.split("{{")[1].split("}}")[0];
            let isDate = trimmedString.indexOf("yy") > -1 || trimmedString.indexOf("MM") > -1 || trimmedString.indexOf("ddd") > -1;
            if (isDate) {
                formattedValue = setDateFormat(date, trimmedString)
            } else if (orderData && orderData[trimmedString]) {
                if (trimmedString.indexOf("date") > -1) {
                    formattedValue = setDateFormat(orderData[trimmedString], "yyyy-MM-dd");
                } else {
                    formattedValue = orderData[trimmedString];
                }
            } else if (membership && membership[trimmedString]) {
                if (trimmedString.indexOf("date") > -1) {
                    formattedValue = setDateFormat(membership[trimmedString], "yyyy-MM-dd");
                } else {
                    formattedValue = membership[trimmedString];
                }
            } else {
                formattedValue = token;
            }
            if (inputType == "input") {
                el.value = tokenValue.replace(token, formattedValue);
                tokenValue = el.value;
            }
            if (inputType == "label") {
                el.innerHTML = tokenValue.replace(token, formattedValue);
                tokenValue = el.innerHTML;
            }
        }
    }
}

function setDateFormat(orderDate, dateFormat) {
    let formattedDate = "";
    const monthShort = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
    const monthLong = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
    const dayShort = ['Sun','Mon','Tue','We$','Thu','Fri','Sat'];
    const dayLong = ['Sun$ay','Mon$ay','Tues$ay','We$nes$ay','Thurs$ay','Fri$ay','Satur$ay'];
    let year = orderDate.getFullYear().toString();
    formattedDate = dateFormat;
    formattedDate = formattedDate.replace('yyyy', year);
    formattedDate = formattedDate.replace('yy', year.substring(2,4));
    formattedDate = formattedDate.replace('MMMM', monthLong[orderDate.getMonth()]);
    formattedDate = formattedDate.replace('MMM', monthShort[orderDate.getMonth()]);
    formattedDate = formattedDate.replace('MM', appendLeadingZeroes(orderDate.getMonth() + 1));
    formattedDate = formattedDate.replace('M', orderDate.getMonth() + 1);
    formattedDate = formattedDate.replace('dddd', dayLong[orderDate.getDay()]);
    formattedDate = formattedDate.replace('ddd', dayShort[orderDate.getDay()]);
    formattedDate = formattedDate.replace('dd', appendLeadingZeroes(orderDate.getDate()));
    formattedDate = formattedDate.replace('d', orderDate.getDate());
    formattedDate = formattedDate.replace(/\$/g, 'd');    //so the replace on line above this does not get "day"
    return formattedDate;
}

function affixImports(type, url, onloadFunction) {
    if (type === "js"){
        var newScript = document.createElement("script");
        var scriptData = document.getElementById("scriptData");
        if (onloadFunction) { newScript.onload = onloadFunction; }
        document.body.insertBefore(newScript, scriptData);
        newScript.src = url;
    } else {
        // To move the links to head if anything is present other than it
        var listItems = document.getElementsByTagName("link");
        Array.from(listItems, (elem) => {
            if (elem.parentElement.nodeName !== "HEAD") {
                document.head.appendChild(elem);
            }
        });
        var newLink = document.createElement("link");
        document.head.insertBefore(newLink, listItems[listItems.length - 1].nextSibling);
        newLink.rel = "stylesheet";
        newLink.href = url;
    }
}
function configurePopup() {
    $('<div/>', { 'class': 'dialogContainer', 'id': 'dialogContainer' }).appendTo('body');
    $("#dialogContainer").position({my: "center",at: "center"});
    $('<div/>', { 'class': 'dialogIframeDiv', 'id': 'dialogIframeDiv' }).appendTo("#dialogContainer");
    $( "#dialogIframeDiv" ).dialog({
        resizable: false,
        autoOpen: false,
        height: $( window ).height() * .75,
        width: $( window ).width() * .75,
        show: 'slideDown',
        modal: true,
        open: function() {
            setTimeout(function() {
                    $('.dialogPopupIframe').focus();
            }, 1000);
        },
    });
    $(".ui-dialog-titlebar").css({"background": "none", "border": "0"});
    $(".dialogIframeDiv").css({"padding": "5px"});
    window.addEventListener("resize", function () {
        $( "#dialogIframeDiv" ).dialog({height: $( window ).height() * .75,width: $( window ).width() * .75,});
    });
}
function appendLeadingZeroes(n){
    if (n <= 9) {
      return "0" + n;
    }
    return n
    }
function loadVariants() {
    const productSections = document.getElementsByClassName("fk-product-section");
    if (productSections.length > 0) {
        for (const productSection of productSections) {
            if(productSection.getAttribute("value")) {
                const product = pageData.selectedCampaign && pageData.selectedCampaign.products.filter(data => data.campaignProductId == productSection.getAttribute("value"));
                if (product && product.length > 0) {
                    if (product[0].variants && product[0].variants.length > 0) {
                        ['1', '2', '3'].map((value) => {
                            const productVariants = productSection.querySelectorAll("select[name='variant" + value + "']");
                            if (productVariants && productVariants.length > 0) {
                                product[0].variants.sort(function (a, b) { return a['variantOptionSequence' + value] - b['variantOptionSequence' + value] });
                                let usedValues = [];
                                productVariants[0].innerHTML = '';
                                for (const variant of product[0].variants) {
                                    const option = document.createElement('OPTION');
                                    option.value = variant['variantOptionName' + value];
                                    option.innerHTML = variant['variantOptionName' + value];
                                    if (!usedValues.includes(variant['variantOptionName' + value])) {
                                        productVariants[0].add(option);
                                        usedValues.push(variant['variantOptionName' + value]);
                                    }
                                }
                            }
                        });
                    }
                    //remove products from cart
                    const orderItems = getOrderItems();
                    for (const sessionItemCpId in orderItems) {
                        if (sessionItemCpId.indexOf(".") > 0) {
                            const productData = sessionItemCpId.split(".");
                            if (productData[0] == product[0].campaignProductId) {
                                delete orderItems[sessionItemCpId];
                                const variant = product[0].variants.filter(data => data.variantDetailId == productData[1]);
                                if (variant && variant.length > 0) {
                                    ['1', '2', '3'].map((value) => {
                                        const productVariants = productSection.querySelectorAll("select[name='variant" + value + "']");
                                        if (productVariants && productVariants.length > 0) {
                                            productVariants[0].value = variant[0]['variantOptionName' + value];
                                        }
                                    });
                                }
                            }
                        } else if (sessionItemCpId == product[0].campaignProductId) {
                            const button = productSection.querySelectorAll("button");
                            if(button && button.length > 0 && button[0].innerHTML === "Select") {
                                button[0].innerHTML = "Selected";
                                button[0].className = "btn btn-success";
                            }
                        }
                    }
                    sessionStorage.setItem("fkCart", JSON.stringify(orderItems));
                }
            }
        }
    }
}

function getVariants() {
	const productSections = document.getElementsByClassName("fk-product-section");
    if (productSections.length > 0) {
        for (const productSection of productSections) {
            if(productSection.getAttribute("value")) {
                const product = pageData.selectedCampaign.products.filter(data => data.campaignProductId == productSection.getAttribute("value"));
                const productVariants = productSection.querySelectorAll("select[name='variant1'], select[name='variant2'], select[name='variant3']");
                const quantity = productSection.querySelectorAll("input[name='quantity'], select[name='quantity']");
                let filteredProductVariants;
                if(quantity && quantity[0] && quantity[0].value > 0 && product && product[0]) {
                    //filter products[0].variants by variant1.value, variant2.value, and variant3.value to get the correct variantDetailId
                    //variant1 should always have a value.  variant2 and 3 may not
                    //set variantDetailId to the filter result (if more than 1 in result, take the first)
                    //this logic also supports products without variants, in a product section

                    if (productVariants && product[0].variants && product[0].variants.length > 0) {
                        filteredProductVariants = product[0].variants.find(function(variantItem) {
                            for(let elem = 0; elem < productVariants.length; elem++) {
                                if (productVariants[elem].value) {
                                    if (variantItem['variantOptionName' + (elem + 1)] !== productVariants[elem].value) {
                                        return false;
                                    }
                                }
                            }
                            return true;
                        });
                    }

                    const variantDetailId = filteredProductVariants ? filteredProductVariants.variantDetailId : null;

                    if(variantDetailId != null || productVariants.length == 0) {
                        let itemKey = productSection.getAttribute("value")
                        if (variantDetailId != null)
                            itemKey += "." + variantDetailId;
                        if (pageData.pageTypeId === 3) {
                            const orderItems = getUpsaleItems();
                            orderItems[itemKey] = quantity[0].value;
                            sessionStorage.setItem("upsalefkCart", JSON.stringify(orderItems));
                        } else {
                            const orderItems = getOrderItems();
                            orderItems[itemKey] = quantity[0].value;
                            sessionStorage.setItem("fkCart", JSON.stringify(orderItems));
                        }
                    }
                }
            }
        }
    }
}

function toggleProductSelection(e) {
    const buttonId = e.target.dataset.id;
    let product = null;

    if (buttonId && buttonId !== "") {
        const button = $("button[data-id='" + buttonId + "']")[0];
        if (button) {
            product = findParentNode(button, "product");
        }
    }

    if (product) {
        if (e.target.innerHTML === "Select") {
            e.target.innerHTML = "Selected";
            e.target.className = "btn btn-success";

            // If this is an upsale page, add product to upsale cart
            // Else add to cart
            if (pageData.pageTypeId === 3) {
                const orderItems = getUpsaleItems();
                orderItems[product.getAttribute("value")] = 1;
                sessionStorage.setItem("upsalefkCart", JSON.stringify(orderItems));
            } else {
                const orderItems = getOrderItems();
                orderItems[product.getAttribute("value")] = 1;
                sessionStorage.setItem("fkCart", JSON.stringify(orderItems));
            }
        } else {
            e.target.innerHTML = "Select";
            e.target.className = "btn btn-primary";

            if (pageData.pageTypeId === 3) {
                const orderItems = getUpsaleItems();
                delete orderItems[product.getAttribute("value")];
                sessionStorage.setItem("upsalefkCart", JSON.stringify(orderItems));
            } else {
                const orderItems = getOrderItems();
                delete orderItems[product.getAttribute("value")];
                sessionStorage.setItem("fkCart", JSON.stringify(orderItems));
            }
        }
    }
}

function findParentNode(el, parentName) {
    while (el.parentNode) {
        el = el.parentNode;
        if (el.getAttribute("name") === parentName) {
            return el;
        }
    }
    return null;
}

//Auto-load inputs with order data submitted on previous pages - Ex: firstName input on checkout page automatically filled with firstName submitted on leadPage
function autoLoadInputs(){
    const orderData = JSON.parse(sessionStorage.getItem("orderData"));
    const inputs = $("input, select");
    let updatePriceTotals = false;
    for(const input of inputs) {
        if (orderData && orderData[input.name]) {
            let formInputs = document.getElementsByName(input.name);
            for(const formInput of formInputs){
                if (formInput.type === "checkbox") {
                    if (orderData[input.name] === 'on' || orderData[input.name] === true || orderData[input.name] === 'true' || orderData[input.name] === '1' || orderData[input.name] === 1)
                        formInput.checked = true;
                    else
                        formInput.checked = false;
                }
                else if (formInput.type === "radio") {
                    if(formInput.value === orderData[input.name])
                        formInput.checked = true;
                }
                else
                    formInput.value = orderData[input.name];
            }
        }
        else if(input.name === "product" && (input.type === "checkbox" || input.type === "radio" )){
            if(fkCart[input.value]){
                input.checked = true;
                updatePriceTotals = true;
            }
        }
    }
    if(updatePriceTotals)
        displayPrices();
}

//Fire pixels returned from Import Click (importClick or useSession function)
function firePixel(pixelHtml) {
    const pixelDiv = document.createElement('DIV');
    pixelDiv.innerHTML = pixelHtml;
    document.body.appendChild(pixelDiv);
}

function getQuantity() {
    let qty = 1;
    const qtyInput = document.getElementsByName('quantity')[0];
    if (qtyInput) {
        qty = parseInt(qtyInput.value) || 1;
        qty = qty > 0 ? qty : 1;
    }
    return qty;
}
function setShoppingCartSpinner() {
    const dynamicCartRow = document.querySelector("tr[id='fk-dynamic-cart-row']");
    if (dynamicCartRow) {
        cellFormat = Array.prototype.slice.call(dynamicCartRow.cells);
        dynamicCartRow.innerHTML = '<td colspan=4>' + getSpinnerDiv().outerHTML+ '</td>';
        dynamicCartRow.style.display = "contents"
    }
}
