<!DOCTYPE html>
<html>
    <head>
        <title>PayPal SDk Integration</title>
		<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script> 
        <script src="https://www.paypal.com/sdk/js?client-id=Adw7Elw4Z6FYeWSBZrNM58jHACQkRa0V1y8ouRKevtXTzOz_iD1_Nly3IFnFRG-RtZNQFR1y36uQ3lbl&merchant-id=3CC8STEWMKQ58&currency=USD&enable-funding=paylater&disable-funding=card" data-partner-attribution-id="3CC8STEWMKQ58"></script> 

	   
   </head>
    <body>
    
        <div id="paypal-button-container"></div>
        
        <script>
            var paypalSdkParams = null;
            var paypalPrePaidType = null;
            paypal.Buttons({
                style: {
                    layout: 'vertical',
                    label:  'paypal'
                },
                onClick: function(data, actions) {
                    try {
                        var fundingSource = data && data.fundingSource && data.fundingSource.toUpperCase(); 
                        if (["VENMO", "PAYLATER"].includes(fundingSource)) {
                            paypalPrePaidType = "PAYPAL_" + fundingSource;
                        }
                        // Call the import order API with the required parameters and additional pass "paypalSdk=1" and "prepaidType=paypalPrePaidType" in the request.
                        if (res && res.result === "SUCCESS" && res.message && res.message.paypalSdkParams) {
                            paypalSdkParams = res.message.paypalSdkParams;
                            return actions.resolve();
                        } else {
                            return actions.reject();
                        }
                    } catch(err) {
                        // Handle error 
                    }
                },
                createOrder: function(data, actions) {
                    try {
                        const orderId = paypalSdkParams && paypalSdkParams.id;
                        if (!orderId) throw new Error("Insufficient data to process PayPal checkout.");
                        return orderId;
                    } catch(err) {
                        // Handle error for missing order id
                    }
                },
                onApprove: function(data, actions) {
                    try {
                        // Call confirm PayPal API with the required parameters and additional pass following parameters
                        // 1. token: data.orderID
                        // 2. payerId: data.payerID
                        // 3. paypalSdk: 1
                        // 4. prepaidType: paypalPrePaidType;
                        // Note the prepaidType passed to import order API must match with the prepaid type passed on to confirm PayPal API. 
                    } catch (err) {
                        throw new Error("Error: Unable to confirm order.");
                    }
                },
                onCancel: function (data) {
                    // Payment cancelled by the customer. 
                },
                onError: function (err) {
                    // Error from PayaPal. 
                }
            }).render('#paypal-button-container');
        </script>
    </body>
</html>