<?php
session_start();
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $sessionId = $_POST['sessionId'];
    //$konnektiveOrderId = $_POST['konnektiveOrderId']; // The orderId from Konnektive, not the PayPal token
    $token = $_POST['token'];
    $payerId = $_POST['payerId'];
	$shipPrice = $_POST['shipPrice'];

    /* Validate inputs
    if (empty($sessionId) || empty($payerId)) {
        http_response_code(400);
        echo json_encode(['result' => 'ERROR', 'message' => 'Missing required parameters']);
        exit;
    }*/

    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://api.konnektive.com/transactions/confirmPaypal/',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30, // Adjust timeout as needed
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => http_build_query(array(
            'loginId' => 'moderher_orders',
            'password' => 'moderher_orders',
            'sessionId' => $sessionId,
            'paypalBillerId' => '32',
            'campaignId' => '56',
            'product1_id' => $_SESSION['productIds'],
            'product1_qty' => '1',
			'paypalSdk' => '1',
            'payerId' => $payerId, 
            'token' => $token, 
			'product1_shipPrice' => $shipPrice ,
            'prepaidType' => $_SESSION['prepaidType'] 
        )),
    ));

    $response = curl_exec($curl);

    if (curl_errno($curl)) {
        $error_msg = curl_error($curl);
        error_log("CURL error: " . $error_msg); // Log the error
        http_response_code(500);
        echo json_encode(['result' => 'ERROR', 'message' => 'CURL error: ' . $error_msg]);
    } else {
        $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        if ($httpCode !== 200) {
            error_log("Unexpected HTTP code: " . $httpCode . " Response: " . $response);
            http_response_code($httpCode);
            echo json_encode(['result' => 'ERROR', 'message' => 'Unexpected HTTP code: ' . $httpCode, 'response' => $response]);
        } else {
			$responseData = json_decode($response, true);
			$_SESSION['reponsedataforuse']=$responseData;

            
            if (isset($responseData['result']) && $responseData['result'] === 'SUCCESS' && isset($responseData['message']['orderId'])) {
                $orderId = $responseData['message']['orderId']; 
                
                $_SESSION['orderIdConfirm'] = $orderId;
                $_SESSION['csutomerEmailAddress'] = $responseData['message']['emailAddress'];
                $_SESSION['totalAmountCC'] = $responseData['message']['totalAmount'];
                $_SESSION['csutomerTtl'] = $responseData['message']['totalAmount'];
                $_SESSION['csutomershipTotal'] = $responseData['message']['shipTotal'];
                $_SESSION['csutomersubTotal'] = $responseData['message']['subTotal'];
                $_SESSION['csutomersalesTax'] = $responseData['message']['salesTax'];

                
            } else {
                
                http_response_code(400);
               }
            echo $response;
			

        }
    }

    curl_close($curl);
}
?>
