<?php
//This code must be included at the top of your script before any output is sent to the browser
//-even before <!DOCTYPE> declaration
require_once realpath(dirname(__FILE__)."/resources/konnektiveSDK.php");
$pageType = "upsellPage1"; //choose from: catalogPage, checkoutPage, upsellPage1, upsellPage2, upsellPage3, upsellPage4, thankyouPage
$deviceType = "ALL"; //choose from: DESKTOP, MOBILE, ALL
$ksdk = new KonnektiveSDK($pageType,$deviceType);
$productId = $ksdk->page->productId;
$upsell = $ksdk->getProduct((int) $productId);


?>
<!DOCTYPE html>
<html>
<head>

<meta name="viewport" content="width=device-width" />
<meta charset="utf-8" />

<?php 
//this line of code must go either inside the <head> </head> tags or inside the <body></body> tags
$ksdk->echoJavascript();
?>
</head>
<body>


<!-- All ktemplate class divs are for presentation purposes only and can be replaced with your own styling and html elements -->  
<div class="ktemplate_pageContainer">
	<div class="ktemplate_boxLeft">
			
		<h2> Add <?php echo $upsell->name; ?>   to your order for <?php echo $ksdk->currencySymbol.$upsell->price ?>? </h2>
		<br>
		
		
		<div style="float:left">
		<img src="<?php echo $upsell->imagePath; ?>" class="kform_upsellImage">
		</div>
		<div style="float:left">
		
		<h3> <?php echo $upsell->name; ?> </h3>
		
		<?php echo $upsell->description; ?>
		
		<?php if($upsell->shipPrice > 0){ ?>
			<p>*additional <?php echo $ksdk->currencySymbol.$upsell->shipPrice ?> s&h charge applies </p>
		<?php } ?>
		</div>
		
		<div style="clear:both"></div>
		<br><br>
		
		<form id="kform"  onsubmit=\"return false\">
			<input type="hidden" name="productId" value="<?php echo $upsell->productId; ?>" noSaveFormValue readonly>
		
			
			<br><br>
			<?php $ksdk->echoUpsaleCheckoutButton(); ?>
			

			<a href="<?php echo $ksdk->redirectsTo; ?>"> No, go to order summary </a>

		</form>
		
		</div>
		<br>
		<br>         
    </div>
</div>

</body>
</html>







