<?php

KformConfig::setConfig(array(
	"isWordpress"=>false,
	"apiLoginId"=>"moderher_orders",
	"apiPassword"=>"moderher_orders",
	"authString"=>"7b971e4c684b78dcf59216ce6b65702c",
	"autoUpdate_allowedIps"=>array("80.248.30.132"),
	"campaignId"=>92,
	"resourceDir"=>"resources/"));




/* 
!---------------------------------IMPORTANT-----------------------------------!

Documentation:
	
	-Full documentation on landing pages can be found at 

Auto-Update Feature:

	-The auto-update feature will automatically update settings on your landing page
	when you make changes to your campaign within the konnektive CRM. Use this feature
	to keep your landing page up-to-date concerning new coupons / shipping options
	and product changes.

	-To use the campaign auto-update feature, the apache or ngix user 
	(depending on your httpd software) must have write access to this file
	
	-If you are not using the auto-update feature, you will need to manually 
	replace this file after making changes to the campaign	
	
!---------------------------------IMPORTANT-----------------------------------!
*/

class KFormConfig
{
	
	public $isWordpress = false;
	public $apiLoginId = '';
	public $apiPassword = '';
	public $resourceDir;
	public $baseDir;
	
	
	public $mobileRedirectUrl;
	public $desktopRedirectUrl;
	
	
	public $continents;
	public $countries;
	public $coupons;
	public $currencySymbol;
	public $currencyCode;
	public $insureShipPrice;
	public $landerType;
	public $offers;
	public $upsells;
	public $products;
	public $shipProfiles;
	public $states;
	public $taxes;
	public $termsOfService;
	public $webPages;
	public $zones;
	
	static $instance = NULL;
	static $options;
	static $campaignData;
	// class constructor to set the variable values	
	
	static function setConfig($options)
	{
		self::$options = $options;	
	}
	
	public function __construct()
	{
		if(!empty(self::$instance))
			throw new Exception("cannot recreated KFormConfig");
		
		foreach((array) self::$options as $k=>$v)
			$this->$k = $v;
			
		if($this->isWordpress)
		{
			$options = get_option('konnek_options');
			foreach((array)$options as $k=>$v)
				$this->$k = $v;
		
			$data = json_decode(get_option('konnek_campaign_data'));
			foreach($data as $k=>$v)
				$this->$k = $v;
		}
		elseif(!empty(self::$campaignData))
		{
			if(json_decode(self::$campaignData) === NULL)
			{
				echo 'JSON in config.php is broken!';
				die;
			}
			else
				$data = (array)json_decode(self::$campaignData);


			foreach($data as $k=>$v)
				$this->$k = $v;
		}

		self::$instance = $this;
		
	
	}
}

/* 
!---------------------------------IMPORTANT-----------------------------------!

	ABSOLUTELY DO NOT EDIT BELOW THIS LINE
	
!---------------------------------IMPORTANT-----------------------------------!
*/
$requestUri = $_SERVER['REQUEST_URI'];
$baseFile = basename(__FILE__);

if($_SERVER['REQUEST_METHOD']=='POST' && strstr($requestUri,$baseFile))
{
	
	$authString = filter_input(INPUT_POST,'authString',FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_LOW | FILTER_FLAG_STRIP_HIGH);
	if(empty($authString))
		die(); //exit silently, don't want people to know that this file processes api requests if they are just sending random posts at it
	
	
	$remoteIp = $_SERVER['REMOTE_ADDR'];
	if (isset($_SERVER["HTTP_CF_CONNECTING_IP"]))
		  $remoteIp =  $_SERVER["HTTP_CF_CONNECTING_IP"];
	
	$allowedIps = KFormConfig::$options['autoUpdate_allowedIps'];
	if(!in_array($remoteIp,$allowedIps))
		die("ERROR: Invalid IP Address. Please confirm that the Konnektive IP Address is in the allowedIps array.");
	if($authString != KFormConfig::$options['authString'])
		die("ERROR: Could not authenticate authString. Please re-download code package and replace config file on your server.");

	$data = filter_input(INPUT_POST,'data');
	$data = trim($data);
	$data = utf8_encode($data);
	$decoded = json_decode($data);
	if($decoded != NULL)
	{
		$file = fopen(__FILE__,'r');
		if(empty($file))
			die("ERROR: File not writable");

		$new_file = '';

		while($line = fgets($file))
		{
			$new_file .= $line;

			if(strpos($line,"/*[DYNAMIC-DATA-TOKEN]") === 0)
				break;
		}
		fclose($file);

		$new_file .= "KFormConfig::\$campaignData = '$data';".PHP_EOL;
		$ret = file_put_contents(__FILE__,$new_file);


		if(is_int($ret))
			die("SUCCESS");
		else
			die("ERROR: File not writable");
	}
	else
	{
		die("ERROR: what data");
	}
}

/*[DYNAMIC-DATA-TOKEN] do not remove */

KFormConfig::$campaignData = '{
    "countries": {
        "US": "United States",
        "CA": "Canada",
        "AU": "Australia",
        "FR": "France",
        "DE": "Germany",
        "IT": "Italy",
        "NZ": "New Zealand",
        "GB": "United Kingdom"
    },
    "states": {
        "GB": {
            "ABE": "Aberdeen City",
            "ABD": "Aberdeenshire",
            "ANS": "Angus",
            "ANT": "Antrim",
            "ARD": "Ards",
            "AGB": "Argyll and Bute",
            "ARM": "Armagh",
            "BLA": "Ballymena",
            "BLY": "Ballymoney",
            "BNB": "Banbridge",
            "BDG": "Barking and Dagenham",
            "BNE": "Barnet",
            "BNS": "Barnsley",
            "BAS": "Bath and North East Somerset",
            "BBO": "Bedford Borough",
            "BDF": "Bedfordshire",
            "BFS": "Belfast",
            "BRK": "Berkshire",
            "BEX": "Bexley",
            "BIR": "Birmingham",
            "BBD": "Blackburn with Darwen",
            "BPL": "Blackpool",
            "BGW": "Blaenau Gwent",
            "BOL": "Bolton",
            "BMH": "Bournemouth",
            "BRC": "Bracknell Forest",
            "BRD": "Bradford",
            "BEN": "Brent",
            "BGE": "Bridgend",
            "BNH": "Brighton and Hove",
            "BST": "Bristol, City of",
            "BRY": "Bromley",
            "BUC": "Buckingham",
            "BKM": "Buckinghamshire",
            "BUR": "Bury",
            "CAY": "Caerphilly",
            "CLD": "Calderdale",
            "CAM": "Cambridgeshire",
            "CMD": "Camden",
            "CRF": "Cardiff",
            "CMN": "Carmarthenshire",
            "CKF": "Carrickfergus",
            "CSR": "Castlereagh",
            "CGN": "Ceredigion",
            "CHS": "Cheshire",
            "CHE": "Cheshire East",
            "CWC": "Cheshire West and Chester",
            "CLK": "Clackmannanshire",
            "CLR": "Coleraine",
            "CWY": "Conwy",
            "CKT": "Cookstown",
            "CON": "Cornwall",
            "COV": "Coventry",
            "CGV": "Craigavon",
            "CRY": "Croydon",
            "CMA": "Cumbria",
            "DAL": "Darlington",
            "DEN": "Denbighshire",
            "DER": "Derby",
            "DBY": "Derbyshire",
            "DRY": "Derry",
            "DEV": "Devon",
            "DNC": "Doncaster",
            "DOR": "Dorset",
            "DOW": "Down",
            "DUD": "Dudley",
            "DGY": "Dumfries and Galloway",
            "DND": "Dundee City",
            "DGN": "Dungannon",
            "DUR": "Durham",
            "EAL": "Ealing",
            "EAY": "East Ayrshire",
            "EDU": "East Dunbartonshire",
            "ELN": "East Lothian",
            "ERW": "East Renfrewshire",
            "ERY": "East Riding of Yorkshire",
            "ESX": "East Sussex",
            "EDH": "Edinburgh, City of",
            "ELS": "Eilean Siar",
            "ENF": "Enfield",
            "ESS": "Essex",
            "FAL": "Falkirk",
            "FER": "Fermanagh",
            "FIF": "Fife",
            "FLN": "Flintshire",
            "GAT": "Gateshead",
            "GLG": "Glasgow City",
            "GLS": "Gloucestershire",
            "GLO": "Greater London",
            "GRE": "Greenwich",
            "GGY": "Guernsey",
            "GWN": "Gwynedd",
            "HCK": "Hackney",
            "HAL": "Halton",
            "HMF": "Hammersmith and Fulham",
            "HAM": "Hampshire",
            "HRY": "Haringey",
            "HRW": "Harrow",
            "HPL": "Hartlepool",
            "HAV": "Havering",
            "HEF": "Herefordshire, County of",
            "HRT": "Hertfordshire",
            "HTF": "Hertfordshire",
            "HLD": "Highland",
            "HIL": "Hillingdon",
            "HNS": "Hounslow",
            "IVC": "Inverclyde",
            "AGY": "Isle of Anglesey",
            "IOM": "Isle of Man",
            "IOW": "Isle of Wight",
            "IOS": "Isles of Scilly",
            "ISL": "Islington",
            "JEY": "Jersey",
            "KEC": "Kensington and Chelsea",
            "KEN": "Kent",
            "KHL": "Kingston upon Hull, City of",
            "KTT": "Kingston upon Thames",
            "KIR": "Kirklees",
            "KWL": "Knowsley",
            "LBH": "Lambeth",
            "LAN": "Lancashire",
            "LRN": "Larne",
            "LDS": "Leeds",
            "LCE": "Leicester",
            "LEC": "Leicestershire",
            "LEW": "Lewisham",
            "LMV": "Limavady",
            "LIN": "Lincolnshire",
            "LSB": "Lisburn",
            "LIV": "Liverpool",
            "LND": "London, City of",
            "LUT": "Luton",
            "MFT": "Magherafelt",
            "MAN": "Manchester",
            "MDW": "Medway",
            "MSY": "Merseyside",
            "MTY": "Merthyr Tydfil",
            "MRT": "Merton",
            "MDB": "Middlesbrough",
            "MDX": "Middlesex",
            "MLN": "Midlothian",
            "MIK": "Milton Keynes",
            "MON": "Monmouthshire",
            "MRY": "Moray",
            "MYL": "Moyle",
            "NTL": "Neath Port Talbot",
            "NET": "Newcastle upon Tyne",
            "NWM": "Newham",
            "NWP": "Newport",
            "NYM": "Newry and Mourne",
            "NTA": "Newtownabbey",
            "NFK": "Norfolk",
            "NAY": "North Ayrshire",
            "NDN": "North Down",
            "NEL": "North East Lincolnshire",
            "NLK": "North Lanarkshire",
            "NLN": "North Lincolnshire",
            "NSM": "North Somerset",
            "NTY": "North Tyneside",
            "NYK": "North Yorkshire",
            "NTH": "Northamptonshire",
            "NBL": "Northumberland",
            "NGM": "Nottingham",
            "NTT": "Nottinghamshire",
            "OLD": "Oldham",
            "OMH": "Omagh",
            "ORK": "Orkney Islands",
            "OXF": "Oxfordshire",
            "PEM": "Pembrokeshire",
            "PKN": "Perth and Kinross",
            "PTE": "Peterborough",
            "PLY": "Plymouth",
            "POL": "Poole",
            "POR": "Portsmouth",
            "POW": "Powys",
            "RDG": "Reading",
            "RDB": "Redbridge",
            "RCC": "Redcar and Cleveland",
            "RFW": "Renfrewshire",
            "RCT": "Rhondda, Cynon, Ta",
            "RIC": "Richmond upon Thames",
            "RCH": "Rochdale",
            "ROT": "Rotherham",
            "RUT": "Rutland",
            "SLF": "Salford",
            "SAW": "Sandwell",
            "SCB": "Scottish Borders, The",
            "SFT": "Sefton",
            "SHF": "Sheffield",
            "ZET": "Shetland Islands",
            "SHR": "Shropshire",
            "SLG": "Slough",
            "SOL": "Solihull",
            "SOM": "Somerset",
            "SAY": "South Ayrshire",
            "SGC": "South Gloucestershire",
            "SLK": "South Lanarkshire",
            "STY": "South Tyneside",
            "SYK": "South Yorkshire",
            "STH": "Southampton",
            "SOS": "Southend-on-Sea",
            "SWK": "Southwark",
            "SHN": "St. Helens",
            "STS": "Staffordshire",
            "STG": "Stirling",
            "SKP": "Stockport",
            "STT": "Stockton-on-Tees",
            "STE": "Stoke-on-Trent",
            "STB": "Strabane",
            "SFK": "Suffolk",
            "SND": "Sunderland",
            "SRY": "Surrey",
            "STN": "Sutton",
            "SWA": "Swansea",
            "SWD": "Swindon",
            "TAM": "Tameside",
            "TFW": "Telford and Wrekin",
            "THR": "Thurrock",
            "TOB": "Torbay",
            "TOF": "Torfaen",
            "TWH": "Tower Hamlets",
            "TRF": "Trafford",
            "VGL": "Vale of Glamorgan, T",
            "WKF": "Wakefield",
            "WLL": "Walsall",
            "WFT": "Waltham Forest",
            "WND": "Wandsworth",
            "WRT": "Warrington",
            "WAR": "Warwickshire",
            "WBK": "West Berkshire",
            "WDU": "West Dunbartonshire",
            "WLN": "West Lothian",
            "WMD": "West Midlands",
            "WSX": "West Sussex",
            "WYK": "West Yorkshire",
            "WSM": "Westminster",
            "WGN": "Wigan",
            "WIL": "Wiltshire",
            "WNM": "Windsor and Maidenhead",
            "WRL": "Wirral",
            "WOK": "Wokingham",
            "WLV": "Wolverhampton",
            "WOC": "Worcester",
            "WOR": "Worcestershire",
            "WRX": "Wrexham",
            "YOR": "York"
        },
        "IT": {
            "65": "Abruzzo",
            "AG": "Agrigento",
            "AL": "Alessandria",
            "AN": "Ancona",
            "AO": "Aosta",
            "AR": "Arezzo",
            "AP": "Ascoli Piceno",
            "AT": "Asti",
            "AV": "Avellino",
            "BA": "Bari",
            "BT": "Barletta-Andria-Trani",
            "77": "Basilicata",
            "BL": "Belluno",
            "BN": "Benevento",
            "BG": "Bergamo",
            "BI": "Biella",
            "BO": "Bologna",
            "BZ": "Bolzano",
            "BS": "Brescia",
            "BR": "Brindisi",
            "CA": "Cagliari",
            "78": "Calabria",
            "CL": "Caltanissetta",
            "72": "Campania",
            "CB": "Campobasso",
            "CI": "Carbonia-Iglesias",
            "CE": "Caserta",
            "CT": "Catania",
            "CZ": "Catanzaro",
            "CH": "Chieti",
            "CO": "Como",
            "CS": "Cosenza",
            "CR": "Cremona",
            "KR": "Crotone",
            "CN": "Cuneo",
            "45": "Emilia-Romagna",
            "EN": "Enna",
            "FM": "Fermo",
            "FE": "Ferrara",
            "FI": "Firenze",
            "FG": "Foggia",
            "FC": "Forli-Cesena",
            "36": "Friuli-Venezia Giulia",
            "FR": "Frosinone",
            "GE": "Genova",
            "GO": "Gorizia",
            "GR": "Grosseto",
            "IM": "Imperia",
            "IS": "Isernia",
            "AQ": "L\u0027Aquila",
            "SP": "La Spezia",
            "LT": "Latina",
            "62": "Lazio",
            "LE": "Lecce",
            "LC": "Lecco",
            "42": "Liguria",
            "LI": "Livorno",
            "LO": "Lodi",
            "25": "Lombardia",
            "LU": "Lucca",
            "MC": "Macerata",
            "MN": "Mantova",
            "57": "Marche",
            "MS": "Massa-Carrara",
            "MT": "Matera",
            "VS": "Medio Campidano",
            "ME": "Messina",
            "MI": "Milano",
            "MO": "Modena",
            "67": "Molise",
            "MB": "Monza e Brianza",
            "NA": "Napoli",
            "NO": "Novara",
            "NU": "Nuoro",
            "OG": "Ogliastra",
            "OT": "Olbia-Tempio",
            "OR": "Oristano",
            "PD": "Padova",
            "PA": "Palermo",
            "PR": "Parma",
            "PV": "Pavia",
            "PG": "Perugia",
            "PU": "Pesaro e Urbino",
            "PE": "Pescara",
            "PC": "Piacenza",
            "21": "Piemonte",
            "PI": "Pisa",
            "PT": "Pistoia",
            "PN": "Pordenone",
            "PZ": "Potenza",
            "PO": "Prato",
            "75": "Puglia",
            "RG": "Ragusa",
            "RA": "Ravenna",
            "RC": "Reggio Calabria",
            "RE": "Reggio Emilia",
            "RI": "Rieti",
            "RN": "Rimini",
            "RM": "Roma",
            "RO": "Rovigo",
            "SA": "Salerno",
            "88": "Sardegna",
            "SS": "Sassari",
            "SV": "Savona",
            "82": "Sicilia",
            "SI": "Siena",
            "SR": "Siracusa",
            "SO": "Sondrio",
            "TA": "Taranto",
            "TE": "Teramo",
            "TR": "Terni",
            "TO": "Torino",
            "52": "Toscana",
            "TP": "Trapani",
            "32": "Trentino-Alto Adige",
            "TN": "Trento",
            "TV": "Treviso",
            "TS": "Trieste",
            "UD": "Udine",
            "55": "Umbria",
            "23": "Valle d\u0027Aosta",
            "VA": "Varese",
            "34": "Veneto",
            "VE": "Venezia",
            "VB": "Verbano-Cusio-Ossola",
            "VC": "Vercelli",
            "VR": "Verona",
            "VV": "Vibo Valentia",
            "VI": "Vicenza",
            "VT": "Viterbo"
        },
        "FR": {
            "01": "Ain",
            "02": "Aisne",
            "03": "Allier",
            "04": "Alpes-de-Haute-Provence",
            "06": "Alpes-Maritimes",
            "07": "Ard\u00e8che",
            "08": "Ardennes",
            "09": "Ari\u00e8ge",
            "10": "Aube",
            "11": "Aude",
            "12": "Aveyron",
            "67": "Bas-Rhin",
            "13": "Bouches-du-Rh\u00f4ne",
            "14": "Calvados",
            "15": "Cantal",
            "16": "Charente",
            "17": "Charente-Maritime",
            "18": "Cher",
            "CP": "Clipperton",
            "19": "Corr\u00e8ze",
            "2A": "Corse-du-Sud",
            "21": "C\u00f4te-d\u0027Or",
            "22": "C\u00f4tes-d\u0027Armor",
            "23": "Creuse",
            "79": "Deux-S\u00e8vres",
            "24": "Dordogne",
            "25": "Doubs",
            "26": "Dr\u00f4me",
            "91": "Essonne",
            "27": "Eure",
            "28": "Eure-et-Loir",
            "29": "Finist\u00e8re",
            "30": "Gard",
            "32": "Gers",
            "33": "Gironde",
            "68": "Haut-Rhin",
            "2B": "Haute-Corse",
            "31": "Haute-Garonne",
            "43": "Haute-Loire",
            "52": "Haute-Marne",
            "70": "Haute-Sa\u00f4ne",
            "74": "Haute-Savoie",
            "87": "Haute-Vienne",
            "05": "Hautes-Alpes",
            "65": "Hautes-Pyr\u00e9n\u00e9es",
            "92": "Hauts-de-Seine",
            "34": "H\u00e9rault",
            "35": "Ille-et-Vilaine",
            "36": "Indre",
            "37": "Indre-et-Loire",
            "38": "Is\u00e8re",
            "39": "Jura",
            "40": "Landes",
            "41": "Loir-et-Cher",
            "42": "Loire",
            "44": "Loire-Atlantique",
            "45": "Loiret",
            "46": "Lot",
            "47": "Lot-et-Garonne",
            "48": "Loz\u00e8re",
            "49": "Maine-et-Loire",
            "50": "Manche",
            "51": "Marne",
            "53": "Mayenne",
            "YT": "Mayotte",
            "54": "Meurthe-et-Moselle",
            "55": "Meuse",
            "56": "Morbihan",
            "57": "Moselle",
            "58": "Ni\u00e8vre",
            "59": "Nord",
            "NC": "Nouvelle-Cal\u00e9donie",
            "60": "Oise",
            "61": "Orne",
            "75": "Paris",
            "62": "Pas-de-Calais",
            "PF": "Polyn\u00e9sie fran\u00e7aise",
            "63": "Puy-de-D\u00f4me",
            "64": "Pyr\u00e9n\u00e9es-Atlantiques",
            "66": "Pyr\u00e9n\u00e9es-Orientales",
            "69": "Rh\u00f4ne",
            "BL": "Saint-Barth\u00e9lemy",
            "MF": "Saint-Martin",
            "PM": "Saint-Pierre-et-Miquelon",
            "71": "Sa\u00f4ne-et-Loire",
            "72": "Sarthe",
            "73": "Savoie",
            "77": "Seine-et-Marne",
            "76": "Seine-Maritime",
            "93": "Seine-Saint-Denis",
            "80": "Somme",
            "81": "Tarn",
            "82": "Tarn-et-Garonne",
            "TF": "Terres Australes Fran\u00e7aises",
            "90": "Territoire de Belfort",
            "95": "Val-d\u0027Oise",
            "94": "Val-de-Marne",
            "83": "Var",
            "84": "Vaucluse",
            "85": "Vend\u00e9e",
            "86": "Vienne",
            "88": "Vosges",
            "WF": "Wallis et Futuna",
            "89": "Yonne",
            "78": "Yvelines"
        },
        "CA": {
            "AB": "Alberta",
            "BC": "British Columbia",
            "MB": "Manitoba",
            "NB": "New Brunswick",
            "NL": "Newfoundland and Labrador",
            "NT": "Northwest Territories",
            "NS": "Nova Scotia",
            "NU": "Nunavut",
            "ON": "Ontario",
            "PE": "Prince Edward Island",
            "QC": "Quebec",
            "SK": "Saskatchewan",
            "YT": "Yukon"
        },
        "NZ": {
            "AUK": "Auckland",
            "BOP": "Bay of Plenty",
            "CAN": "Canterbury",
            "CIT": "Chatham Islands Territory",
            "GIS": "Gisborne District",
            "HKB": "Hawkes\u0027s Bay",
            "MWT": "Manawatu-Wanganui",
            "MBH": "Marlborough District",
            "NSN": "Nelson City",
            "N": "North Island",
            "NTL": "Northland",
            "OTA": "Otago",
            "S": "South Island",
            "STL": "Southland",
            "TKI": "Taranaki",
            "TAS": "Tasman District",
            "WKO": "Waikato",
            "WGN": "Wellington",
            "WTC": "West Coast"
        },
        "AU": {
            "ACT": "Australian Capital Territory",
            "NSW": "New South Wales",
            "NT": "Northern Territory",
            "QLD": "Queensland",
            "SA": "South Australia",
            "TAS": "Tasmania",
            "VIC": "Victoria",
            "WA": "Western Australia"
        },
        "DE": {
            "BW": "Baden-W\u00fcrttemberg",
            "BY": "Bayern",
            "BE": "Berlin",
            "BB": "Brandenburg",
            "HB": "Bremen",
            "HH": "Hamburg",
            "HE": "Hessen",
            "MV": "Mecklenburg-Vorpommern",
            "NI": "Niedersachsen",
            "NW": "Nordrhein-Westfalen",
            "RP": "Rheinland-Pfalz",
            "SL": "Saarland",
            "SN": "Sachsen",
            "ST": "Sachsen-Anhalt",
            "SH": "Schleswig-Holstein",
            "TH": "Th\u00fcringen"
        },
        "US": {
            "AL": "Alabama",
            "AK": "Alaska",
            "AZ": "Arizona",
            "AR": "Arkansas",
            "CA": "California",
            "CO": "Colorado",
            "CT": "Connecticut",
            "DE": "Delaware",
            "DC": "District of Columbia",
            "FL": "Florida",
            "GA": "Georgia",
            "HI": "Hawaii",
            "ID": "Idaho",
            "IL": "Illinois",
            "IN": "Indiana",
            "IA": "Iowa",
            "KS": "Kansas",
            "KY": "Kentucky",
            "LA": "Louisiana",
            "ME": "Maine",
            "MD": "Maryland",
            "MA": "Massachusetts",
            "MI": "Michigan",
            "MN": "Minnesota",
            "MS": "Mississippi",
            "MO": "Missouri",
            "MT": "Montana",
            "NE": "Nebraska",
            "NV": "Nevada",
            "NH": "New Hampshire",
            "NJ": "New Jersey",
            "NM": "New Mexico",
            "NY": "New York",
            "NC": "North Carolina",
            "ND": "North Dakota",
            "OH": "Ohio",
            "OK": "Oklahoma",
            "OR": "Oregon",
            "PA": "Pennsylvania",
            "RI": "Rhode Island",
            "SC": "South Carolina",
            "SD": "South Dakota",
            "TN": "Tennessee",
            "TX": "Texas",
            "UT": "Utah",
            "VT": "Vermont",
            "VA": "Virginia",
            "WA": "Washington",
            "WV": "West Virginia",
            "WI": "Wisconsin",
            "WY": "Wyoming",
            "AS": "American Samoa",
            "FM": "Federated States of Micronesia",
            "GU": "Guam",
            "MP": "Northern Mariana Islands",
            "PR": "Puerto Rico",
            "MH": "Republic of Marshall Islands",
            "VI": "Virgin Islands of the U.S.",
            "AA": "Armed Forces Americas",
            "AE": "Armed Forces Canada, Armed Forces Europe, Armed Forces Middle East, Armed Forces Africa",
            "AP": "Armed Forces Pacific"
        }
    },
    "currencySymbol": "$",
    "shipOptions": [],
    "coupons": [],
    "products": [],
    "webPages": {
        "checkoutPage": {
            "disableBack": 0,
            "url": "https:\/\/betterguthealthdaily.com\/beauty-tips\/order\/index.php",
            "autoImportLead": 1,
            "productId": 7467,
            "requireSig": 0,
            "sigType": 0,
            "cardinalAuth": 0,
            "paayApiKey": null
        },
        "presellPage": {
            "disableBack": 0,
            "url": "https:\/\/betterguthealthdaily.com\/beauty-tips\/",
            "fireClickPixel": 0
        },
        "thankyouPage": {
            "disableBack": 0,
            "url": "https:\/\/betterguthealthdaily.com\/beauty-tips\/order\/thankyou.php",
            "createAccountDialog": 0,
            "reorderUrl": null,
            "allowReorder": 0
        },
        "upsellPage1": {
            "disableBack": 1,
            "url": "https:\/\/betterguthealthdaily.com\/beauty-tips\/order\/upsell1.php",
            "createAccountDialog": 0,
            "requirePayInfo": 0,
            "productId": 7031,
            "replaceProductId": null
        }
    },
    "landerType": "SINGLE",
    "googleTrackingId": null,
    "currencyCode": "USD",
    "enableFraudPlugin": 0,
    "autoTax": 0,
    "taxServiceId": null,
    "companyName": "anthony_alayon_llc",
    "offers": {
        "7025": {
            "productId": 7025,
            "name": "REVITL-1-BOTTLE 10% OFF",
            "description": "REVITL-1-BOTTLE",
            "imagePath": "https:\/\/betterguthealthdaily.com\/images-prod\/rev-1.png",
            "imageId": 9,
            "price": "53.00",
            "shipPrice": "8.95",
            "category": "REVITIL",
            "variants": []
        },
        "7026": {
            "productId": 7026,
            "name": "REVITL-3-BOTTLE 10% OFF",
            "description": "REVITL-1-BOTTLE",
            "imagePath": "https:\/\/betterguthealthdaily.com\/images-prod\/rev-3.png",
            "imageId": 10,
            "price": "132.00",
            "shipPrice": "0.00",
            "category": "REVITIL",
            "variants": []
        },
        "7027": {
            "productId": 7027,
            "name": "REVITL-6-BOTTLE 10% OFF",
            "description": "REVITL-1-BOTTLE",
            "imagePath": "https:\/\/betterguthealthdaily.com\/images-prod\/rev-6.png",
            "imageId": 11,
            "price": "210.00",
            "shipPrice": "0.00",
            "category": "REVITIL",
            "variants": []
        },
        "7028": {
            "productId": 7028,
            "name": "REVITL-1-BOTTLE",
            "description": "REVITL-1-BOTTLE",
            "imagePath": "https:\/\/betterguthealthdaily.com\/images-prod\/rev-1.png",
            "imageId": 9,
            "price": "59.00",
            "shipPrice": "8.95",
            "category": "REVITIL",
            "variants": []
        },
        "7029": {
            "productId": 7029,
            "name": "REVITL-3-BOTTLE",
            "description": "REVITL-1-BOTTLE",
            "imagePath": "https:\/\/betterguthealthdaily.com\/images-prod\/rev-3.png",
            "imageId": 10,
            "price": "147.00",
            "shipPrice": "0.00",
            "category": "REVITIL",
            "variants": []
        },
        "7030": {
            "productId": 7030,
            "name": "REVITL-6-BOTTLE",
            "description": "REVITL-1-BOTTLE",
            "imagePath": "https:\/\/betterguthealthdaily.com\/images-prod\/rev-6.png",
            "imageId": 11,
            "price": "234.00",
            "shipPrice": "0.00",
            "category": "REVITIL",
            "variants": []
        },
        "7467": {
            "productId": 7467,
            "name": "REVITL-1-BOTTLE",
            "description": "REVITL-1-BOTTLE",
            "imagePath": "https:\/\/betterguthealthdaily.com\/images-prod\/rev-1.png",
            "imageId": 9,
            "price": "49.00",
            "shipPrice": "8.95",
            "category": "REVITIL",
            "variants": []
        },
        "7468": {
            "productId": 7468,
            "name": "REVITL-3-BOTTLE",
            "description": "REVITL-1-BOTTLE",
            "imagePath": "https:\/\/betterguthealthdaily.com\/images-prod\/rev-3.png",
            "imageId": 10,
            "price": "117.00",
            "shipPrice": "0.00",
            "category": "REVITIL",
            "variants": []
        },
        "7469": {
            "productId": 7469,
            "name": "REVITL-6-BOTTLE",
            "description": "REVITL-1-BOTTLE",
            "imagePath": "https:\/\/betterguthealthdaily.com\/images-prod\/rev-6.png",
            "imageId": 11,
            "price": "174.00",
            "shipPrice": "0.00",
            "category": "REVITIL",
            "variants": []
        },
        "7470": {
            "productId": 7470,
            "name": "REVITL-1-BOTTLE 10% OFF",
            "description": "REVITL-1-BOTTLE",
            "imagePath": "https:\/\/betterguthealthdaily.com\/images-prod\/rev-1.png",
            "imageId": 9,
            "price": "44.00",
            "shipPrice": "8.95",
            "category": "REVITIL",
            "variants": []
        },
        "7471": {
            "productId": 7471,
            "name": "REVITL-3-BOTTLE 10% OFF",
            "description": "REVITL-1-BOTTLE",
            "imagePath": "https:\/\/betterguthealthdaily.com\/images-prod\/rev-3.png",
            "imageId": 10,
            "price": "115.00",
            "shipPrice": "0.00",
            "category": "REVITIL",
            "variants": []
        },
        "7472": {
            "productId": 7472,
            "name": "REVITL-6-BOTTLE 10% OFF",
            "description": "REVITL-1-BOTTLE",
            "imagePath": "https:\/\/betterguthealthdaily.com\/images-prod\/rev-6.png",
            "imageId": 11,
            "price": "156.00",
            "shipPrice": "0.00",
            "category": "REVITIL",
            "variants": []
        }
    },
    "upsells": {
        "7031": {
            "productId": 7031,
            "name": "REVITL-6-BOTTLE",
            "description": "REVITL-1-BOTTLE",
            "imagePath": "https:\/\/betterguthealthdaily.com\/images-prod\/rev-6.png",
            "imageId": 11,
            "price": "174.00",
            "shipPrice": "0.00",
            "category": "REVITIL",
            "variants": []
        }
    },
    "shipProfiles": {
        "41": {
            "shipProfileId": 41,
            "freeShipThreshold": null,
            "profileName": "International",
            "isUpcharge": 0,
            "defaultShipping": 1,
            "applyEntireOrder": 1,
            "highestShipPriceOnly": 0,
            "shipCarrier": "UPS",
            "shipMethod": "Next Day Air",
            "rules": [
                {
                    "ruleId": 137,
                    "shipProfileId": 41,
                    "shipCarrier": "UPS",
                    "shipMethod": "Next Day Air",
                    "profileName": "International",
                    "applyEntireOrder": 1,
                    "isUpcharge": 0,
                    "productTypeSelect": "ENTIREORDER",
                    "campaignProductId": null,
                    "productCategoryId": null,
                    "shipPrice": "19.95",
                    "shipCost": "0.00",
                    "valueThreshold": "0.00",
                    "weightThreshold": "0.000",
                    "maxWeightThreshold": "0.000",
                    "itemCountThreshold": null,
                    "region": "REG_EU",
                    "state": null,
                    "ruleCarrier": null,
                    "ruleMethod": null,
                    "zoneId": null,
                    "productTags": null,
                    "currencySymbol": "$",
                    "categoryName": null,
                    "productName": null,
                    "countryName": null,
                    "campaignId": 92,
                    "tagCampaignProductIds": ""
                },
                {
                    "ruleId": 138,
                    "shipProfileId": 41,
                    "shipCarrier": "UPS",
                    "shipMethod": "Next Day Air",
                    "profileName": "International",
                    "applyEntireOrder": 1,
                    "isUpcharge": 0,
                    "productTypeSelect": "ENTIREORDER",
                    "campaignProductId": null,
                    "productCategoryId": null,
                    "shipPrice": "19.95",
                    "shipCost": "0.00",
                    "valueThreshold": "0.00",
                    "weightThreshold": "0.000",
                    "maxWeightThreshold": "0.000",
                    "itemCountThreshold": null,
                    "region": "CA",
                    "state": null,
                    "ruleCarrier": null,
                    "ruleMethod": null,
                    "zoneId": null,
                    "productTags": null,
                    "currencySymbol": "$",
                    "categoryName": null,
                    "productName": null,
                    "countryName": "Canada",
                    "campaignId": 92,
                    "tagCampaignProductIds": ""
                },
                {
                    "ruleId": 139,
                    "shipProfileId": 41,
                    "shipCarrier": "UPS",
                    "shipMethod": "Next Day Air",
                    "profileName": "International",
                    "applyEntireOrder": 1,
                    "isUpcharge": 0,
                    "productTypeSelect": "ENTIREORDER",
                    "campaignProductId": null,
                    "productCategoryId": null,
                    "shipPrice": "19.95",
                    "shipCost": "0.00",
                    "valueThreshold": "0.00",
                    "weightThreshold": "0.000",
                    "maxWeightThreshold": "0.000",
                    "itemCountThreshold": null,
                    "region": "AU",
                    "state": null,
                    "ruleCarrier": null,
                    "ruleMethod": null,
                    "zoneId": null,
                    "productTags": null,
                    "currencySymbol": "$",
                    "categoryName": null,
                    "productName": null,
                    "countryName": "Australia",
                    "campaignId": 92,
                    "tagCampaignProductIds": ""
                },
                {
                    "ruleId": 140,
                    "shipProfileId": 41,
                    "shipCarrier": "UPS",
                    "shipMethod": "Next Day Air",
                    "profileName": "International",
                    "applyEntireOrder": 1,
                    "isUpcharge": 0,
                    "productTypeSelect": "ENTIREORDER",
                    "campaignProductId": null,
                    "productCategoryId": null,
                    "shipPrice": "19.95",
                    "shipCost": "0.00",
                    "valueThreshold": "0.00",
                    "weightThreshold": "0.000",
                    "maxWeightThreshold": "0.000",
                    "itemCountThreshold": null,
                    "region": "NZ",
                    "state": null,
                    "ruleCarrier": null,
                    "ruleMethod": null,
                    "zoneId": null,
                    "productTags": null,
                    "currencySymbol": "$",
                    "categoryName": null,
                    "productName": null,
                    "countryName": "New Zealand",
                    "campaignId": 92,
                    "tagCampaignProductIds": ""
                }
            ]
        }
    },
    "defaultShipProfile": 41,
    "continents": {
        "AU": "AU",
        "CA": "NA",
        "DE": "EU",
        "FR": "EU",
        "GB": "EU",
        "IT": "EU",
        "NZ": "AU",
        "US": "NA"
    },
    "zones": {
        "1": {
            "zoneId": 1,
            "zoneName": "International",
            "countryCodes": "AD,AE,AF,AG,AI,AL,AM,AN,AO,AR,AS,AT,AU,AW,AX,AZ,BA,BB,BD,BE,BF,BG,BH,BI,BJ,BM,BN,BO,BR,BS,BT,BW,BY,BZ,CA,CC,CD,CF,CG,CH,CI,CL,CM,CN,CO,CR,CU,CV,CX,CY,CZ,DE,DJ,DK,DM,DO,DZ,EC,EE,EG,EH,ER,ES,ET,FI,FJ,FK,FM,FO,FR,GA,GB,GD,GE,GF,GH,GI,GL,GM,GN,GP,GQ,GR,GT,GW,GY,HK,HN,HR,HT,HU,ID,IE,IL,IM,IN,IO,IQ,IR,IS,IT,JE,JM,JO,JP,KE,KG,KH,KI,KM,KN,KP,KR,KW,KY,KZ,LA,LB,LC,LI,LK,LR,LS,LT,LU,LV,LY,MA,MC,MD,MG,MH,MK,ML,MM,MN,MP,MQ,MR,MS,MT,MU,MV,MW,MX,MY,MZ,NA,NE,NG,NI,NL,NO,NP,NR,NZ,OM,PA,PE,PF,PG,PH,PK,PL,PM,PR,PT,PW,PY,QA,RE,RO,RS,RU,RW,SA,SB,SC,SD,SE,SG,SH,SI,SJ,SK,SL,SM,SN,SO,SR,ST,SV,SY,SZ,TC,TD,TF,TG,TH,TJ,TM,TN,TO,TR,TT,TV,TW,TZ,UA,UG,UY,UZ,VA,VC,VE,VG,VI,VN,VU,WS,YE,YT,ZA,ZM,ZW",
            "stateCodes": null
        }
    },
    
    "insureShipPrice": null,
    "paypal": {
        "paypalBillerId": 24
    }
}';