<?php

KformConfig::setConfig(array(
	"isWordpress"=>false,
	"apiLoginId"=>"moderher_orders",
	"apiPassword"=>"moderher_orders",
	"authString"=>"b0317e854a192e6c6960ed8709df8d60",
	"autoUpdate_allowedIps"=>array("80.248.30.132"),
	"campaignId"=>56,
	"resourceDir"=>"resources/"));




/*
!---------------------------------IMPORTANT-----------------------------------!

Documentation:

    -Full documentation on landing pages can be found at

Auto-Update Feature:

    -The auto-update feature will automatically update settings on your landing page
    when you make changes to your campaign within the konnektive CRM. Use this feature
    to keep your landing page up-to-date concerning new coupons / shipping options
    and product changes.

    -To use the campaign auto-update feature, the apache or ngix user
    (depending on your httpd software) must have write access to this file

    -If you are not using the auto-update feature, you will need to manually
    replace this file after making changes to the campaign

!---------------------------------IMPORTANT-----------------------------------!
*/

class KFormConfig
{
    public $isWordpress = false;
    public $apiLoginId = '';
    public $apiPassword = '';
    public $resourceDir;
    public $baseDir;


    public $mobileRedirectUrl;
    public $desktopRedirectUrl;


    public $continents;
    public $countries;
    public $coupons;
    public $currencySymbol;
    public $currencyCode;
    public $insureShipPrice;
    public $landerType;
    public $offers;
    public $upsells;
    public $products;
    public $shipProfiles;
    public $states;
    public $taxes;
    public $termsOfService;
    public $webPages;
    public $zones;

    public static $instance = null;
    public static $options;
    public static $campaignData;
    // class constructor to set the variable values

    public static function setConfig($options)
    {
        self::$options = $options;
    }

    public function __construct()
    {
        if (!empty(self::$instance)) {
            throw new Exception("cannot recreated KFormConfig");
        }

        foreach ((array) self::$options as $k => $v) {
            $this->$k = $v;
        }

        if ($this->isWordpress) {
            $options = get_option('konnek_options');
            foreach ((array)$options as $k => $v) {
                $this->$k = $v;
            }

            $data = json_decode(get_option('konnek_campaign_data'));
            foreach ($data as $k => $v) {
                $this->$k = $v;
            }
        } elseif (!empty(self::$campaignData)) {
            if (json_decode(self::$campaignData) === null) {
                echo 'JSON in config.php is broken!';
                die;
            } else {
                $data = (array)json_decode(self::$campaignData);
            }


            foreach ($data as $k => $v) {
                $this->$k = $v;
            }
        }

        self::$instance = $this;
    }
}

/*
!---------------------------------IMPORTANT-----------------------------------!

    ABSOLUTELY DO NOT EDIT BELOW THIS LINE

!---------------------------------IMPORTANT-----------------------------------!
*/
$requestUri = $_SERVER['REQUEST_URI'];
$baseFile = basename(__FILE__);

if ($_SERVER['REQUEST_METHOD'] == 'POST' && strstr($requestUri, $baseFile)) {
    $authString = filter_input(INPUT_POST, 'authString', FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_LOW | FILTER_FLAG_STRIP_HIGH);
    if (empty($authString)) {
        die();
    } //exit silently, don't want people to know that this file processes api requests if they are just sending random posts at it


    $remoteIp = $_SERVER['REMOTE_ADDR'];
    if (isset($_SERVER["HTTP_CF_CONNECTING_IP"])) {
        $remoteIp = $_SERVER["HTTP_CF_CONNECTING_IP"];
    }

    $allowedIps = KFormConfig::$options['autoUpdate_allowedIps'];
    if (!in_array($remoteIp, $allowedIps)) {
        die("ERROR: Invalid IP Address. Please confirm that the Konnektive IP Address is in the allowedIps array.");
    }
    if ($authString != KFormConfig::$options['authString']) {
        die("ERROR: Could not authenticate authString. Please re-download code package and replace config file on your server.");
    }

    $data = filter_input(INPUT_POST, 'data');
    $data = trim($data);
    $data = utf8_encode($data);
    $decoded = json_decode($data);
    if ($decoded != null) {
        $file = fopen(__FILE__, 'r');
        if (empty($file)) {
            die("ERROR: File not writable");
        }

        $new_file = '';

        while ($line = fgets($file)) {
            $new_file .= $line;

            if (strpos($line, "/*[DYNAMIC-DATA-TOKEN]") === 0) {
                break;
            }
        }
        fclose($file);

        $new_file .= "KFormConfig::\$campaignData = '$data';".PHP_EOL;
        $ret = file_put_contents(__FILE__, $new_file);


        if (is_int($ret)) {
            die("SUCCESS");
        } else {
            die("ERROR: File not writable");
        }
    } else {
        die("ERROR: what data");
    }
}

/*[DYNAMIC-DATA-TOKEN] do not remove */
KFormConfig::$campaignData = '{
    "countries": {
        "US": "United States",
        "CA": "Canada",
        "AU": "Australia",
        "IE": "Ireland",
        "NZ": "New Zealand",
        "GB": "United Kingdom"
    },
    "states": {
        "GB": {
            "ABE": "Aberdeen City",
            "ABD": "Aberdeenshire",
            "ANS": "Angus",
            "ANT": "Antrim",
            "ARD": "Ards",
            "AGB": "Argyll and Bute",
            "ARM": "Armagh",
            "BLA": "Ballymena",
            "BLY": "Ballymoney",
            "BNB": "Banbridge",
            "BDG": "Barking and Dagenham",
            "BNE": "Barnet",
            "BNS": "Barnsley",
            "BAS": "Bath and North East Somerset",
            "BBO": "Bedford Borough",
            "BDF": "Bedfordshire",
            "BFS": "Belfast",
            "BRK": "Berkshire",
            "BEX": "Bexley",
            "BIR": "Birmingham",
            "BBD": "Blackburn with Darwen",
            "BPL": "Blackpool",
            "BGW": "Blaenau Gwent",
            "BOL": "Bolton",
            "BMH": "Bournemouth",
            "BRC": "Bracknell Forest",
            "BRD": "Bradford",
            "BEN": "Brent",
            "BGE": "Bridgend",
            "BNH": "Brighton and Hove",
            "BST": "Bristol, City of",
            "BRY": "Bromley",
            "BUC": "Buckingham",
            "BKM": "Buckinghamshire",
            "BUR": "Bury",
            "CAY": "Caerphilly",
            "CLD": "Calderdale",
            "CAM": "Cambridgeshire",
            "CMD": "Camden",
            "CRF": "Cardiff",
            "CMN": "Carmarthenshire",
            "CKF": "Carrickfergus",
            "CSR": "Castlereagh",
            "CGN": "Ceredigion",
            "CHS": "Cheshire",
            "CHE": "Cheshire East",
            "CWC": "Cheshire West and Chester",
            "CLK": "Clackmannanshire",
            "CLR": "Coleraine",
            "CWY": "Conwy",
            "CKT": "Cookstown",
            "CON": "Cornwall",
            "COV": "Coventry",
            "CGV": "Craigavon",
            "CRY": "Croydon",
            "CMA": "Cumbria",
            "DAL": "Darlington",
            "DEN": "Denbighshire",
            "DER": "Derby",
            "DBY": "Derbyshire",
            "DRY": "Derry",
            "DEV": "Devon",
            "DNC": "Doncaster",
            "DOR": "Dorset",
            "DOW": "Down",
            "DUD": "Dudley",
            "DGY": "Dumfries and Galloway",
            "DND": "Dundee City",
            "DGN": "Dungannon",
            "DUR": "Durham",
            "EAL": "Ealing",
            "EAY": "East Ayrshire",
            "EDU": "East Dunbartonshire",
            "ELN": "East Lothian",
            "ERW": "East Renfrewshire",
            "ERY": "East Riding of Yorkshire",
            "ESX": "East Sussex",
            "EDH": "Edinburgh, City of",
            "ELS": "Eilean Siar",
            "ENF": "Enfield",
            "ESS": "Essex",
            "FAL": "Falkirk",
            "FER": "Fermanagh",
            "FIF": "Fife",
            "FLN": "Flintshire",
            "GAT": "Gateshead",
            "GLG": "Glasgow City",
            "GLS": "Gloucestershire",
            "GLO": "Greater London",
            "GRE": "Greenwich",
            "GGY": "Guernsey",
            "GWN": "Gwynedd",
            "HCK": "Hackney",
            "HAL": "Halton",
            "HMF": "Hammersmith and Fulham",
            "HAM": "Hampshire",
            "HRY": "Haringey",
            "HRW": "Harrow",
            "HPL": "Hartlepool",
            "HAV": "Havering",
            "HEF": "Herefordshire, County of",
            "HRT": "Hertfordshire",
            "HTF": "Hertfordshire",
            "HLD": "Highland",
            "HIL": "Hillingdon",
            "HNS": "Hounslow",
            "IVC": "Inverclyde",
            "AGY": "Isle of Anglesey",
            "IOM": "Isle of Man",
            "IOW": "Isle of Wight",
            "IOS": "Isles of Scilly",
            "ISL": "Islington",
            "JEY": "Jersey",
            "KEC": "Kensington and Chelsea",
            "KEN": "Kent",
            "KHL": "Kingston upon Hull, City of",
            "KTT": "Kingston upon Thames",
            "KIR": "Kirklees",
            "KWL": "Knowsley",
            "LBH": "Lambeth",
            "LAN": "Lancashire",
            "LRN": "Larne",
            "LDS": "Leeds",
            "LCE": "Leicester",
            "LEC": "Leicestershire",
            "LEW": "Lewisham",
            "LMV": "Limavady",
            "LIN": "Lincolnshire",
            "LSB": "Lisburn",
            "LIV": "Liverpool",
            "LND": "London, City of",
            "LUT": "Luton",
            "MFT": "Magherafelt",
            "MAN": "Manchester",
            "MDW": "Medway",
            "MSY": "Merseyside",
            "MTY": "Merthyr Tydfil",
            "MRT": "Merton",
            "MDB": "Middlesbrough",
            "MDX": "Middlesex",
            "MLN": "Midlothian",
            "MIK": "Milton Keynes",
            "MON": "Monmouthshire",
            "MRY": "Moray",
            "MYL": "Moyle",
            "NTL": "Neath Port Talbot",
            "NET": "Newcastle upon Tyne",
            "NWM": "Newham",
            "NWP": "Newport",
            "NYM": "Newry and Mourne",
            "NTA": "Newtownabbey",
            "NFK": "Norfolk",
            "NAY": "North Ayrshire",
            "NDN": "North Down",
            "NEL": "North East Lincolnshire",
            "NLK": "North Lanarkshire",
            "NLN": "North Lincolnshire",
            "NSM": "North Somerset",
            "NTY": "North Tyneside",
            "NYK": "North Yorkshire",
            "NTH": "Northamptonshire",
            "NBL": "Northumberland",
            "NGM": "Nottingham",
            "NTT": "Nottinghamshire",
            "OLD": "Oldham",
            "OMH": "Omagh",
            "ORK": "Orkney Islands",
            "OXF": "Oxfordshire",
            "PEM": "Pembrokeshire",
            "PKN": "Perth and Kinross",
            "PTE": "Peterborough",
            "PLY": "Plymouth",
            "POL": "Poole",
            "POR": "Portsmouth",
            "POW": "Powys",
            "RDG": "Reading",
            "RDB": "Redbridge",
            "RCC": "Redcar and Cleveland",
            "RFW": "Renfrewshire",
            "RCT": "Rhondda, Cynon, Ta",
            "RIC": "Richmond upon Thames",
            "RCH": "Rochdale",
            "ROT": "Rotherham",
            "RUT": "Rutland",
            "SLF": "Salford",
            "SAW": "Sandwell",
            "SCB": "Scottish Borders, The",
            "SFT": "Sefton",
            "SHF": "Sheffield",
            "ZET": "Shetland Islands",
            "SHR": "Shropshire",
            "SLG": "Slough",
            "SOL": "Solihull",
            "SOM": "Somerset",
            "SAY": "South Ayrshire",
            "SGC": "South Gloucestershire",
            "SLK": "South Lanarkshire",
            "STY": "South Tyneside",
            "SYK": "South Yorkshire",
            "STH": "Southampton",
            "SOS": "Southend-on-Sea",
            "SWK": "Southwark",
            "SHN": "St. Helens",
            "STS": "Staffordshire",
            "STG": "Stirling",
            "SKP": "Stockport",
            "STT": "Stockton-on-Tees",
            "STE": "Stoke-on-Trent",
            "STB": "Strabane",
            "SFK": "Suffolk",
            "SND": "Sunderland",
            "SRY": "Surrey",
            "STN": "Sutton",
            "SWA": "Swansea",
            "SWD": "Swindon",
            "TAM": "Tameside",
            "TFW": "Telford and Wrekin",
            "THR": "Thurrock",
            "TOB": "Torbay",
            "TOF": "Torfaen",
            "TWH": "Tower Hamlets",
            "TRF": "Trafford",
            "VGL": "Vale of Glamorgan, T",
            "WKF": "Wakefield",
            "WLL": "Walsall",
            "WFT": "Waltham Forest",
            "WND": "Wandsworth",
            "WRT": "Warrington",
            "WAR": "Warwickshire",
            "WBK": "West Berkshire",
            "WDU": "West Dunbartonshire",
            "WLN": "West Lothian",
            "WMD": "West Midlands",
            "WSX": "West Sussex",
            "WYK": "West Yorkshire",
            "WSM": "Westminster",
            "WGN": "Wigan",
            "WIL": "Wiltshire",
            "WNM": "Windsor and Maidenhead",
            "WRL": "Wirral",
            "WOK": "Wokingham",
            "WLV": "Wolverhampton",
            "WOC": "Worcester",
            "WOR": "Worcestershire",
            "WRX": "Wrexham",
            "YOR": "York"
        },
        "CA": {
            "AB": "Alberta",
            "BC": "British Columbia",
            "MB": "Manitoba",
            "NB": "New Brunswick",
            "NL": "Newfoundland and Labrador",
            "NT": "Northwest Territories",
            "NS": "Nova Scotia",
            "NU": "Nunavut",
            "ON": "Ontario",
            "PE": "Prince Edward Island",
            "QC": "Quebec",
            "SK": "Saskatchewan",
            "YT": "Yukon"
        },
        "NZ": {
            "AUK": "Auckland",
            "BOP": "Bay of Plenty",
            "CAN": "Canterbury",
            "CIT": "Chatham Islands Territory",
            "GIS": "Gisborne District",
            "HKB": "Hawkes\u0027s Bay",
            "MWT": "Manawatu-Wanganui",
            "MBH": "Marlborough District",
            "NSN": "Nelson City",
            "N": "North Island",
            "NTL": "Northland",
            "OTA": "Otago",
            "S": "South Island",
            "STL": "Southland",
            "TKI": "Taranaki",
            "TAS": "Tasman District",
            "WKO": "Waikato",
            "WGN": "Wellington",
            "WTC": "West Coast"
        },
        "AU": {
            "ACT": "Australian Capital Territory",
            "NSW": "New South Wales",
            "NT": "Northern Territory",
            "QLD": "Queensland",
            "SA": "South Australia",
            "TAS": "Tasmania",
            "VIC": "Victoria",
            "WA": "Western Australia"
        },
        "IE": {
            "CW": "Carlow",
            "CN": "Cavan",
            "CE": "Clare",
            "CK": "Cork",
            "DL": "Donegal",
            "DN": "Dublin",
            "GY": "Galway",
            "KY": "Kerry",
            "KE": "Kildare",
            "KK": "Kilkenny",
            "LS": "Laois",
            "LM": "Leitrim",
            "LK": "Limerick",
            "LD": "Longford",
            "LH": "Louth",
            "MO": "Mayo",
            "MH": "Meath",
            "MN": "Monaghan",
            "OY": "Offaly",
            "RN": "Roscommon",
            "SO": "Sligo",
            "TA": "Tipperary",
            "WD": "Waterford",
            "WH": "Westmeath",
            "WX": "Wexford",
            "WW": "Wicklow"
        },
        "US": {
            "AL": "Alabama",
            "AK": "Alaska",
            "AZ": "Arizona",
            "AR": "Arkansas",
            "CA": "California",
            "CO": "Colorado",
            "CT": "Connecticut",
            "DE": "Delaware",
            "DC": "District of Columbia",
            "FL": "Florida",
            "GA": "Georgia",
            "HI": "Hawaii",
            "ID": "Idaho",
            "IL": "Illinois",
            "IN": "Indiana",
            "IA": "Iowa",
            "KS": "Kansas",
            "KY": "Kentucky",
            "LA": "Louisiana",
            "ME": "Maine",
            "MD": "Maryland",
            "MA": "Massachusetts",
            "MI": "Michigan",
            "MN": "Minnesota",
            "MS": "Mississippi",
            "MO": "Missouri",
            "MT": "Montana",
            "NE": "Nebraska",
            "NV": "Nevada",
            "NH": "New Hampshire",
            "NJ": "New Jersey",
            "NM": "New Mexico",
            "NY": "New York",
            "NC": "North Carolina",
            "ND": "North Dakota",
            "OH": "Ohio",
            "OK": "Oklahoma",
            "OR": "Oregon",
            "PA": "Pennsylvania",
            "RI": "Rhode Island",
            "SC": "South Carolina",
            "SD": "South Dakota",
            "TN": "Tennessee",
            "TX": "Texas",
            "UT": "Utah",
            "VT": "Vermont",
            "VA": "Virginia",
            "WA": "Washington",
            "WV": "West Virginia",
            "WI": "Wisconsin",
            "WY": "Wyoming",
            "AS": "American Samoa",
            "FM": "Federated States of Micronesia",
            "GU": "Guam",
            "MP": "Northern Mariana Islands",
            "PR": "Puerto Rico",
            "MH": "Republic of Marshall Islands",
            "VI": "Virgin Islands of the U.S.",
            "AA": "Armed Forces Americas",
            "AE": "Armed Forces Canada, Armed Forces Europe, Armed Forces Middle East, Armed Forces Africa",
            "AP": "Armed Forces Pacific"
        }
    },
    "currencySymbol": "$",
    "shipOptions": {
        "42": {
            "campaignId": 56,
            "shipProfileId": 42,
            "shipMethod": null,
            "shipCarrier": "UPS"
        }
    },
    "coupons": {
        "SAVE20": {
            "couponDiscountPrice": null,
            "couponDiscountPerc": "0.2000",
            "isRecurring": 0,
            "recurringDiscountPrice": null,
            "recurringDiscountPerc": null,
            "discountType": "PERCENT",
            "maxCycles": null,
            "campaignProductId": null,
            "applyTo": "BASE_PRICE",
            "defaultCoupon": 0,
            "startDate": null,
            "endDate": null,
            "oncePerOrder": 0,
            "couponMax": 1
        }
    },
    "products": [],
    "webPages": {
        "checkoutPage": {
            "disableBack": 0,
            "url": "https:\/\/betterguthealthdaily.com\/health-tips1\/checkout.php",
            "autoImportLead": 1,
            "productId": 6802,
            "requireSig": 0,
            "sigType": 0,
            "cardinalAuth": 0,
            "paayApiKey": null
        },
        "presellPage": {
            "disableBack": 0,
            "url": "https:\/\/betterguthealthdaily.com\/health-tips1\/index.php",
            "fireClickPixel": 1
        },
        "thankyouPage": {
            "disableBack": 0,
            "url": "https:\/\/betterguthealthdaily.com\/health-tips1\/thankyou.php",
            "createAccountDialog": 0,
            "reorderUrl": null,
            "allowReorder": 0
        },
        "upsellPage1": {
            "disableBack": 1,
            "url": "https:\/\/betterguthealthdaily.com\/health-tips1\/upsell1.php",
            "createAccountDialog": 0,
            "requirePayInfo": 0,
            "productId": 8110,
            "replaceProductId": null
        }
    },
    "landerType": "SINGLE",
    "googleTrackingId": null,
    "currencyCode": "USD",
    "enableFraudPlugin": 1,
    "autoTax": 0,
    "taxServiceId": null,
    "kountMerchantId": "200650",
    "companyName": "anthony_alayon_llc",
    "offers": {
        "3149": {
            "productId": 3149,
            "name": "Probio-Lite (1 bottle)",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "69.00",
            "shipPrice": "8.95",
            "category": "Golden After 50",
            "variants": []
        },
        "3150": {
            "productId": 3150,
            "name": "Probio-Lite (1 bottle - 10% OFF)",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "62.00",
            "shipPrice": "8.95",
            "category": "Golden After 50",
            "variants": []
        },
        "3151": {
            "productId": 3151,
            "name": "Probio-Lite (3 bottles)",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "171.00",
            "shipPrice": "0.00",
            "category": "Golden After 50",
            "variants": []
        },
        "3152": {
            "productId": 3152,
            "name": "Probio-Lite (3 bottles - 10% OFF)",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "153.00",
            "shipPrice": "0.00",
            "category": "Golden After 50",
            "variants": []
        },
        "3153": {
            "productId": 3153,
            "name": "Probio-Lite (6 bottles)",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "294.00",
            "shipPrice": "0.00",
            "category": "Golden After 50",
            "variants": []
        },
        "3154": {
            "productId": 3154,
            "name": "Probio-Lite (6 bottles - 10% OFF)",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "264.00",
            "shipPrice": "0.00",
            "category": "Golden After 50",
            "variants": []
        },
        "3159": {
            "productId": 3159,
            "name": "Probio-Lite (1 bottle)",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "49.95",
            "shipPrice": "8.95",
            "category": "Golden After 50",
            "variants": []
        },
        "3160": {
            "productId": 3160,
            "name": "Probio-Lite (1 bottle - 10% OFF)",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "44.95",
            "shipPrice": "8.95",
            "category": "Golden After 50",
            "variants": []
        },
        "3161": {
            "productId": 3161,
            "name": "Probio-Lite (3 bottles)",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "134.85",
            "shipPrice": "0.00",
            "category": "Golden After 50",
            "variants": []
        },
        "3162": {
            "productId": 3162,
            "name": "Probio-Lite (3 bottles - 10% OFF)",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "119.85",
            "shipPrice": "0.00",
            "category": "Golden After 50",
            "variants": []
        },
        "3163": {
            "productId": 3163,
            "name": "Probio-Lite (6 bottles)",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "239.70",
            "shipPrice": "0.00",
            "category": "Golden After 50",
            "variants": []
        },
        "3164": {
            "productId": 3164,
            "name": "Probio-Lite (6 bottles - 10% OFF)",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "209.70",
            "shipPrice": "0.00",
            "category": "Golden After 50",
            "variants": []
        },
        "3971": {
            "productId": 3971,
            "name": "Probio-Lite (1 bottle) AOV MC",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "49.95",
            "shipPrice": "8.95",
            "category": "Golden After 50",
            "variants": []
        },
        "3972": {
            "productId": 3972,
            "name": "Probio-Lite (1 bottle - 10% OFF) AOV MC",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "44.95",
            "shipPrice": "8.95",
            "category": "Golden After 50",
            "variants": []
        },
        "3973": {
            "productId": 3973,
            "name": "Probio-Lite (3 bottles) AOV MC",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "134.85",
            "shipPrice": "0.00",
            "category": "Golden After 50",
            "variants": []
        },
        "3974": {
            "productId": 3974,
            "name": "Probio-Lite (3 bottles - 10% OFF) AOV MC",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "119.85",
            "shipPrice": "0.00",
            "category": "Golden After 50",
            "variants": []
        },
        "3975": {
            "productId": 3975,
            "name": "Probio-Lite (6 bottles) AOV MC",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "239.70",
            "shipPrice": "0.00",
            "category": "Golden After 50",
            "variants": []
        },
        "3976": {
            "productId": 3976,
            "name": "Probio-Lite (6 bottles - 10% OFF) AOV MC",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "264.00",
            "shipPrice": "0.00",
            "category": "Golden After 50",
            "variants": []
        },
        "4128": {
            "productId": 4128,
            "name": "Probio-Lite (1 bottle) n-us",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "49.95",
            "shipPrice": "19.95",
            "category": "Golden After 50",
            "variants": []
        },
        "4129": {
            "productId": 4129,
            "name": "Probio-Lite (1 bottle - 10% OFF) n-us",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "44.95",
            "shipPrice": "19.95",
            "category": "Golden After 50",
            "variants": []
        },
        "6800": {
            "productId": 6800,
            "name": "Probio-Lite (6 bottles+ 6 bottles)",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "294.00",
            "shipPrice": "0.00",
            "category": "Golden After 50",
            "variants": []
        },
        "6801": {
            "productId": 6801,
            "name": "Probio-Lite (3 bottles)",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "177.00",
            "shipPrice": "0.00",
            "category": "Golden After 50",
            "variants": []
        },
        "6802": {
            "productId": 6802,
            "name": "Probio-Lite (1 bottle)",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "69.00",
            "shipPrice": "8.95",
            "category": "Golden After 50",
            "variants": []
        },
        "6803": {
            "productId": 6803,
            "name": "Probio-Lite (6 bottles+ 6 bottles)",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "264.00",
            "shipPrice": "0.00",
            "category": "Golden After 50",
            "variants": []
        },
        "6804": {
            "productId": 6804,
            "name": "Probio-Lite (3 bottles)",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "159.00",
            "shipPrice": "0.00",
            "category": "Golden After 50",
            "variants": []
        },
        "6805": {
            "productId": 6805,
            "name": "Probio-Lite (1 bottle)",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "62.00",
            "shipPrice": "8.95",
            "category": "Golden After 50",
            "variants": []
        },
        "8103": {
            "productId": 8103,
            "name": "Probio-Lite (1 bottle)",
            "description": "*No description available",
            "imagePath": "\/\/betterguthealthdaily.com\/images\/pb-1.webp",
            "imageId": null,
            "price": "49.00",
            "shipPrice": "8.95",
            "category": "Golden After 50",
            "variants": []
        },
        "8104": {
            "productId": 8104,
            "name": "Probio-Lite (3 bottles)",
            "description": "*No description available",
            "imagePath": "\/\/betterguthealthdaily.com\/images\/pb-3.webp",
            "imageId": null,
            "price": "117.00",
            "shipPrice": "0.00",
            "category": "Golden After 50",
            "variants": []
        },
        "8105": {
            "productId": 8105,
            "name": "Probio-Lite (6 bottles)",
            "description": "*No description available",
            "imagePath": "\/\/betterguthealthdaily.com\/images\/pb-6.webp",
            "imageId": null,
            "price": "174.00",
            "shipPrice": "0.00",
            "category": "Golden After 50",
            "variants": []
        },
        "8106": {
            "productId": 8106,
            "name": "Probio-Lite (1 bottle - 10% OFF)",
            "description": "*No description available",
           "imagePath": "\/\/betterguthealthdaily.com\/images\/pb-1.webp",
            "imageId": null,
            "price": "44.00",
            "shipPrice": "8.95",
            "category": "Golden After 50",
            "variants": []
        },
        "8107": {
            "productId": 8107,
            "name": "Probio-Lite (3 bottles - 10% OFF)",
            "description": "*No description available",
            "imagePath": "\/\/betterguthealthdaily.com\/images\/pb-3.webp",
            "imageId": null,
            "price": "105.30",
            "shipPrice": "0.00",
            "category": "Golden After 50",
            "variants": []
        },
        "8108": {
            "productId": 8108,
            "name": "Probio-Lite (6 bottles - 10% OFF)",
            "description": "*No description available",
            "imagePath": "\/\/betterguthealthdaily.com\/images\/pb-6.webp",
            "imageId": null,
            "price": "156.00",
            "shipPrice": "0.00",
            "category": "Golden After 50",
            "variants": []
        },
        "8109": {
            "productId": 8109,
            "name": "Probio-Lite (1 bottle - 10% OFF)",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "30.00",
            "shipPrice": "0.00",
            "category": "Golden After 50",
            "variants": []
        }
    },
    "upsells": {
        "3155": {
            "productId": 3155,
            "name": "Probio-Lite (6 bottles)",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "150.00",
            "shipPrice": "0.00",
            "category": "Golden After 50",
            "variants": []
        },
        "3156": {
            "productId": 3156,
            "name": "Probio-Lite (3 bottles)",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "75.00",
            "shipPrice": "0.00",
            "category": "Golden After 50",
            "variants": []
        },
        "3157": {
            "productId": 3157,
            "name": "PuriCleanse (3 bottles)",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "99.00",
            "shipPrice": "0.00",
            "category": "Golden After 50",
            "variants": []
        },
        "3158": {
            "productId": 3158,
            "name": "PuriCleanse (2 bottles)",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "33.00",
            "shipPrice": "0.00",
            "category": "Golden After 50",
            "variants": []
        },
        "3901": {
            "productId": 3901,
            "name": "Probio-Lite (3 bottles)",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "97.00",
            "shipPrice": "0.00",
            "category": "Golden After 50",
            "variants": []
        },
        "3902": {
            "productId": 3902,
            "name": "Probio-Lite (3 bottles)",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "77.00",
            "shipPrice": "0.00",
            "category": "Golden After 50",
            "variants": []
        },
        "3978": {
            "productId": 3978,
            "name": "Probio-Lite (3 bottles - jumbo size) AOV MC",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "59.85",
            "shipPrice": "0.00",
            "category": "Golden After 50",
            "variants": []
        },
        "3979": {
            "productId": 3979,
            "name": "Probio-Lite (Add 6 Bottles) AOV MC",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "119.70",
            "shipPrice": "0.00",
            "category": "Golden After 50",
            "variants": []
        },
        "3980": {
            "productId": 3980,
            "name": "PuriCleanse (3+2free bottles) AOV MC",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "99.00",
            "shipPrice": "0.00",
            "category": "Golden After 50",
            "variants": []
        },
        "3981": {
            "productId": 3981,
            "name": "PuriCleanse (1+1free bottles) AOV MC",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "33.00",
            "shipPrice": "0.00",
            "category": "Golden After 50",
            "variants": []
        },
        "8110": {
            "productId": 8110,
            "name": "Probio-Lite (2 bottle)",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "54.00",
            "shipPrice": "0.00",
            "category": "Golden After 50",
            "variants": []
        },
        "8111": {
            "productId": 8111,
            "name": "Probio-Lite (3 bottles)",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "81.00",
            "shipPrice": "0.00",
            "category": "Golden After 50",
            "variants": []
        },
        "8112": {
            "productId": 8112,
            "name": "Probio-Lite (6 bottles)",
            "description": "*No description available",
            "imagePath": "\/\/images.konnektive.com\/unavailable.png",
            "imageId": null,
            "price": "162.00",
            "shipPrice": "0.00",
            "category": "Golden After 50",
            "variants": []
        }
    },
    "shipProfiles": {
        "42": {
            "shipProfileId": 42,
            "freeShipThreshold": null,
            "profileName": "International",
            "isUpcharge": 0,
            "defaultShipping": 1,
            "applyEntireOrder": 1,
            "highestShipPriceOnly": 0,
            "shipCarrier": "UPS",
            "shipMethod": null,
            "rules": [
                {
                    "ruleId": 141,
                    "shipProfileId": 42,
                    "shipCarrier": "UPS",
                    "shipMethod": null,
                    "profileName": "International",
                    "applyEntireOrder": 1,
                    "isUpcharge": 0,
                    "productTypeSelect": "ENTIREORDER",
                    "campaignProductId": null,
                    "productCategoryId": null,
                    "shipPrice": "19.95",
                    "shipCost": "0.00",
                    "valueThreshold": "0.00",
                    "weightThreshold": "0.000",
                    "maxWeightThreshold": "0.000",
                    "itemCountThreshold": null,
                    "region": "REG_EU",
                    "state": null,
                    "ruleCarrier": null,
                    "ruleMethod": null,
                    "zoneId": null,
                    "productTags": null,
                    "currencySymbol": "$",
                    "categoryName": null,
                    "productName": null,
                    "countryName": null,
                    "campaignId": 56,
                    "tagCampaignProductIds": ""
                },
                {
                    "ruleId": 142,
                    "shipProfileId": 42,
                    "shipCarrier": "UPS",
                    "shipMethod": null,
                    "profileName": "International",
                    "applyEntireOrder": 1,
                    "isUpcharge": 0,
                    "productTypeSelect": "ENTIREORDER",
                    "campaignProductId": null,
                    "productCategoryId": null,
                    "shipPrice": "19.95",
                    "shipCost": "0.00",
                    "valueThreshold": "0.00",
                    "weightThreshold": "0.000",
                    "maxWeightThreshold": "0.000",
                    "itemCountThreshold": null,
                    "region": "CA",
                    "state": null,
                    "ruleCarrier": null,
                    "ruleMethod": null,
                    "zoneId": null,
                    "productTags": null,
                    "currencySymbol": "$",
                    "categoryName": null,
                    "productName": null,
                    "countryName": "Canada",
                    "campaignId": 56,
                    "tagCampaignProductIds": ""
                },
                {
                    "ruleId": 143,
                    "shipProfileId": 42,
                    "shipCarrier": "UPS",
                    "shipMethod": null,
                    "profileName": "International",
                    "applyEntireOrder": 1,
                    "isUpcharge": 0,
                    "productTypeSelect": "ENTIREORDER",
                    "campaignProductId": null,
                    "productCategoryId": null,
                    "shipPrice": "19.95",
                    "shipCost": "0.00",
                    "valueThreshold": "0.00",
                    "weightThreshold": "0.000",
                    "maxWeightThreshold": "0.000",
                    "itemCountThreshold": null,
                    "region": "AU",
                    "state": null,
                    "ruleCarrier": null,
                    "ruleMethod": null,
                    "zoneId": null,
                    "productTags": null,
                    "currencySymbol": "$",
                    "categoryName": null,
                    "productName": null,
                    "countryName": "Australia",
                    "campaignId": 56,
                    "tagCampaignProductIds": ""
                },
                {
                    "ruleId": 144,
                    "shipProfileId": 42,
                    "shipCarrier": "UPS",
                    "shipMethod": null,
                    "profileName": "International",
                    "applyEntireOrder": 1,
                    "isUpcharge": 0,
                    "productTypeSelect": "ENTIREORDER",
                    "campaignProductId": null,
                    "productCategoryId": null,
                    "shipPrice": "19.95",
                    "shipCost": "0.00",
                    "valueThreshold": "0.00",
                    "weightThreshold": "0.000",
                    "maxWeightThreshold": "0.000",
                    "itemCountThreshold": null,
                    "region": "NZ",
                    "state": null,
                    "ruleCarrier": null,
                    "ruleMethod": null,
                    "zoneId": null,
                    "productTags": null,
                    "currencySymbol": "$",
                    "categoryName": null,
                    "productName": null,
                    "countryName": "New Zealand",
                    "campaignId": 56,
                    "tagCampaignProductIds": ""
                }
            ]
        }
    },
    "defaultShipProfile": 42,
    "continents": {
        "AU": "AU",
        "CA": "NA",
        "GB": "EU",
        "IE": "EU",
        "NZ": "AU",
        "US": "NA"
    },
    "zones": {
        "1": {
            "zoneId": 1,
            "zoneName": "International",
            "countryCodes": "AD,AE,AF,AG,AI,AL,AM,AN,AO,AR,AS,AT,AU,AW,AX,AZ,BA,BB,BD,BE,BF,BG,BH,BI,BJ,BM,BN,BO,BR,BS,BT,BW,BY,BZ,CA,CC,CD,CF,CG,CH,CI,CL,CM,CN,CO,CR,CU,CV,CX,CY,CZ,DE,DJ,DK,DM,DO,DZ,EC,EE,EG,EH,ER,ES,ET,FI,FJ,FK,FM,FO,FR,GA,GB,GD,GE,GF,GH,GI,GL,GM,GN,GP,GQ,GR,GT,GW,GY,HK,HN,HR,HT,HU,ID,IE,IL,IM,IN,IO,IQ,IR,IS,IT,JE,JM,JO,JP,KE,KG,KH,KI,KM,KN,KP,KR,KW,KY,KZ,LA,LB,LC,LI,LK,LR,LS,LT,LU,LV,LY,MA,MC,MD,MG,MH,MK,ML,MM,MN,MP,MQ,MR,MS,MT,MU,MV,MW,MX,MY,MZ,NA,NE,NG,NI,NL,NO,NP,NR,NZ,OM,PA,PE,PF,PG,PH,PK,PL,PM,PR,PT,PW,PY,QA,RE,RO,RS,RU,RW,SA,SB,SC,SD,SE,SG,SH,SI,SJ,SK,SL,SM,SN,SO,SR,ST,SV,SY,SZ,TC,TD,TF,TG,TH,TJ,TM,TN,TO,TR,TT,TV,TW,TZ,UA,UG,UY,UZ,VA,VC,VE,VG,VI,VN,VU,WS,YE,YT,ZA,ZM,ZW",
            "stateCodes": null
        }
    },
    "taxes": [],
    "paypal": {
        "paypalBillerId": 32
    }
}';