<?php
//This code must be included at the top of your script before any output is sent to the browser
//-even before <!DOCTYPE> declaration
require_once realpath(dirname(__FILE__)."/resources/konnektiveSDK.php");
$pageType = "checkoutPage"; //choose from: catalogPage, checkoutPage, upsellPage1, upsellPage2, upsellPage3, upsellPage4, thankyouPage
$deviceType = "ALL"; //choose from: DESKTOP, MOBILE, ALL
$ksdk = new KonnektiveSDK($pageType,$deviceType);
$productId = $ksdk->page->productId;
$offer = $ksdk->getProduct((int) $productId);
$cartId = $ksdk->sanitizeInput("cartId","STR",INPUT_GET);


?>
<!DOCTYPE html>
<html>
<head>

<meta name="viewport" content="width=device-width" />
<meta charset="utf-8" />

<?php 
//this line of code must go either inside the <head> </head> tags or inside the <body></body> tags
$ksdk->echoJavascript();
?>
</head>
<body>

        
<!-- All ktemplate class divs are for presentation purposes only and can be replaced with your own styling and html elements -->      
<div class='ktemplate_pageContainer'>
		<div class='ktemplate_header'>
    	<h1> Your Header </h1>
    </div>
    <br><br>
        
	<div class='ktemplate_boxLeft'>
		<input type="hidden" name="salesUrl" value="<?= $ksdk->getPageUrl(checkoutPage) ?>">
			<div class="kform_productBox">
                <img src="<?php echo $offer->imagePath; ?>" class="kform_productBoxImage">
                <h3> <?php echo $offer->name; ?> </h3>
                
                <?php echo $offer->description; ?>
                
                <div style="clear:both"></div>
            </div>
        
        	 <div class='ktemplate_priceLowerRight'>
            

                <table class='kcartTotals'>
					<tr>
                    	<td>Sub Total</td>
                        <td class='kcartSubTotal'>0.00</td>
                    </tr>
                    <tr>
                    	<td>Shipping</td>
                        <td class='kcartShipTotal'>0.00</td>
                    </tr>
                    <tr>
                    	<td>Sales Tax</td>
                        <td class='kcartSalesTax'>0.00</td>
                    </tr>
                    <tr>
                    	<td>Discount</td>
                        <td class='kcartDiscount'>0.00</td>
                    </tr>
                    <tr>
                    	<td>Insurance</td>
                        <td class='kcartInsurance'>0.00</td>
                    </tr>
                    <tr>
                    	<td><b>Grand Total</b></td>
                        <td class='kcartGrandTotal'>0.00</td>
                    </tr>
                </table>
	            
            </div>
            			<br>
            <br>
            <div id="orderCoupons">
            <!--Applied coupons show here.-->
            </div>
        </div>
        
		<div class='ktemplate_boxRight'>
        
        
            <form id='kform' class='kform' onsubmit='return false;'>
            
            	<input type="hidden" name="productId" value="<?= $productId ?>">            
            
            	            
            <div id='formfields'>
            
				<div class="kform_spacer">
                    <input name="firstName" type="TEXT" isRequired >
                </div>
                <div class="kform_spacer">
                    <input name="lastName" type="TEXT" isRequired >
                </div>
				
				<div class="kform_spacer">
                    <input name="emailAddress" type="TEXT" isRequired >
                </div>
				
				<div class="kform_spacer">
                    <input name="phoneNumber" type="TEXT" isRequired>
                </div>
                    <div class='kform_spacer'>
                        <input name='shipAddress1' type='TEXT' isRequired >
                    </div>

                    <div class='kform_spacer'>
                        <input name='shipAddress2' type='TEXT'>
                    </div>

                    <div class='kform_spacer'>
                        <input name='shipCity' type='TEXT' isRequired>
                    </div>

                    <div class='kform_spacer'>
                        <select name='shipState' isRequired>
                        </select>
                    </div>

                    <div class='kform_spacer'>
                        <select name='shipCountry'></select>
                    </div>

                     <div class='kform_spacer'>
                        <input name='shipPostalCode' type='TEXT' isRequired >
                    </div>
            <div class='kform_spacer kform_checkbox'>
                <input name='billShipSame' type='CHECKBOX' checked>
                <label for='billShipSame'>
                    Billing Address same as Shipping
                </label>
            </div>
            <div id='kform_hiddenAddress'>
				<div class='kform_spacer'>
                    <input name='address1' type='TEXT' isRequired>
                </div>

                <div class='kform_spacer'>
                    <input name='address2' type='TEXT'>
                </div>

                <div class='kform_spacer'>
                    <input name='city' type='TEXT' isRequired>
                </div>

                <div class='kform_spacer'>
                    <select name='state' isRequired>
                        <option value=''>Select State</option>
                    </select>
                </div>

                <div class='kform_spacer'>
                    <select name='country' defaultText='country'>
                    </select>
                </div>

                 <div class='kform_spacer'>
                    <input name='postalCode' type='TEXT' isRequired>
                </div>
			</div>
            
                    <input type="hidden" name='paySource' value="CREDITCARD">
                    <div class='kform_spacer'>
                        Credit Card:<br>
                        <div style='display:none'>
                            <div id='kformPaySourceWrap' inputType='radio'></div>
                            <div class='kform_spacer' id='kformNewPaymentType'>
                                <input type='checkbox' name='newPaymentType'>
                                <span>
                                New Credit Card
                            </span>
                            </div>
                        </div>
                    </div>
                
                   <div id='kform_paySourceCard'>
                       <div class='kform_spacer'>
                            <input name='cardNumber' type='TEXT' maxlength=16 isRequired >
                        </div>

                        <div class='kform_spacer'>
                            <input name='cardSecurityCode' type='TEXT' maxlength=4>
                        </div>

                        <div class='kform_spacer' style='text-align:right'>
                            <label for='cardMonth'  style='width:30%;text-align:middle;'>
                                Expiration:
                            </label>
                            <select name='cardMonth' style='width:30%' isRequired >
                                <option value='01'>01 (Jan)</option>
                                <option value='02'>02 (Feb)</option>
                                <option value='03'>03 (Mar)</option>
                                <option value='04'>04 (Apr)</option>
                                <option value='05'>05 (May)</option>
                                <option value='06'>06 (Jun)</option>
                                <option value='07'>07 (Jul)</option>
                                <option value='08'>08 (Aug)</option>
                                <option value='09'>09 (Sep)</option>
                                <option value='10'>10 (Oct)</option>
                                <option value='11'>11 (Nov)</option>
                                <option value='12'>12 (Dec)</option>
                            </select>
                            <select name='cardYear' style='width:30%' isRequired >
                                <option value='2023'>2023</option><option value='2024'>2024</option><option value='2025'>2025</option><option value='2026'>2026</option><option value='2027'>2027</option><option value='2028'>2028</option><option value='2029'>2029</option><option value='2030'>2030</option><option value='2031'>2031</option><option value='2032'>2032</option><option value='2033'>2033</option><option value='2034'>2034</option><option value='2035'>2035</option><option value='2036'>2036</option><option value='2037'>2037</option><option value='2038'>2038</option><option value='2039'>2039</option><option value='2040'>2040</option><option value='2041'>2041</option><option value='2042'>2042</option><option value='2043'>2043</option>                            </select>
                        </div>
                    </div>
                  				</div>
                              
                <input type='button' value='Rush My Order!' class='kform_submitBtn' id='kformSubmit'>
                <input type="hidden" name="cartId" value="<?=$cartId?>">

                            
 
					
				<br>
				<!--place this anywhere on the page. It is the signin button for paypal -->
				<?php $ksdk->echoPaypalCheckoutButton(); ?>
				
								<input type='hidden' name='orderItems' value=''>
            </form>
        </div>
       </div>
        

</body>
</html>







